<?php

namespace App\Console\Commands;

use App\Models\Site\SiteInfo;
use App\User;
use App\Notifications\NotifyInactiveUsers;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Contracts\Queue\ShouldQueue;

class EmailInactiveUsers extends Command implements ShouldQueue
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'email:inactive-users';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send Mail To Inactive Users Command';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {


    /*    $user = SiteInfo::find(17);
        $user->notify(new NotifyInactiveUsers());
        $this->info('mail to '.$user->site_email);*/

        $limit=Carbon::now()->subDay(5);
      $inactive_users= User::whereId(4)->get();
        foreach ($inactive_users as $user){
            $user->notify(new NotifyInactiveUsers());
             $this->info('mail to '.$user->email);

        }
    }
}
