<?php
/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/7/2016
 * Time: 11:34 AM
 */

namespace App\Forms;

use App\Models\EmployeePosition\EmpPosition;

class EmpPositionForm extends EmpPosition implements FormInterface
{
    use FormControll, DataHelper;

    public function formInputFields($id = null,$mode=null)
    {
        return[
            [
                'type'=>'select',
                'name'=>self::EMP_CATEGORY_ID,
                'label' => 'Employee Category',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'options'=>$this->emcategoryList(),
                'value'=>$id?null:0,
                'validation'=>"required|in:".$this->emcategoryKeys()
            ],
            [
                'type'=>'text',
                'name'=>self::NAME,
                'label' => 'Position Name',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'trans'=>true,
                //'validation'=>'required|unique:emp_position_translations,name,'.$id.',emp_position_id,site_id'.session()->get(SITE_ID),
                'validation'=>'required|unique:emp_position_translations,name,'.$id.',emp_position_id,site_id,'.session()->get(SITE_ID),
                'others'=>['class'=>'form-control']
            ],
            [
                'type'=>'radio',
                'name'=>self::STATUS,
                'label' => 'Status',
                'radval'=> ['Active'=>'Active','Inactive'=>'Inactive'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'validation'=>'required',
                'checked'=>'Active',
                'others'=>['class'=>'form-control']
            ],
            /*[
                'type'=>'submit',
                'label' => 'Submit',
                'others'=>['class'=>'btn btn-success']

            ]*/
            submitBtn($id),
        ];
    }
}