<?php
/**
 * Created by PhpStorm.
 * User: tiash
 * Date: 5/2/2016
 * Time: 3:34 PM
 */

namespace App\Forms;

use App\Http\Requests\Request;
use App\Http\Requests\Validator;
use Illuminate\Support\Facades\Input;
use App\Models\Floor\Floor;

class FloorForm extends Floor implements FormInterface
{
    use FormControll, DataHelper;

    protected $nonEditableFields = [];

    public function formInputFields($id = null, $mode = null)
    {
        return[
            [
                'type'=>'select',
                'name'=>self::BUILDING,
                'label' => 'Building Name',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'options'=>$this->buildingList(),
                'value'=>0,
                'validation' => 'unique:site_floors,floor_name,'.$id.',id,building_id,'.Input::get(self::BUILDING).',site_id,'.session()->get(SITE_ID)
            ],
            [
                'type'=>'text',
                'name'=>self::FLOOR_NAME,
                'label' => 'Floor Name',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                ],
                'validation'=>'required'
            ],
            [
                'type'=>'radio',
                'name'=>self::STATUS,
                'label' => 'Status',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'radval'=> ['Active'=>'Active','Inactive'=>'Inactive'],
                'checked' => 'Active',
                'validation'=>"required"
            ],
            /*[
                'type'=>'submit',
                'label' => 'Submit',
                'others'=>[
                    'class'=>'btn btn-success',
                    'style'=>'background-color:#0073b7',
                    'readonly'=>'readonly'
                ],
            ]*/
            submitBtn($id),
        ];
    }
}