<?php
/**
 * Created by PhpStorm.
 * User: raja
 * Date: 5/10/16
 * Time: 9:47 AM
 */

namespace App\Forms;


use App\Models\Marks\MarksType;
use Illuminate\Support\Facades\Input;

class MarksTypeForm extends MarksType implements FormInterface
{
    use FormControll,DataHelper;

    public function formInputFields($id = null, $mode = null)
    {
        return [
            [
                'type'=>'text',
                'name'=>self::MARKS_TYPE,
                'label' => 'Marks Type',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                ],
                //'validation'=>'required|unique:marks_types,'.self::MARKS_TYPE.','.$id,
                'validation'=>'required|unique:marks_types,marks_type,'.$id.',id,site_id,'.session()->get(SITE_ID),
                //'validation'=>'required|unique:gender_translations,gender_name,'.$id.',gender_id,site_id,'.session()->get(SITE_ID),
            ],
            [
                'type'=>'radio',
                'name'=>self::STATUS,
                'label' => 'Status',
                'radval'=> [1=>'Active',0=>'Inactive'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'others'=>[
                    'class'=>'form-control',
                ],
                'validation'=>'required',
                'checked'=>1

            ],
            /*[
                'type'=>'submit',
                'label' => 'Submit',
                'others'=>[
                    'class'=>'btn btn-success',
                    'readonly'=>'readonly'
                ],
            ]*/
            submitBtn($id),
        ];
    }
}