<?php
/**
 * Created by PhpStorm.
 * User: raja
 * Date: 5/24/16
 * Time: 2:33 PM
 */

namespace App\Forms;


use App\Models\Menu\Menu;
use Illuminate\Support\Facades\Input;

class MenuForm extends Menu implements FormInterface
{
    use FormControll, DataHelper;

    public function formInputFields($id = null, $mode = null)
    {
        $mode_class = (isset($id) && !empty($id)) ? "readonly" : "";
        return [
            [
                'type'=>'text',
                'name'=>self::MENU_NAME,
                'label' => trans('forms.menu.add.label.menu'),
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'trans'=>true,
                'validation'=>'required|unique:menu_translations,menu_name,'.$id.',menu_id',
                'others'=>['class'=>'form-control']
            ],
            [
                'type'=>'select',
                'name'=>self::MENU_FOR,
                'label' => trans('forms.menu.add.label.menu_for'),
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'options'=>$this->menuForList(),
                'validation'=>'required',
                'others'=>['class'=>'form-control']
            ],
            [
                'type'=>'text',
                'name'=>self::ICON,
                'label' => trans('forms.menu.add.label.icon_name'),
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'trans'=>false,
                'others'=>['class'=>'form-control']
            ],
            [
                'type'=>'text',
                'name'=>self::ROUTE_NAME,
                'label' => trans('forms.menu.add.label.route_name'),
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'trans'=>false,
                'validation'=>'required|unique:menus,route_name,'.$id,
                'others'=>["class"=>"form-control"]
            ],
            [
                'type'=>'textarea',
                'name'=>self::NOTE,
                'label' => trans('forms.menu.add.label.note'),
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'trans'=>false,
                'others'=>["class"=>"form-control"]
            ],
            [
                'type'=>'select',
                'name'=>self::PARENT_ID,
                'label' => trans('forms.menu.add.label.parent'),
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'options'=>$this->menusList(),
                'value'=>null,
//                'validation'=>"required|in:".$this->roleKeys()
            ],
            [
                'type'=>'number',
                'name'=>self::POSITION,
                'label' => trans('forms.menu.add.label.position'),
                'div' => true,
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'trans'=>false,
                'validation'=>'required|unique:menus,position,'.$id.',id,parent_id,'.Input::get('parent_id'),
                'others'=>["class"=>"form-control"]
            ],
            [
                'type'=>'radio',
                'name'=>self::STATUS,
                'label' => trans('forms.menu.add.label.status'),
                'radval'=> [1=>'Active',0=>'Inactive'],
                'checked' => 1,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'others'=>[
                    'class'=>'form-control',
                ],
                'validation'=>'required',

            ],
            [
                'type'=>'radio',
                'name'=>self::IS_DISPLAYABLE,
                'label' => trans('forms.menu.add.label.is_displayable'),
                'radval'=> [1=>'Yes',0=>'No'],
                'checked' => 0,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'others'=>[
                    'class'=>'form-control',
                ],
                'validation'=>'required',

            ],
            [
                'type'=>'radio',
                'name'=>self::IS_LOGGED_COMMON_ACCESS,
                'label' => trans('forms.menu.add.label.is_logged_common_access'),
                'radval'=> [1=>'Yes',0=>'No'],
                'checked' => 0,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'others'=>[
                    'class'=>'form-control',
                ],
                'validation'=>'required',

            ],
            [
                'type'=>'radio',
                'name'=>self::IS_COMMON_ACCESS,
                'label' => trans('forms.menu.add.label.is_common_access'),
                'radval'=> [1=>'Yes',0=>'No'],
                'checked' => 0,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'others'=>[
                    'class'=>'form-control',
                ],
                'validation'=>'required',

            ],
            /*[
                'type'=>'submit',
                'label' => 'Submit',
                'others'=>['class'=>'btn btn-success']

            ]*/
            submitBtn($id),
        ];
    }
}