<?php
/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 4/30/2016
 * Time: 4:24 PM
 */

namespace App\Forms;

use App\Models\Subject\Subject;
use Illuminate\Support\Facades\Input;


class SubjectForm extends Subject implements FormInterface
{
    use FormControll, DataHelper;

    protected $nonEditableFields = [];

    public function formInputFields($id = null, $mode = null)
    {
//dd($id);
        return [
            [
                'type'=>'select',
                'name'=>self::CLASS_ID,
                'label' => 'Class Name',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'trans'=>false,
                'options'=>$this->classList(),
                'value'=>null,
                'validation'=>"required|in:".$this->classKeys()

            ],
       /*     [
                'type'=>'select',
                'name'=>self::TEACHER,
                'label' => 'Teacher Name',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'trans'=>false,
                'options'=>$this->teacherList(),
                'value'=>null,
//                'validation'=>"required|in:".$this->teacherKeys()

            ],*/
            [
                'type'=>'text',
                'name'=>self::SUBJECT_NAME,
                'label' => 'Subject Name',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                    'placeholder'=>'Please Type Subject Name'
                ],
                'validation' => 'required|unique:subjects,subject_name,'.$id.',id,student_class_id,'.Input::get(self::CLASS_ID)
                //'validation' => 'required|unique:subjects,section_name,'.$id.',id,student_class_id,'.Input::get(self::STUDENT_CLASS).',site_id,'.session()->get(SITE_ID)


            ],
        /*    [
                'type'=>'text',
                'name'=>self::SUBJECT_AUTHOR,
                'label' => 'Subject Author',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                    'placeholder'=>'Please Type Subject Author'
                ]
            ],
            [
                'type'=>'text',
                'name'=>self::SUBJECT_CODE,
                'label' => 'Subject Code',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                    'placeholder'=>'Please Type Subject Code'
                ],
                'validation'=>'required|unique:subjects,subject_code,'.$id
            ],
            [
                'type'=>'text',
                'name'=>self::SUBJECT_CREDIT,
                'label' => 'Subject Credit',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                    'placeholder'=>'Please Type Subject Credit'
                ],
                'validation'=>'required'
            ],
               [
                   'type'=>'select',
                   'name'=>self::RESULT_SYSTEM,
                   'label' => 'Result System',
                   'others'=>['class'=>'form-control'],
                   'labclass'=>'col-sm-12',
                   'wrapclass'=>'col-sm-12',
                   'trans'=>false,
                   'options'=>$this->resultSystemList(),
                   'value'=>null,
                   'validation'=>"required|in:".$this->resultSysKeys()
               ],
         /*      [
                   'type'=>'select',
                   'name'=>self::COMBINESUBJECT,
                   'label' => 'Combine Subject',
                   'others'=>['class'=>'form-control'],
                   'labclass'=>'col-sm-12',
                   'wrapclass'=>'col-sm-12',
                   'trans'=>false,
                   //'options'=> $this->subjectList(),
                   'options'=>$id ? $this->subjectList(): ['Select Class First'],
                   //'validation'=>"in:".$this->combineNameKeys(),
                   'value'=>null,

               ],*/
        /*    [
                'type'=>'text',
                'name'=>self::COMBINE_NAME,
                'label' => 'Combine Name',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                    'placeholder'=>'Please Type Combine Name'
                ],
              'validation'=>'required_if:combine_subject,'.$this->combineNameKeys()
            ],
            [
                'type'=>'marksTypeTable',
//                'name'=>self::SUBJECT_MARK_TYPE.'[]',
                'label' => 'Mark Types',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'value'=> $id ? $this->getSubjectMarksTypeInfo($id) : 0,
            ],
            [
                'type'=>'number',
                'name'=>self::SUBJECT_TOTAL_MARKS,
                'label' => 'Total Marks',
                'value'=>null,
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12 ',
                'trans'=>false,
                'others'=>[
                    'class'=>'form-control',
                    'placeholder'=>'Please Type Total Mark'
                ],
                'validation'=>'required'
            ],*/
            [
                'type'=>'radio',
                'name'=>self::STATUS,
                'label' => 'Status',
                'others'=>['class'=>'form-control'],
                'labclass'=>'col-sm-12',
                'wrapclass'=>'col-sm-12',
                'radval'=> ['Active'=>'Active','Inactive'=>'Inactive'],
                'validation'=>"required",
                'checked'=>'Active'
            ],
            submitBtn($id)
        ];
    }

}