<?php

namespace App\Http\Controllers\AcademicAll;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\Academic\AcademicFee;
use App\Forms\AcademicClassForm;
//use App\Http\Controllers\Controller;
use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Student\Student;
use App\Models\Student\AcademicClassModel;
use App\Models\SubjectGroup\SubjectGroup;
use App\Models\Student\Section;
use App\Models\Status\Status;
use App\Http\Requests\Validator;
use App\Models\User\User;
//use Illuminate\Http\Request;
use App\Http\Requests;
use Response;


class AcademicFeeController extends Controller
{
    use Lang, FormControll, DataHelper;

    private $academicFee;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct(AcademicFee $academicFee)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicFee = $academicFee;
    }


    public function index()
    {

        $viewType = 'Fee List';
        //$classList = $academicClass->with('classTeacher')->paginate(20);
        // dd($classList);
        return view('default.admin.academic-fee.create', compact('viewType'));


    }

    public function getAccademicFeeList(){

        $feeList = $this->academicFee->paginate(2);
//        $feeLst =  AcademicFee::all();
        //dd($list);
        return $feeList;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function createAccademicFee(Request $request)
    {

        //dd($request);
        $this->validate($request,[
            'name'=>'required|unique:academic_fees'

        ]);

        $this->academicFee->create([
            'name'=>$request->get('name'),
            'status'=>$request->get('status'),
        ]);

        return Response::json(['message' => 'Subject Condition Successfully Created!']);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function editAccademicFee(Request $request, $id)
    {

        //dd('ok');

        $this->validate($request,[
            'name'=>'required|unique:academic_fees'

        ]);

        $academicFee = $this->academicFee->findOrFail($id);

        $academicFee->update([
            'name'=>$request->get('name'),
            'status'=>$request->get('status'),
        ]);

        return Response::json(['message' => 'Academic Fee Successfully Updated!']);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteAccademicFee($id)
    {
        $academicfeeToDelete = $this->academicFee->findOrFail($id);

        $academicfeeToDelete->delete();
        return Response::json(['message' => 'Academic Fee Successfully Deleted!']);
    }
}
