<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicFeeGroup;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo;
use Session;

class AcademicFeeGroupController extends Controller
{

    private $academicFeeGroup;

    public function __construct(AcademicFeeGroup $academicFeeGroup)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicFeeGroup = $academicFeeGroup;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Fee Head List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic-fee-group.view', compact('viewType'));
    }


    public function getFeeGroupList()
    {
        $feeGroups = new AcademicFeeGroup();
        $feeGroupsList = $feeGroups->get();

        return $feeGroupsList;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:academic_fee_groups',

        ]);

        $feeSubHeads=AcademicFeeGroup::create([
            'name' => $request->name,
            'head_key' => $request->head_key,
            'status' => $request->status
        ]);
        return ['message' => 'Successfully Saved!'];
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
//        $request->validate([
//            'name' => 'required|unique:academic_fee_groups',
//            'head_key' => 'required|unique:academic_fee_groups',
//
//        ]);

        $feeGroupUpdate = $this->academicFeeGroup->findOrFail($id);

        $feeGroupUpdate->update([
            'name'=>$request->get('name'),
            'head_key'=>$request->get('head_key'),
            'status'=>$request->get('status'),
        ]);

        return ['message' => 'Successfully Updated!'];
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $feeGroupDelete = $this->academicFeeGroup->findOrFail($id);

        $feeGroupDelete->delete();
        return ['message' => 'Successfully Deleted!'];
    }
}
