<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicSession;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;

class AcademicSessionController extends Controller
{
    private $academicSession;
    public function __construct(AcademicSession $academicSession)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->academicSession = $academicSession;

    }

    public function index(Request $request){
        $viewType = 'Academic Session Add';
        return view('default.admin.layouts.master', compact('viewType'));

    }

   

    public function createSessionForm(Request $request){
        $viewType = 'Academic Session Add';
        return view('default.admin.layouts.master', compact('viewType'));

    }

    public function createSession(Request $request){
        $this->validate($request, [
            'session_name' => 'required',
        ]);

       $insert = AcademicSession::insert([
        'session_name'=>$request->session_name,
        'serial_no'=>$request->serial_no,
        'status'=>$request->status,
       ]);

        if ($insert) {
             return response()->json(['message' => 'Successfully Created', 'mode' => 'Success'], 200);
        }
   
    }

    public function getSessionWithPagination(Request $request){
    {
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';
        $class_list = $this->academicSession
            ->when($search_txt, function ($q) use ($txt) {
                $q->where('session_name', 'LIKE', $txt);
            })
            ->orderBy('serial_no', 'ASC')
            ->paginate($paginate);
        return response()->json($class_list, 200);
    }
    }

    public  function  academicSessionList()
    {

        if(Session::get('SITE_ID')){

            $siteSessionlist=SiteInfo::where('id', Session::get('SITE_ID'))->first();
          //  dd(Session::get('SITE_ID'));

            $Sessionlistsplite = explode(',', $siteSessionlist->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();

            return $Sessionlist;
        }
        else{
            $Sessionlist = AcademicSession::get();
        }

        return $Sessionlist;
    }

    
    /**
     * @param $id
     * @param AcademicClassForm $academicClassForm
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function editSessionForm()
    {
        $viewType = 'Edit Class';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic.class.edit', compact('classData', 'viewType', 'editClass'));
    }

    /**
     * @param $id
     * @param Validator $validatedRequest
     * @return mixed
     */
    public function updateSession(Request $request)
    {
        $sessionData = $this->academicSession->findOrFail($request->id);
        $this->validate($request, [
            'session_name' => 'required',
        ]);

        $update = AcademicSession::where('id',$request->id)->update([
           // 'session_name'=>$request->session_name,
            'serial_no'=>$request->serial_no,
            'status'=>$request->status,
           ]);

           if($update) {
             return response()->json(['message' => 'Successfully Created', 'mode' => 'Success'], 200);
            }
        
    }

    /**
     * @param $id
     * @return $this
     */
    public function deleteClass($id)
    {
        // $isExistInGroup = DB::select('SELECT * FROM site_group_settings WHERE FIND_IN_SET(?,academic_class_ids) > 0 LIMIT 1;', [$id]);
        // $isExistInSite = DB::select('SELECT * FROM site_infos WHERE FIND_IN_SET(?,academic_class_ids) > 0 LIMIT 1;', [$id]);


        // if (count($isExistInGroup) > 0) {
        //     return back()->withErrors('Dependency Found in Site Group Settings:  ID: ' . $isExistInGroup[0]->id);
        // }
        // if (count($isExistInSite) > 0) {
        //     return back()->withErrors('Dependency Found in Site Group Settings:  ID: ' . $isExistInSite[0]->id);
        // }
        // $menuToDelete = $this->menu->findOrFail($id);
        // if ($menuToDelete->delete()) {
        //     return back()->withSuccess('The Route Successfully Deleted');
        // }


        // $classToDelete = $this->academicClass->findOrFail($id);
        // if ($classToDelete->delete()) {
        //     return back()->withSuccess('Successfully deleted');
        // }

        // return back()->withErrors('Not successfully deleted');
    }

   
}
