<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicSubject;
USE App\Models\Academic\AcademicClass;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Language\Lang;
use League\Flysystem\Exception;

use Response;

class AcademicSubjectController extends Controller
{

    use Lang;

    private $academicSubject;

    public function __construct(AcademicSubject $academicSubject)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker', ['except' => 'getAcademicSubjectListBySite']);

        $this->academicSubject = $academicSubject;
    }

    /**
     * /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Academic Subject List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic-subject.subject-list', compact('viewType'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return JsonResponse
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'subject_name_en' => 'required|unique:academic_subject_translations,subject_name',
            'subject_name_bn' => 'unique:academic_subject_translations,subject_name',
            'belongs_to_academic_group' => 'required'

        ]);
        $academic = AcademicSubject::create([
            'subject_name' => $request->subject_name,
            'belongs_to_academic_group' => $request->belongs_to_academic_group
        ]);
        $this->translatedAttrToSave($academic, $request);
        return Response::json(['message' => 'Subject Successfully Created!']);
    }


    private function translatedAttrToSave(AcademicSubject $academic_subject, Request $request)
    {
        //dd($validatedRequest->first_name);
        foreach ($academic_subject->translatedAttributes as $field) {
            foreach ($this->locales() as $locale => $value) {
                if ($request->get($field . '_' . $locale)) {
                    $academic_subject->translateOrNew($locale)->{$field} = $request->get($field . '_' . $locale);
                }
            }
        }
        //dd($user->first_name);

        if ($academic_subject->save()) {

            return true;
        }
        return false;
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return JsonResponse
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'subject_name_en' => 'required|unique:academic_subject_translations,subject_name,' . $id . ',academic_subject_id',
            'subject_name_bn' => 'unique:academic_subject_translations,subject_name,' . $id . ',academic_subject_id',
            'belongs_to_academic_group' => 'required'
        ]);
        $theSubject = AcademicSubject::findOrFail($id);
        $theSubject->update([
            'subject_name' => $request->subject_name,
            'belongs_to_academic_group' => $request->belongs_to_academic_group
        ]);

        $this->translatedAttrToSave($theSubject, $request);

        return Response::json(['message' => 'Subject Successfully Updated!']);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return JsonResponse
     */
    public function destroy($id)
    {
        try {

            $theSubject = AcademicSubject::findOrFail($id);
            if (count($theSubject->classes)) {
                return Response::json(['message' => 'Subject is already attached With Class: ' . $theSubject->classes->first()->class_name]);

            }

            $theSubject->delete();   //delete data from academic_subject table.
            $theSubject->deleteTranslations();// delete data from academic_subject_translations table.

            return Response::json(['message' => 'Subject Successfully Deleted!']);
        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);

        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Subject Not Found!'], 405);

        }
    }

    //Api List================================================Api ----------------------------------------


    public function getAcademicSubjectList(Request $request)
    {
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $txt = '%' . $search_txt . '%';

        $subjects = $this->academicSubject
            ->with('classes')
            ->when($search_txt, function ($q) use ($txt) {
                $q->whereTranslationLike('subject_name', $txt);
            })
            ->orderByTranslation('subject_name', 'ASC')
            ->paginate($paginate);
        return $subjects;
    }

    public function getAcademicSubjectListWithoutPagination()
    {
        $subjects = AcademicSubject::all();
        return [$subjects];
    }

    public function getAcademicClassListWithSelectedClass($id)
    {

        $classes = AcademicClass::all();

        $theSubject = AcademicSubject::findOrFail($id);
        $selectedClass = $theSubject->classes->pluck('id') ?? [];

        return [$classes, $selectedClass];
    }

    public function attachClassToSubject(Request $request)
    {

        $this->validate($request, [
            'subject_id' => 'required',
            'class_ids' => 'required'
        ]);
        $subject_id = $request->subject_id;
        $class_ids = $request->class_ids;

        $subject = AcademicSubject::findOrFail($subject_id);
        $subject->classes()->sync($class_ids);

        return Response::json(['message' => ' Classes Attachment Done Successfully!']);
    }


    public function getVersionAndYearAndShiftWiseAcademicSubjectListBySiteAndAcademicGroup($site_id, $academic_group, $version_id, $shift_id, $year_id)
    {
        $site_subject_ids =
        $subjects = AcademicSubject::with('classes');
        return $subjects;
    }

}
