<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicVersion;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;

class AcademicVersionController extends Controller
{

    private $academicVersion;

    public function __construct(AcademicVersion $academicVersion)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicVersion = $academicVersion;
    }


    public function siteBaseVersionList()
    {

        $SiteInfoTableData=SiteInfo::select('academic_version_ids')
            ->where('id',(Session::get(SITE_ID)))->first();


        $academicVersionIDs=explode(',',$SiteInfoTableData->academic_version_ids);

        $academicVersionList  = AcademicVersion::select ('id','version_name')
            ->whereIn('id',$academicVersionIDs)
            ->get();


        return $academicVersionList;
    }
}
