<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Session;

class AcademicYearController extends Controller
{
    private $academicYear;

    public function __construct(AcademicYear $academicyear)
    {
        $this->middleware('auth');
     //   $this->middleware('eduworlduserchecker');
        $this->academicYear = $academicyear;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
//        $academicYearList = $this->academicYear->paginate(5);
//
//        dd($academicYearList);
//        return view('default.admin.academic-year.index',compact('academicYearList'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $viewType = 'Academic Year';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic-year.create', compact('viewType', 'academicYearList', 'mode'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            "year_name" => "required",
            "start_date" => "required",
            "end_date" => "required",
            "serial_no" => "required"
        ]);
        //$current_date_time = Carbon::now();

        if ($request->startdate > $request->enddate) {
            return back()->withInput()->withError('Start Date must be ');
        }

        $this->academicYear->start_date = date("Y/m/d", strtotime($request->start_date));
        $this->academicYear->end_date = date("Y/m/d", strtotime($request->end_date));
        $this->academicYear->year_name = $request->year_name;
        $this->academicYear->status = $request->academicYearStatus;
        $this->academicYear->serial_no = $request->serial_no;
        $this->academicYear->save();


        return response()->json(['message' => 'Successfully Created'], 200);

    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $viewType = 'Edit AcademicGroup Year';
        $mode = false;
        $singleAcademicYear = $this->academicYear->findOrFail($id);
        $academicYearList = $this->academicYear->paginate(5);
        return view('default.admin.academic-year.create', compact('viewType', 'academicYearList', 'singleAcademicYear', 'mode'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {

        $academicYear_Update = $this->academicYear->findOrFail($request->id);
        $academicYear_Update->start_date = date("Y-m-d", strtotime($request->start_date));
        $academicYear_Update->end_date = date("Y-m-d", strtotime($request->end_date));
        $academicYear_Update->year_name = $request->year_name;
        $academicYear_Update->serial_no = $request->serial_no;
        $academicYear_Update->status = $request->status;
        $academicYear_Update->save();

        return response()->json(['message' => 'Successfully Update']);
    }


    public function active_inactive($id)
    {
        $academicYear_Activate = $this->academicYear->findOrFail($id);
        if ($academicYear_Activate->status == 0) {
            $academicYear_Activate->status = 1;
        } else {
            $academicYear_Activate->status = 0;
        }
        $academicYear_Activate->save();
        return redirect()->route('academic-year-create')->withSuccess('Successfully Activated');
    }


    public function academicYearList()
    {
        if (Session::get('SITE_ID')) {
           
           // $siteSessionlist = SiteInfo::select('academic_year_ids')->where('id', Session::get('SITE_ID'))->first();
           $siteSessionlist = SiteInfoSetting::first();
           $Sessionlistsplite = explode(',', $siteSessionlist->academic_year_ids);
           $year_list = AcademicYear::whereIn('id', $Sessionlistsplite)->orderBy('id','desc')->get();

        } else {
            $year_list = AcademicYear::orderBy('serial_no','DESC')->paginate(50);
        }
        return $year_list;
    }


    public function academicYearListBySiteId($site_id, $acc_group_id)
    {

        $siteSessionlist = SiteInfoSetting::select('academic_year_ids')->where('site_id', $site_id)->where('academic_group_id', $acc_group_id)->first();
        $Sessionlistsplite = explode(',', $siteSessionlist->academic_year_ids);
        $year_list = AcademicYear::whereIn('id', $Sessionlistsplite)->get();
        return $year_list;

    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return response()->json(['message' => 'Contact to DevTeam!'],413);

        $academicYear_Delete = $this->academicYear->findOrFail($id);
        $academicYear_Delete->delete();

    }
}
