<?php

namespace App\Http\Controllers\Api\Edu\Site;

use App\Models\Edu\NewSite\Application;
use App\Models\Image\Photo;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class NewSiteApplicationApiController extends Controller
{
    private $application;

    public function __construct(Application $application)
    {
        $this->middleware('auth:api');
        $this->middleware('api.access');
        $this->application = $application;
    }


    public function getList(Request $request)
    {


        $search_txt = $request->search_txt;
        $paginate = $request->paginate ?? 20;
        $txt = '%' . $search_txt . '%';


        $menus = $this->application
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->where('site_name', 'LIKE', $txt);
                });
            })->orderBy('id', 'DESC')
            ->paginate($paginate);

        return Response::json($menus, 200);

    }

    public function edit($id)
    {


        $the_app = $this->application
            ->findOrFail($id);

        return Response::json($the_app, 200);

    }

    public function getTheApplication($id)
    {
        $the_app = $this->application
            ->findOrFail($id);

        return Response::json($the_app, 200);

    }

    public function update(Request $request)
    {

        $this->validate($request, [
            "academic_group_ids" => "required",
            "site_name" => "required",
            "board_id" => "required",
            "first_name" => "required",
            "country_id" => "required",
            "division_id" => "required",
            "district_id" => "required",
            "thana_id" => "required",
            "address" => "required",
            "eiin" => "required",
            "site_email" => "required|unique:edu_newsite_applications,site_email," . $request->id . ',id',
            "site_phone" => "required|unique:edu_newsite_applications,site_phone," . $request->id . ',id'

        ]);


        $this->application = $this->application->findOrFail($request->id);

        if (isset($this->application->ownfields)) {

            foreach ($this->application->ownfields as $ownField) {
                if ($request->{$ownField}) {
                    if (is_array($request->{$ownField})) {
                        $this->application->{$ownField} = implode(',', $request->{$ownField});
                    } else {
                        $this->application->{$ownField} = $request->{$ownField};
                    }
                }
            }
            $this->application->status = $request->status;
        }


        if ($this->application->save()) {
            return Response::json(['message' => 'Successfully Updated', 'mode' => 'Update'], 200);

        }
    }


    public function delete($id)
    {
        try {

            $the_event = $this->application->findOrFail($id);
            $the_event->delete();
            $this->deleteFiles($the_event);

            return Response::json(['message' => 'Successfully Deleted!'], 200);


        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }

    // private function deleteFiles($the_item)
    // {


    //     if ($the_item->headImage->id) {
    //         $the_photo = Photo::where('id', $the_item->headImage->id)->first();
    //         $image_path = public_path($the_photo->path);
    //         if (File::exists($image_path)) {
    //             unlink($image_path);
    //         }
    //         $the_photo->delete();
    //     }
    // }

    private function deleteFiles($the_item)
    {

        if ($the_item->siteLogoImage->id) {
            $the_photo = Photo::where('id', $the_item->siteLogoImage->id)->first();
            $image_path = public_path($the_photo->path);
            if (File::exists($image_path)) {
                unlink($image_path);
            }
            $the_photo->delete();
        }
    }

}
