<?php

namespace App\Http\Controllers\Api\EmployeePanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\Relation\Relation;
use App\Models\Site\Batch\BatchDetail;
use App\Models\Site\Employee\Employee;
use App\Models\Site\SiteClassSessionSerialSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\User\User;

use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Exception;
use Session;
use Response;

class AcademicApiController extends ApiProjectController
{
    public function __construct()
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');

    }

    public function getAcademicGroupList()
    {
        try {

            $auth=Auth::user();

            $the_site = SiteInfo::findOrFail($auth->site_id);

            $academicGroup = explode(',', $the_site->academic_group_ids);
            $academic_group_list = AcademicGroup::whereIn('id', $academicGroup)->orderBy('serial')
                ->select('id','academic_group_name','academic_key')
                ->get();

            $data=[
                'academic_group_list'=>$academic_group_list,
                'mode'=>'success',
                'status'=>'200',
            ];
    
            return response()->json($data, 200);

        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Site Info Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

 

    public function getEmployeeProfileForApi(Request $request){

        try{

        $auth= Auth::user();
        $this->siteInfoSessionPut($request);

        $user_info=Employee::with([ 'latestPhoto','presentCountry','permanentCountry','presentDivision','permanentDivision','presentDistrict',
        'permanentDistrict','presentThana','permanentThana','bloodGroup', 'gender','religion'])
            ->where('id', $auth->id)
            ->where('status',true)
            ->orderBy('id','DESC')
            ->first();
          //  dd($user_info);
           if(!$user_info){
             return response()->json(['message'=>'Employee Not Found', 'status'=>'422', 'mode'=>'errors', 422]); 
           }

            $present_address=[];
            $present_address['country_name']=$user_info->presentCountry?$user_info->presentCountry->country_name:'';
            $present_address['division_name']=$user_info->presentDivision?$user_info->presentDivision->division_name:'';
            $present_address['district_name']=$user_info->presentDistrict?$user_info->presentDistrict->district_name:'';
            $present_address['thana_name']=$user_info->presentThana?$user_info->presentThana->thana_name:'';
            $present_address['address_name']=$user_info?$user_info->address:'';
           
            $permanent_address=[];
            $permanent_address['country_name']=$user_info->permanentCountry?$user_info->permanentCountry->country_name:'';
            $permanent_address['division_name']=$user_info->permanentDivision?$user_info->permanentDivision->division_name:'';
            $permanent_address['district_name']=$user_info->permanentDistrict?$user_info->permanentDistrict->district_name:'';
            $permanent_address['thana_name']=$user_info->permanentThana?$user_info->permanentThana->thana_name:'';
            $permanent_address['address_name']=$user_info?$user_info->address:'';

            $address=[];
            $address['present_address']=$present_address;
            $address['permanent_address']=$permanent_address;

            $profile=[];
            $profile['id']=$auth->id;
            $profile['username']=$auth->username;
            $profile['first_name']=$auth->first_name;
            $profile['photo']=$user_info->latestPhoto?$user_info->latestPhoto->path:'/uploads/image-not.png';
            $profile['last_name']=$auth->last_name;
            $profile['father_name']=$auth->father_name;
            $profile['mother_name']=$auth->mother_name;
            $profile['blade_group']=$user_info->bloodGroup?$user_info->bloodGroup->blood_group_name:'';
          //  $profile['academic_info']=$academic_info;
            $profile['address']=$address;
            $profile['contact_number']=$user_info?$user_info->contact_number:'';

            $data=[
                'student_profile'=>$profile,
                'mode'=>'success',
                'status'=>'200',
            ];
            
            return response()->json($data, 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }

 

    public function getPeriodTypeForApi()
    {
        try{
        $auth= Auth::user();
        $site_id=$auth->site_id;

        $the_site_info = SiteInfo::findOrFail($site_id);
        $academic_period_type_ids = explode(',', $the_site_info->academic_period_type_ids ?? null);
        $academicPeriodTypeList = AcademicPeriodType::whereIn('id', $academic_period_type_ids)
            ->select('id','type_name')
            ->get();

      //  return response()->json($academicPeriodTypeList, 200);
        $data=[
            'academic_period_type_list'=>$academicPeriodTypeList,
            'mode'=>'success',
            'status'=>'200',
        ];
        
        return response()->json($data, 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }

    public function getAcademicVersionYearShiftList(Request $request)
    {
        try {

            $this->siteInfoSessionPut($request);

            $auth= Auth::user();
            $site_id=$auth->site_id;
         //   $site_id = Session::get('SITE_ID');

            $the_site_info_setting = SiteInfoSetting::first();
            $the_site_info = SiteInfo::findOrFail($site_id);

            if (!$the_site_info_setting) {
                return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
            }

            $academicShift = explode(',', $the_site_info_setting->shift_ids ?? null);
            $academicShiftList = AcademicShift::whereIn('id', $academicShift)
                ->get();

            $academicYear = explode(',', $the_site_info_setting->academic_year_ids ?? null);
            $academicYearList = AcademicYear::whereIn('id', $academicYear)
            ->select('id','start_date','end_date','year_name')
            ->orderBy('serial_no', 'desc')
            ->get();

         //   dd($academicYearList);

            $academicStudentCategory = explode(',', $the_site_info_setting->academic_student_category_ids ?? null);
            $academicStudentCategoryList = AcademicStudentCategory::whereIn('id', $academicStudentCategory)->get();


            $admissionlist = explode(',', $the_site_info_setting->academic_admission_type_ids ?? null);
            $admissionlistdata = AcademicAdmissionType::whereIn('id', $admissionlist)->get();


//            $academicDepartmentList = [];
//            $academicClassList = [];
//
//            if ($the_site_info_setting->academic_department_ids ?? null) {
//                $academicDepartment = explode(',', $the_site_info_setting->academic_department_ids ?? null) ?? null;
//                $academicDepartmentList = AcademicDepartment::select('id', 'name as department_name')
//                    ->whereIn('id', $academicDepartment)->get();
//            } else {
//                $academicClass = SiteShiftClassGroupSectionSetting::groupBy('academic_class_id')->pluck('academic_class_id')->toArray();//explode(',', $SiteInfoTableData->academic_class_ids) ?? [];
//                $academicClassList = AcademicClass::whereIn('id', $academicClass)
//                    ->orderBy('serial_no', 'ASC')
//                    ->get();
//            }
//
//            $academic_session_type_ids = explode(',', $the_site_info_setting->academic_session_type_ids ?? null);
//            $academicSessionTypeList = AcademicSessionType::whereIn('id', $academic_session_type_ids)
//                ->get();
//
//
//            $academic_period_type_ids = explode(',', $the_site_info->academic_period_type_ids ?? null);
//            $academicPeriodTypeList = AcademicPeriodType::whereIn('id', $academic_period_type_ids)
//                ->get();

            $academicVersionIDs = explode(',', $the_site_info_setting->academic_version_ids);
            $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();

            $academicStudentTypeIDs = explode(',', $the_site_info_setting->academic_student_type_ids);
            $academicStudentTypeList = AcademicStudentType::whereIn('id', $academicStudentTypeIDs)->get();
            $Sessionlistsplite = explode(',', $the_site_info_setting->academic_session_ids);
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            $relationList = Relation::all();

//         return $academicVersionList;

            $data=[
                'academic_versionlist'=>$academicVersionList,
                'academic_year_list'=>$academicYearList,
                'academic_shift_list'=>$academicShiftList,
                'admission_list_data'=>$admissionlistdata,
                'academic_student_category_list'=>$academicStudentCategoryList,
                'mode'=>'success',
                'status'=>'200',
            ];

            return response()->json($data, 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }

    public function getYearVersionAndShiftBasedDepartmentClass(Request $request)
        {//for employee

        try{
            $this->validate($request, [
                'academic_version_id' => 'required',
                'academic_year_id' => 'required',
                'academic_shift_id' => 'required',
            ]);

            $version_id=$request->academic_version_id;
            $year_id=$request->academic_year_id;
            $shift_id=$request->academic_shift_id;
      

        $this->siteInfoSessionPut($request);


        $academic_class_list = [];
        $academic_department_list = [];

        $academicDepartment = SiteShiftClassGroupSectionSetting::where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)
            ->whereNotNull('academic_department_id')
            ->groupBy('academic_class_id')
            ->pluck('academic_department_id')
            ->toArray();


        //dd($academicDepartment);

        if (count($academicDepartment) > 0) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academicDepartment)
                ->where('status',true)
                ->select('id','name')
                ->get();
        } else {
            $emp_class_ids = SiteEmployeeDepartmentClassSubject::groupBy('academic_class_id')
                ->pluck('academic_class_id')->toArray();

            $academic_class_list = AcademicClass::whereIn('id', $emp_class_ids)
                ->where('status',true)
                ->select('id','class_name','academic_group_present','minimum_birth_date')
                ->orderBy('serial_no', 'ASC')
                ->get();

            //     dd($emp_class_ids);

            if (count($academic_class_list) == 0) {
                return Response::json(['message' => 'You Have No Class Assigned For The Year! Go: <a href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);
            }
        }
        $data=[
            'academic_class_list'=>$academic_class_list,
            'academic_department_list'=>$academic_department_list,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data, 200);
        
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }

    
    public function getVersionYearShiftBasedSectionsOrClassGroupsAndSessionByClass(Request $request)
    {//this function returns class groups by version,year, and shift if groups not present then sections
        try{

        $this->validate($request, [
            'academic_version_id' => 'required',
            'academic_year_id' => 'required',
            'academic_shift_id' => 'required',
            'academic_class_id' => 'required',
        ]);

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id;
        $data['academic_class_id'] = $request->academic_class_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;



        $this->siteInfoSessionPut($request);

        $SiteInfoTableData = SiteInfoSetting::select('id', 'batch_present_status')->first();


        if ($SiteInfoTableData->batch_present_status) {
            $batch_list = BatchDetail::where('academic_version_id', $data['academic_version_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->select('id', 'batch_name', 'batch_code')
                ->get();

            //   dd($class_id,$version_id,$shift_id,$year_id);


        } else {
            $batch_list = [];
        }


        $group_list = [];
        $section_list = [];

        $group_present = SiteShiftClassGroupSectionSetting::where('academic_version_id', $data['academic_version_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->whereNotNull('academic_class_group_id')
            ->get();
//        return $group_present;



        if (count($group_present) > 0) {
            $group_ids = $group_present->pluck('academic_class_group_id')->toArray();
            $group_list = AcademicClassGroup::whereIn('id', $group_ids)->select('id','group_name')->get();


        } else {

            $section_present = SiteShiftClassGroupSectionSetting::where('academic_version_id', $data['academic_version_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->first();
                
            $exploded_section_ids = explode(',', $section_present->academic_section_ids ?? null);

            $section_list = AcademicSection::select('id', 'section_name')
                ->whereIn('id', $exploded_section_ids)
                ->get();
              
        }


        $session_exist = SiteClassSessionSerialSetting::where('academic_class_id', $data['academic_class_id'])
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_department_id', $data['academic_department_id'])
            ->first();

//check session existed
        if ($session_exist && $session_exist->session_present) {
            $exploded_session_list = explode(',', $session_exist->session_ids);
            $session_list = AcademicSession::whereIn('id', $exploded_session_list)->select('id','session_name')->get();
        } else {
            $session_list = [];
        }

        $data=[
            'academic_group_list'=>$group_list,
            'academic_section_list'=>$section_list,
            'academic_session_list'=>$session_list,
            'academic_batch_list'=>$batch_list,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data, 200);

        return [$group_list, $section_list, $session_list, $batch_list];

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }


    
    public function getSiteClassBaseSection(Request $request)
    {
        try{

        $this->validate($request, [
            'academic_version_id' => 'required',
            'academic_year_id' => 'required',
            'academic_shift_id' => 'required',
            'academic_class_id' => 'required',
        ]);

        $class_id=$request->academic_class_id;
        $shift_id=$request->academic_shift_id;
        $class_group_id=$request->academic_class_group_id;
        $year_id=$request->academic_year_id;
        $version_id=$request->academic_version_id;


        $this->siteInfoSessionPut($request);

        $groupPresentCount = SiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
//            ->get()
            ->count();

          
        $sessionPresentCheck = SiteClassSessionSerialSetting::where('academic_class_id', $class_id)
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)
            ->first();

         //   dd($sessionPresentCheck);
     
        
        if ($sessionPresentCheck) {
            if ($sessionPresentCheck->session_present) {
              //  $SiteInfoTableData = SiteInfoSetting::first();
                $Sessionlistsplite = explode(',', $sessionPresentCheck->session_ids);
                $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)
                    ->select('id','session_name')
                    ->get();
            } else {
                $Sessionlist = [];
            }
        } else {
            $Sessionlist = [];
        }

        if (!$groupPresentCount) {
          
            $SiteClassBaseSectionCount = SiteShiftClassGroupSectionSetting::select('academic_shift_id')
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_class_id', $class_id)
//                ->get()
                ->count();
              

            if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                return 4001;
            } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->first();
              

            } else if ($shift_id && $class_id) {
              
                $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->first();

            }
        } else {
            if (!$shift_id && !$class_group_id) {
                return 4001;
            } else if ($shift_id && !$class_group_id) {
                $SiteGroup = SiteShiftClassGroupSectionSetting::select('academic_class_group_id')
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_shift_id', $shift_id)
                    ->get();

                  
                $sectionDataList = AcademicClassGroup::select('id', 'group_name')
                    ->whereIn('id', $SiteGroup)
                    ->get();

                    $data=[
                        'academic_group_list'=>$sectionDataList,
                        'academic_session_list'=>$Sessionlist,
                        'mode'=>'success',
                        'status'=>'200',
                    ];
            
                    return response()->json($data, 200);

            } else {
                $SiteClassBaseSectionCount = SiteShiftClassGroupSectionSetting::select('academic_shift_id')
                    ->where('academic_version_id', $version_id)
                    ->where('academic_year_id', $year_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_class_group_id', $class_group_id)
                    ->get()
                    ->count();
                

                if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                    return 4001;
                } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                    $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('academic_version_id', $version_id)
                        ->where('academic_year_id', $year_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->first();
                } else if ($shift_id && $class_id) {

                    
                    $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('academic_version_id', $version_id)
                        ->where('academic_year_id', $year_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->first();
                }
            }
        }

      

        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);
       
        $SectionDataList = AcademicSection::select('id', 'section_name')
            ->whereIn('id', $SectionData)
            ->get();

            $data=[
                'academic_section_list'=>$SectionDataList,
                'academic_session_list'=>$Sessionlist,
                'mode'=>'success',
                'status'=>'200',
            ];
    
            return response()->json($data, 200);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }


}
