<?php

namespace App\Http\Controllers\Api\EmployeePanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicShift;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskMenu;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSetting;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSettingDetail;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteAnswerPaperDistributionDetail;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteInfo;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Session;
use Response;
use PDF;


class EmployeeExamMarkEntryApiController extends ApiProjectController
{
    public function __construct()
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');
        $this->middleware('employee.check');
    }

    
    public function getSiteEmployeeBaseStudentMarksEntryList(Request $request){

        try{
         //   dd($request->all());
         $this->validate($request, [
            'answer_paper_distribution_detail_id' => 'required',
            'site_subject_group_condition_setting_id' => 'required',
        ]);
        
        $this->siteInfoSessionPut($request);
        $auth=Auth::user();
        $user_id=$auth->id;
      
       
        $getList=SiteAnswerPaperDistributionDetail::where('id', $request->answer_paper_distribution_detail_id)->first();

        $t1 = Carbon::parse($getList->marks_update_at);
        $t2 = Carbon::parse(Carbon::now());
        $timeDuration = $t2->diffInHours($t1);
        if($timeDuration>48){
         //   $time_range=false;
            $time_range=true;
        }else{
            $time_range=true;
        }

        $studentIds=StudentHistory::where('academic_version_id', $getList->academic_version_id)
            ->where('academic_year_id', $getList->academic_year_id)
            ->where('academic_shift_id', $getList->academic_shift_id)
            ->where('academic_class_id', $getList->academic_class_id)

            ->when(!empty($getList['academic_department_id']), function ($query) use ($getList) {
                return $query->where('academic_department_id', $getList['academic_department_id']);
            })
            ->when(!empty($getList['academic_class_group_id']), function ($query) use ($getList) {
                return $query->where('academic_class_group_id', $getList['academic_class_group_id']);
            })
            ->when(!empty($getList['academic_section_id']), function ($query) use ($getList) {
                return $query->where('academic_section_id', $getList['academic_section_id']);
            })
            ->when(!empty($getList['academic_session_id']), function ($query) use ($getList) {
                return $query->where('academic_session_id', $getList['academic_session_id']);
            })
            ->where('student_roll_number', '>=', $getList->roll_from)
            ->where('student_roll_number', '<=', $getList->roll_to)
            ->orderBy('student_roll_number', 'asc')
            ->pluck('id');


        $declaredStudentList=SiteExamDeclareStudent::with(['siteExamDeclareStudentSubject'=>function($query) use ($getList){
            $query->where('site_subject_group_condition_setting_id', $getList->site_subject_group_condition_setting_id);
            $query->where('academic_exam_type_id', $getList->academic_exam_type_id);
            $query->with(['academicExamType']);
          //  $query->select('id','countable_obtaine_marks','obtaine_marks','marks_input_by','created_at');
        },
            'studentHistory'=>function($querys) use ($getList){

                $querys->with(['classGroup', 'session', 'section']);
                $querys->select('id', 'user_id', 'student_roll_number', 'academic_class_group_id', 'academic_section_id', 'academic_session_id');
                $querys->when(!empty($getList['academic_class_group_id']), function ($q) use ($getList) {
                    return $q->where('academic_class_group_id', $getList['academic_class_group_id']);
                });
            }])
            ->where('site_exam_declare_id', $getList->site_exam_declare_id)
            ->whereIn('student_history_id', $studentIds)
            ->select('id','site_exam_declare_id','student_history_id')
            ->get();

//return $declaredStudentList;

        $student_list=[];
        $class_group_present=[];
        $section_present=[];
        $session_present=[];
        foreach ($declaredStudentList as $key => $value) {

            if(count($value->siteExamDeclareStudentSubject)>0){
                $student_list[]=$value;
            }

            if($value->studentHistory->academic_class_group_id){
                $class_group_present[]=$value->studentHistory->academic_class_group_id;
            }
            if($value->studentHistory->academic_section_id){
                $section_present[]=$value->studentHistory->academic_section_id;
            }
            if($value->studentHistory->academic_session_id){
                $session_present[]=$value->studentHistory->academic_session_id;
            }

        }

        //Class Group Present
        if(count($class_group_present)>0){
            $academic_class_group_present_status=true;
        }else{
            $academic_class_group_present_status=false;
        }

        //Class Group Present
        if(count($section_present)>0){
            $academic_section_present_status=true;
        }else{
            $academic_section_present_status=false;
        }

        //Class Group Present
        if(count($session_present)>0){
            $academic_session_present_status=true;
        }else{
            $academic_session_present_status=false;
        }

        $student_asc_list=array_values(array_sort(collect($student_list), function ($value) {
            return $value['student_roll_number'];
        }));

        $getExamType=SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->where('site_exam_declare_id',  $getList->site_exam_declare_id)
            ->whereIn('student_history_id', $studentIds)
            ->where('academic_exam_type_id', $getList->academic_exam_type_id)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->distinct('academic_exam_type_id')
            ->select('academic_exam_type_id')
            ->get();

        // return compact('student_asc_list', 'getExamType', 'academic_class_group_present_status',
        //     'academic_section_present_status', 'academic_session_present_status', 'time_range');
        $data=[
            'StudentListForMarksEntry'=>$student_asc_list,
            'getExamType'=>$getExamType,
            'academic_class_group_present_status'=>$academic_class_group_present_status,
            'academic_section_present_status'=>$academic_section_present_status,
            'academic_session_present_status'=>$academic_session_present_status,
            'time_range'=>$time_range,
            'mode'=>'success',
            'status'=>'200',
        ];

            return response()->json($data,200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }


    public function siteStudentMarksEntrySubmitByEmployee(Request $request){

        try{

            $data=$request->all();

            $this->validate($request, [
                'answer_paper_distribution_detail_id' => 'required',
                'site_subject_group_condition_setting_id' => 'required',
            ]);

        $this->siteInfoSessionPut($request);
        

        $examination=Examination::where('id',$request->examination_id)->first();

        $checkPermission=$this->checkExamMarkEntryPermission($data,$examination);

        if($checkPermission['status']!='200'){
            return Response::json(['message' => $checkPermission['message'], 'status' => $checkPermission['status']], $checkPermission['status']);
        }
         
      

        foreach ($request->StudentListForMarksEntry as $key => $value) {
        //    dd($value);
            $count=0;
            foreach ($value['site_exam_declare_student_subject'] as $keys => $values) {

                if($values['obtaine_marks']>$values['subject_exam_type_mark'] || $values['obtaine_marks']<0){
                    $count++;
                }else{
                    $checkDistribution=SiteAnswerPaperDistributionDetail::where('id', $request->answer_paper_distribution_detail_id)
                    ->where('user_id', Auth::id())
                    ->where('site_exam_declare_id', $values['site_exam_declare_id'])
                    ->first();

                    if ($checkDistribution) {
                        $checkStudent=StudentHistory::where('id', $values['student_history_id'])
                            ->where('student_roll_number', '>=', $checkDistribution->roll_from)
                            ->where('student_roll_number', '<=', $checkDistribution->roll_to)
                            ->first();
                    if($checkStudent){

                    $checkCreated=SiteExamDeclareStudentSubject::where('id', $values['id'])->first();

                    //==== this condition add for exam type countable mark      
                    if($values['exam_type_countable_marks_status']){
                        $countable_obtaine_marks = ($values['exam_type_countable_persent_of_obtain_marks'] * $values['obtaine_marks'])/100;
                    }else{
                        $countable_obtaine_marks = $values['obtaine_marks'];
                    }
                    //===
                //    dd('sf');

                    $t1 = Carbon::parse($checkCreated->created_at);
                    $t2 = Carbon::parse(Carbon::now());
                    $duration = $t2->diffInHours($t1);
                    //&& $duration<=48
                    if($checkCreated->obtaine_marks!=$values['obtaine_marks']){
                     //   dd('dfsf');
                        SiteExamDeclareStudentSubject::where('id', $values['id'])
                            ->where('student_history_id', $checkStudent->id)
                            ->update([
                                'countable_obtaine_marks'=>ceil($countable_obtaine_marks),
                                'obtaine_marks'=>$values['obtaine_marks'],
                                'marks_input_by'=>Auth::id(),
                                'created_at'=>Carbon::now(),
                            ]);
                    }

                }
                }
            }
            }
        }

          SiteAnswerPaperDistributionDetail::where('id', $request->answer_paper_distribution_detail_id)
            ->update([
                'marks_update_at'=>Carbon::now(),
            ]);


        return Response::json(['message' => 'Number Entry Successfully!',  'mode'=>'success', 'status'=>'200'], 200);
     
        } catch (ValidationException $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }

    public function studetnsSubjectMarkList($request){

        $this->validate($request, [
            "examination_id" => "required",
            "answer_paper_distribution_detail_id" => "required",
        ]);

        $examination=Examination::where('id',$request->examination_id)->where('use_key','site')->first();
        if(!$examination){
           return Response::json(['message'=>'You have no permission'],401); 
        }

        $data = $request->all();
        $checkDistribution=SiteAnswerPaperDistributionDetail::where('id', $request->answer_paper_distribution_detail_id)
           // ->where('site_subject_group_condition_setting_id',$request->site_subject_group_condition_setting_id)
           ->where('user_id', Auth::id()) 
           ->first();


           if(!$checkDistribution){
            return Response::json(['message' => 'Pdf Not Found',  'mode'=>'errors', 'status'=>'404'], 404);
           }
    
        $examDeclare = SiteExamDeclares::with('year','shift','department','stClass')->where('id',$checkDistribution->site_exam_declare_id)->first();
         //  dd($examDeclare);
            
        $site_info = SiteInfo::find(Session::get('SITE_ID'));
        $academic_class_group = AcademicClassGroup::find($checkDistribution->academic_class_group_id);

        $section=AcademicSection::find($checkDistribution->academic_section_id);
        $shift=AcademicShift::find($checkDistribution->academic_shift_id);
       
        $header_data=[
            'examination_name'=>$examDeclare->examination?$examDeclare->examination->examination_name:'',
            'year_name'=>$examDeclare->year?$examDeclare->year->year_name:'',
            'shift_name'=>$shift?$shift->shift_name:'',
            'class_name'=>$examDeclare->stClass?$examDeclare->stClass->class_name:'',
            'department_name'=>$examDeclare->department?$examDeclare->department->name:'',
            'group_name'=>$academic_class_group?$academic_class_group->group_name:'',
            'section_name'=>$section?$section->section_name:'',
            'site_name'=>$site_info->site_name,
            'site_address'=>$site_info->address,
        ];

        
      //  dd($header_data);

        //======

        $examination_id=$examDeclare->examination_id??'';
    //    $examDeclaredIds=$examDeclare->pluck('id');
        $examDeclaredId=$examDeclare->id;
      //  dd($examDeclare->pluck('id'));
           
        $students_history_ids=StudentHistory::where('academic_version_id', $checkDistribution->academic_version_id)
            ->where('academic_year_id', $checkDistribution->academic_year_id)
            ->where('academic_shift_id', $checkDistribution->academic_shift_id)
            ->where('academic_class_id', $checkDistribution->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
          //  ->where('status', true)
            ->where('student_roll_number', '>=', $checkDistribution->roll_from)
            ->where('student_roll_number', '<=', $checkDistribution->roll_to)
            ->with('student')
            ->orderBy('student_roll_number')
            ->pluck('id');
          
         
           $all_exam_type_ids = SiteExamDeclareStudentSubject::whereIn('student_history_id',$students_history_ids)
                ->where('site_exam_declare_id',$examDeclaredId)
                ->where('academic_exam_type_id',$checkDistribution->academic_exam_type_id)
                ->pluck('academic_exam_type_id')
                ->unique();

          $examTypeList= AcademicExamType::whereIn('id',$all_exam_type_ids)->select('id','marks_type')->get();
        
          $subjectList=SiteExamDeclareStudentSubject::with(['academicExamType'])
                ->where('site_exam_declare_id', $examDeclaredId)
                ->where('site_subject_group_condition_setting_id', $checkDistribution->site_subject_group_condition_setting_id)
                ->whereIn('student_history_id', $students_history_ids)
                ->groupBy('site_subject_group_condition_setting_id')
                ->with(['subjectGroupConditionSetting'=>function($query){
                //   $query->select('academic_subject_id');
                    $query->with('academicSubject');
                }])
                ->select('academic_exam_type_id','site_subject_group_condition_setting_id')
                ->get();

    //   return $subjectList;

          $subject_list=[];

          foreach($subjectList as $key=>$subject){
              $subject_list[$key]['subject_name']=$subject->subjectGroupConditionSetting->academicSubject->subject_name;
              $subject_list[$key]['site_subject_group_condition_setting_id']=$subject->site_subject_group_condition_setting_id;
          }


           $student_list=StudentHistory::with(['siteExamDeclareStudentSubject'=>function($query) use ($checkDistribution, $examDeclaredId, $examination_id){
                $query->where('examination_id', $examination_id)
                ->with(['subjectGroupConditionSetting'=>function($q) use ($checkDistribution){
                    $q->where('id', $checkDistribution->site_subject_group_condition_setting_id);
                    $q->select('id', 'academic_subject_id','subject_code');
                    $q->orderBy('subject_position');
                    }]);
                    $query->with('academicExamType');

                $query->where('site_exam_declare_id', $examDeclaredId);
              //  $query->with('sameSubject');
                $query->distinct('student_history_id', 'site_subject_group_condition_setting_id');
                $query->groupBy('site_subject_group_condition_setting_id');
              //  $query->select('id','obtaine_marks','site_exam_declare_id','academic_exam_type_id','student_history_id', 'site_subject_group_condition_setting_id');
            }])
            ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session', 'year', 'academicStudentCategory',
                'student'=>function($query){
                    $query->with(['gender', 'religion', 'latestPhoto'=>function($query){
                        $query->select('name','path','imageable_id');
                    }]);
                    $query->select('id', 'gender_id', 'religion_id');

                }])
            ->whereIn('id', $students_history_ids)
            ->select('id', 'user_id', 'student_roll_number', 'academic_year_id',
                'academic_department_id', 'academic_class_id', 'academic_shift_id', 'optional_subject_ids',
                'academic_student_category_id',
                'academic_class_group_id', 'academic_section_id', 'academic_session_id', 'student_roll_number_prefix')
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_department_id')
            ->orderBy('academic_session_id')
            ->get();
            
            $student_array=[];
            $key=0;
                foreach($student_list as $history){
                    
                   $declare_subjectss=[];
                  
                //   return $subject_list;
                    foreach($subject_list as $keysy=>$subject){
                       $StudentSubjects= $history->siteExamDeclareStudentSubject
                        ->where('site_subject_group_condition_setting_id', $subject['site_subject_group_condition_setting_id']);

                //         $StudentSubjects22= $history->siteExamDeclareStudentSubject
                //         ->where('site_subject_group_condition_setting_id', 10425);
                //       //  ->where('examination_id',$examDeclare->examination_id);
                //    //    return $StudentSubjects22;


                    $exam_type=[];
                    foreach($examTypeList as $keys=>$examType){
                      
                        $st_exam_type=$StudentSubjects->where('academic_exam_type_id', $examType->id)
                        ->first();
                       
                        if($st_exam_type){
                            $exam_type[$keys]['obtaine_marks']=$st_exam_type->obtaine_marks;
                            $exam_type[$keys]['academic_exam_type_id']=$st_exam_type->academic_exam_type_id;
                            $exam_type[$keys]['exam_type']=$examType->marks_type;
                        }else{
                            $exam_type[$keys]['obtaine_marks']="";
                            $exam_type[$keys]['academic_exam_type_id']=$examType->id;
                            $exam_type[$keys]['exam_type']=$examType->marks_type;
                        }
             
                    }
                 
                    $declare_subjectss[$keysy]['exam_types']=$exam_type;
                    $declare_subjectss[$keysy]['site_subject_group_condition_setting_id']=$subject['site_subject_group_condition_setting_id'];
                 
                  }
                
                    $student_array[$key]['full_name']=$history->full_name;
                    $student_array[$key]['student_full_roll_number']=$history->student_full_roll_number;
                    $student_array[$key]['shift']=$history->shift?$history->shift->shift_name:'';
                    $student_array[$key]['section']=$history->section?$history->section->section_name:'';
                    $student_array[$key]['year']=$history->year?$history->year->year_name:'';
                    $student_array[$key]['subject_list']=$declare_subjectss;
                    $key++;
                }

        return [$student_array, $examTypeList, $header_data, $subject_list];
    }


    public function studetnsSubjectMarkListPdf(Request $requests){
    //  dd('sf');
        $this->siteInfoSessionPut($requests);

       $studetnData= $this->studetnsSubjectMarkList($requests);
       $students_mark_list=$studetnData[0];
       $exam_type_list=$studetnData[1];
       $header_data=$studetnData[2];
       $subject_list=$studetnData[3];
      
       $report_tittle="";
       $report_tittle2="";
       $report_tittle .= "<b>Year:</b>" .$header_data['year_name'];
       $report_tittle .= "<b>, Shift:</b>" .$header_data['shift_name'];

      //  dd($students_mark_list);
       $pdf = PDF::loadView('default.admin.site.exam.report.site-base-student-exam-entry-mark-report-pdf-for-employee',
       compact('report_tittle','report_tittle2','students_mark_list', 'exam_type_list', 'subject_list'))
       ->setPaper('a4')->setWarnings(false);

       $time = Auth::user()->id . '-' . Carbon::now()->unix();
       $name = $time . '.pdf';

       return $pdf->stream($name);

      

    // $path = storage_path() . '/pdf';
    // $time = Auth::user()->id . '-' . Carbon::now()->unix();
    // $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
    // $name = $time . '.pdf';


    // return Response::json(['link' => route('open-pdf-file-storage', [$name]),
    //     'message' => 'Successfully Created Card Report'], 200);

    }

    
      public function checkExamMarkEntryPermission($data, $examination){

            if($examination->use_key=='site_group'){ // only group exam

            $checkSetting = SiteExaminationExamTypeSetting::with(['academicExamType'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('examination_id', $data['examination_id'])
                ->orderBy('position_show')
                ->first();


                if($checkSetting){
                    if($checkSetting->examiner_exam_mark_entry_permission==false){
                        return ['status'=>'403','message' => 'You have no permission!'];
                    }
                    $deadlineInput = $checkSetting->exam_mark_entry_deadline ?? null;

                    $now = Carbon::now('Asia/Dhaka');
                    $deadline = Carbon::parse($deadlineInput, 'Asia/Dhaka');

                    if ($now->greaterThanOrEqualTo($deadline)) {
                        return ['status'=>'403','message' => 'Time is over!'];
                    }
                }

            }

            return ['status'=>'200','message' => 'pass successfully!'];

        }




   
}
