<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Edu\NewSite\Application;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use Auth;
use Illuminate\Validation\ValidationException;
use Exception;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Auth as FacadesAuth;
use Laravel\Passport\HasApiTokens;
use Session;

class LoginController extends Controller
{

    use HasApiTokens, Notifiable;

    private $user;
    private $request;
    private $auth;
    private $app;
    private $localeCode;

    /**
     * LoginController constructor.
     * @param User $user
     * @param Request $request
     * @param Guard $auth
     */
    public function __construct(User $user, Request $request, Guard $auth, Application $app)
    {
        $this->middleware('api.app.access');
        $this->user = $user;
        $this->request = $request;
        $this->auth = $auth;
        $this->app = $app;

        $this->middleware(function ($request, $next) {
            if($this->getLocalize($request)){
                return $next($request);
            }else{
                return response()->json(['message' => 'You have no permission','status'=>'403', 'mode'=>'errors'], 403);
            }
           
        });

    }

    private function getLocalize($request)
    {

        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {

            $getHost = explode(".", $_SERVER['HTTP_HOST']);
            $domain = array_shift($getHost);
        }

        $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
        $user = GlobalUser::where('username',$request->username)->where('status',true)->first('site_id');

       return $user->site_id==$site_info->id?true:false;

    }

    public function apiLogin(Request $request)
    {
       try{

        $this->validate($request, [
            'username' => 'required',
            'password' => 'required',
        ]);

            $credentials = [
                'username' => $request->username,
                'password' => $request->password
            ];

            if (Auth::attempt($credentials)) {
                $user = Auth::user();
               
                $success['user'] = $user; 
                $success['token'] = $user->createToken('EduWorld')->accessToken;
            
                return response()->json($success, 200);
            } 
            else {
                return response()->json(['message' => 'UnAuthorised','status'=>'401', 'mode'=>'errors'], 401);
            }

        }catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors'], 420);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);

        }

    }


  

}
