<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Edu\NewSite\Application;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\User;
use Auth;
use Illuminate\Validation\ValidationException;
use Exception;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Auth as FacadesAuth;
use Laravel\Passport\HasApiTokens;
use Session;

class LogoutController extends Controller
{

    use HasApiTokens, Notifiable;

    private $user;
    private $request;
    private $auth;
    private $app;


    /**
     * LoginController constructor.
     * @param User $user
     * @param Request $request
     * @param Guard $auth
     */
    public function __construct()
    {
        $this->middleware('auth:api');
        $this->middleware('api.app.access');

    }

  

    public function apiLogout(Request $request)
    {
       
        $user = $request->user();
        $user->tokens()->delete();
        return response()->json(['message' => 'Successfully logged out','status'=>'200', 'mode'=>'success'], 401);

    }



}
