<?php

namespace App\Http\Controllers\Api\Payment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Traits\Site\Payment\StudentIbblTransactionTrait;


use App\Jobs\Site\PaymentHistoryJob;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Site\Accounts\Accounts;
use App\Models\Site\Accounts\AccountsVoucherDetails;
use App\Models\Site\Accounts\SiteAccountsVoucherDetailsStudentPaymentHistoryRecord;
use App\Models\Site\Employee\StudentAssignToTeacher;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeFineAllocation;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Role\SiteRole;
use App\Models\Student\PublicStudentHistory;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use App\Models\Site\GlobalSiteInfo;
use Carbon\CarbonPeriod;
use App\Http\Middleware\EncryptCookies;
use Carbon\Carbon;
use phpseclib\Crypt\RSA;
use Response;
use Auth;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use JsonSchema\Exception\ValidationException;
use PDF;
use Session;
use Error;


class IbblPaymentApiController extends Controller
{

    use StudentIbblTransactionTrait;

    public function acceptPaymentInfoInIbbl(Request $request){


      //  $userId = $request->header('userId');

        $userId     =   $request->userId;
        $password   =   $request->password;
        $iid        =   $request->iid;
        $invoiceNo  =   $request->invoiceNo;
        $trId       =   $request->trId;
        $status     =   $request->status;
        $date_time  =   $request->date_time;
        $tr_amount  =   $request->tr_amount;
        $cr_amount  =   $request->cr_amount;
        $source_of_fund = $request->source_of_fund;
   
       $ibblRequest=[
         'userId'=>$userId,
         'password'=>$password,
         'iid'=>$iid,
         'invoiceNo'=>$invoiceNo,
         'trId'=>$trId,
         'status'=>$status,
         'date_time'=>$date_time,
         'tr_amount'=>$tr_amount,
         'cr_amount'=>$cr_amount,
         'source_of_fund'=>$source_of_fund,
       ];


        DB::beginTransaction();
     try {
            if($userId && $password && $iid && $invoiceNo && $trId && $status && $date_time && $tr_amount
            && $cr_amount && $source_of_fund){

              // if($iid=='admission'){
              //   $response_message= $this->postingPaymentInfoForNewAdmission($ibblRequest);
              // }else{
                $response_message= $this->postingPaymentInfoForStudent($ibblRequest);
            //  }
              
              return $response_message;

            }else{
              return Response::json(['message'=>'Field Missing'], 410);
            }

         } catch (Exception $exception) {
               DB::rollBack();
               return Response::json(['message' => $exception->getMessage()], 410);
         }
      }
    
    
    public function getFeeInfoForIbbl(Request $request){
         try {

            // $userId = $request->header('userId');

             $userId = $request->userId;
             $password = $request->password;
             $iid = $request->iid;
             $operation = $request->operation;
             $referenceId = $request->referenceId;
             $random = $request->random;

            $ibblRequest=[
               'userId'=>$userId,
               'password'=>$password,
               'iid'=>$iid,
               'operation'=>$operation,
               'referenceId'=>$referenceId,
               'random'=>$random,
            ];

              if($userId && $password && $operation && $referenceId && $random && $iid){

                // if($iid=='admission'){
                //   $response_message= $this->getApplicantAdmissionInfo($ibblRequest);
                // }else{
                  $response_message= $this->getStudentFeeInfo($ibblRequest);
               // }
                return $response_message;

              }else{
                  return Response::json(['message'=>'Field Missing'], 410);
              }
            
            }catch (Exception $exception) {
               DB::rollBack();
               return Response::json(['message' => $exception->getMessage()], 410);
            }    
               
      }



        
    }

