<?php

namespace App\Http\Controllers\Api\Payment;

use App\Traits\TransactionCheckApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PaymentApiController extends Controller
{

    use TransactionCheckApiTrait;

    public function __construct()
    {
        $this->middleware('auth:api');
        $this->middleware('api.access');
    }

    public function checkTransactionId(Request $request)
    {
        $this->validate($request,
            [
                'transaction_id' => 'required'
            ]);


        $responses = $this->verifyTransId($request->transaction_id);

        return $responses;
    }
}
