<?php

namespace App\Http\Controllers\API\Site;

use App\Models\Modules\Module;
use App\Models\Modules\SubModule;
use App\Models\Permission\GlobalGroupAccess;
use App\Models\Permission\GroupAccess;
use App\Models\Role\GlobalRole;
use App\Models\Site\SiteAccess;
use App\Models\Site\SiteInfo;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\User\User;
use Auth;
use Illuminate\Validation\ValidationException;

use Response;
use Session;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\JsonResponse;

class SiteController extends Controller
{

    public function __construct()
    {
        $this->middleware('api.access');
    }

    /**
     * Display a listing of the resource.
     *
     * @return Collection;
     */
    public function getSiteList(Request $request)
    {
        try{
            $site_list=SiteInfo::where('status',1)
                ->whereHas('siteInfoSettings', function($q){
                    return $q->where('status',1);
                })
                ->select('id','site_name_native_language','site_alias','site_logo','site_email','site_phone','eiin',
                'college_code','nu_code','google_map_address','facebook_link','twitter_link','google_link','youtube_link','domain_name')
                ->get();

                $data=[
                    'site_list'=>$site_list,
                    'mode'=>'success',
                    'status'=>'200',
                ];
                
              
                return response()->json($data,200);
                
                
         }catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);

        }
       
    }

    public function getSiteInfo(Request $request)
    {
        try{
            if(!$request->site_id){
                return response()->json(['message'=>'Site ID missing','status'=>'422'],422);
            }
            $site = SiteInfo::findOrFail($request->site_id);
            if($site){
                $site_info=[
                    'id'=>$site->id,
                    'site_alias'=>$site->site_alias,
                    'site_name'=>$site->site_name,
                    'site_name_native_language'=>$site->site_name_native_language,
                    'site_logo'=>$site->site_logo,
                    'address'=>$site->address,
                    'site_email'=>$site->site_email,
                    'site_phone'=>$site->site_phone,
                    'eiin'=>$site->eiin,
                    'college_code'=>$site->college_code,
                    'nu_code'=>$site->nu_code,
                    'google_map_address'=>$site->google_map_address,
                    'facebook_link'=>$site->facebook_link,
                    'twitter_link'=>$site->twitter_link,
                    'google_link'=>$site->google_link,
                    'youtube_link'=>$site->youtube_link,
                ];
                $data=[
                    'site_info'=>$site_info,
                    'mode'=>'success',
                    'status'=>'200',
                ];
                
            }
        
            return response()->json($data);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);

        }
       

    }


  

   



}
