<?php

namespace App\Http\Controllers\Api\Site\Web\Setting;

use App\Models\WebSite\WebsiteMenu;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Auth;
class MenuApiController extends Controller
{
    private $webMenu;

    public function __construct(WebsiteMenu $webMenu)
    {
        $this->middleware('auth:api');
        $this->middleware('api.access');
        $this->middleware('sitepagechecker2');

       //  $this->middleware('auth');
       //  $this->middleware('sitepagechecker');
        $this->webMenu = $webMenu;
    }


    public function getWebMenu($parent = 0)
    {
        try {
            $web_menu = $this->webMenu
                ->where('type', 'site')
                ->where('type_id', Auth::user()->site_id)
                ->where('parent_id', $parent)
                ->with('menu')
                ->orderBy('serial')
                ->get();

            return response()->json($web_menu, 200);

        } catch (Exception $ex) {
            return Response::json([$ex->getMessage()], 405);
        }

    }

    public function updateWebMenu(Request $request)
    {
        try {

            foreach ($request->menu as $menu) {
                // \Log::info($menu['id']);

                $web_menu = $this->webMenu->findOrFail($menu['id']);

                if (isset($this->webMenu->ownFields)) {
                    foreach ($this->webMenu->ownFields as $ownField) {
                        if ($menu[$ownField]) {
                            $web_menu->{$ownField} = $menu[$ownField];
                        }
                        $web_menu->status = $menu['status'];
                        $web_menu->show_icon = $menu['show_icon'];
                        $web_menu->save();
                    }
                }
            }
            return response()->json(['message' => 'Successfully updated!'], 200);

        } catch (Exception $ex) {
            return Response::json(['message' => $ex->getMessage()], 500);
        }

    }
}
