<?php

namespace App\Http\Controllers\Api;

use App\Forms\DataHelper;
use App\Models\Academic\AcademicBoard;
use App\Models\Division\Division;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Relation\Relation;
use App\Models\Session\PaymentSession;
use App\Models\Site\Batch\GlobalBatchDetail;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Fee\Fine\GlobalSiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentFeeWaiverOfferHistory;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Models\Site\Result\GlobalSiteResultSystemSetting;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Student\Student;
use App\Models\User\GlobalUser;
use App\Traits\Site\Fee\SonaliPayStudentFeeTrait;
use App\Traits\Site\Fee\StudentFeeTrait;
use Carbon\Carbon;
use Exception;
use Response;
use Session;
use PDF;
use Carbon\CarbonPeriod;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;

class SiteWebPaymentApiController extends ApiProjectController
{
    use SonaliPayStudentFeeTrait, StudentFeeTrait;


    public function __construct()
    {
        $this->middleware('api.access');
    }


    public function getStudentFeeInfo(Request $request){

    
        try{

            $this->validate($request, [
                'student_username' => 'required',
            ]);
          
        $site_id=$this->getSiteId($request);

     //   dd($site_id);


        $siteInfo= GlobalSiteInfo::where('id',$site_id)->first();
          
        if(!$siteInfo->web_student_fee_collection_status){
            return response()->json(['message'=>'permission denied!', 'status'=>'410'],410);
        }

        $student=Student::where('username',$request->student_username)->where('site_id',$site_id)->first();
       // dd($student);
        if(!$student){
            return response()->json(['message'=>'Student not found!', 'status'=>'410'],410);
        }

       

        $student_id = $student->id;
        $studentHistoryIDList=GlobalStudentHistory::where('user_id',$student_id)->where('site_id',$site_id)->where('status',1)->pluck('id');
        
        if(count($studentHistoryIDList)==0){
            return response()->json(['message'=>'Student not found!', 'status'=>'410'],410);
        }
       
        // $demand_slip=GlobalSiteStudentFeeDemandSlipDetails::with(['studentHistory'=>function($q){
        //     $q->with('stClass');
        //     }])
        //     ->whereIn('student_history_id', $studentHistoryIDList)
        //     ->with('siteStudentFeePaymentHistory')
        //     ->with('siteStudentFeeFine')
        //     ->where('status',1)
        //     ->where('site_id',$site_id)
        //     ->orderBy('id', 'desc')
        //     ->first();

        $demand_slip = GlobalSiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
            $query->whereIn('student_history_id', $studentHistoryIDList)
                ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
            })
            ->where('status', 1)
            ->where('site_id', $site_id)
            ->with(['studentHistory'=>function($q){
                $q->with('stClass');
                }])
            ->with('siteStudentFeePaymentHistory')
            ->with('siteStudentFeeFine')
            ->orderBy('id', 'desc')
            ->first();
          
        if(!$demand_slip){
            return response()->json(['message'=>'Payment not found!','status'=>'410'],410);
        }

        $studentSlip=$this->studentSlipDetails($demand_slip->id);

        $studentHistory=GlobalStudentHistory::where('user_id',$student_id)->where('site_id',$site_id)->where('status',1)->first();

        $student_info=[
            'name'=>$studentHistory->full_name??null,
            'username'=>$student->username,
            'contact_number'=>$student->contact_number??null,
            'student_full_roll_number'=>$studentHistory->student_full_roll_number??null,
            'father_name'=>$student->father_name,
            'mother_name'=>$student->mother_name,
            'class_name'=>$studentHistory->stClass?$studentHistory->stClass->class_name:null,
            'year_name'=>$studentHistory->year?$studentHistory->year->year_name:null,
            'shift_name'=>$studentHistory->shift?$studentHistory->shift->shift_name:null,
            'group_name'=>$studentHistory->accGroup?$studentHistory->accGroup->group_name:null,
            'section_name'=>$studentHistory->section?$studentHistory->section->section_name:null,
            'session_name'=>$studentHistory->session?$studentHistory->session->session_name:null,
        ];

 

        $data=[
            'fee_data'=>$studentSlip['fee_data'],
            'payment_method_list'=> $studentSlip['payment_method_list'],
            'student_data'=>$student_info,
          //  'student_data'=>$studentSlip['student_info'],
            'mode'=>'success',
            'status'=>'200',
        ];
        
        return response()->json($data);


    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

}


// private function getSiteId($request){
         
//     if(empty($request->site_id)){
//         $domain = "";
//         if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
//             $getHost = explode(".", $_SERVER['HTTP_HOST']);
//             $domain = array_shift($getHost);
//         }
//         $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
//         $site_id = $site_info->id;
//         Session::put('SITE_ID', $site_id);
//     }else{
//         Session::put('SITE_ID', $request->site_id);
//         $site_id = $request->site_id;
//     }
//     return $site_id;
// }


    public function getStudentBankSlipPdfForPublic(Request $request)
    {
        try{
        $this->validate($request, [
            'student_username' => 'required',
        ]);

        $site_id=$this->getSiteId($request);

        $username=$request->student_username;
        $siteInfo= GlobalSiteInfo::where('id',$site_id)->first();

        if(!$siteInfo->web_student_fee_collection_status){
            return response()->json(['message'=>'permission denied','mode'=>'error','status'=>'410'],410);
        }

        $student=Student::where('username',$username)->where('site_id',$site_id)->first();

        if(!$student){
            return response()->json(['message'=>'Data not found!','mode'=>'error','status'=>'410'],410);
        }


        $student_id = $student->id;
        $studentHistoryIDList=GlobalStudentHistory::where('user_id',$student_id)->where('site_id',$site_id)->where('status',1)->pluck('id');
        // $demand_slip=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
        //     ->where('status',1)
        //     ->where('site_id',$site_id)
        //     ->orderBy('id', 'desc')
        //     ->first();

        $demand_slip = GlobalSiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
            $query->whereIn('student_history_id', $studentHistoryIDList)
                ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
            })
            ->where('status', 1)
            ->where('site_id', $site_id)
            ->orderBy('id', 'desc')
            ->first();

        if(!$demand_slip){
            return 'Payment not found!';
        }
    

        $studentSlip=$this->studentSlipDetails($demand_slip->id);
   
        $student_info = $studentSlip['student_info'];
        $fee_data = $studentSlip['fee_data'];
        $title_view = 'Demand Slip';
        $slip_quantity = [1,2];

        $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-bank-slip-pdf',
            compact('title_view','slip_quantity','fee_data','student_info','siteInfo'));
   
        return $pdf->stream(time() . '-student-payment-bank-slip.pdf');
        

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }


    }

    public function createStudentPublicPayment(Request $request){

           
        try{

            $this->validate($request, [
                'student_username' => 'required',
                'gateway_name_key' => 'required',
                'request_amount' => 'required',
            ]);
        ///    dd('sf');


        $site_id=$this->getSiteId($request);

        $siteInfo= GlobalSiteInfo::where('id',$site_id)->first();

        if(!$siteInfo->web_student_fee_collection_status){
             return response()->json(['message'=>'permission denied','status'=>'410'],410);
        }


        $username=$request->student_username;

        $student=Student::where('username',$username)->where('site_id',$site_id)->first();

        if(!$student){
            return response()->json(['message'=>'Data not found!','status'=>'410'],410);
        }

        $user_id = $student->id;
    
        if($request->gateway_name_key == 'nagad'){
            $this->paymentTakeByNagadTransactionID($request);
        }else if($request->gateway_name_key == 'bkash'){
            return response()->json(['message'=>'Developing This System ', 'status'=>'403']); 
        }else if($request->gateway_name_key == 'surecash'){
            return response()->json(['message'=>'Developing This System ', 'status'=>'403']);    
        
        }else if($request->gateway_name_key=='sonali_pay'){

            $redirect_path="/api/web-app/verify-payment-transaction";

            $request_data=[
                'site_id'=>$site_id,
                'user_id'=>$user_id,
                'username'=>$username,
                'request_amount'=>$request->request_amount,
                'redirect_path'=>$redirect_path
            ]; 
    
            $api_response = $this->studentFeeInfoForSonaliPay($request_data);

        
            $data=[
                'gateway_link'=>isset($api_response['RedirectToGateway'])?$api_response['RedirectToGateway']:null,
                'message'=>$api_response['Message'],
                'status'=>$api_response['Status'],
                'callback_url'=>$redirect_path
             //   'time'=>isset($api_response['Time'])?$api_response['Time']:null
            ];

            return response()->json($data);
                                
            
        }

    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422'], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }
}



public function verifyPaymentTransaction(Request $request){

    
    $data=$request->all();

    $site_id=$this->getSiteId($request);

    $demand_slip_details=GlobalSiteStudentFeeDemandSlipDetails::where('site_id',$site_id)
        ->where('transaction_token',$data['Token'])
        ->orderBy('id', 'desc')
        ->where('status',1)
        ->first();

    if(!$demand_slip_details){
        $response=[
            'status'=>'411',
            'message'=>'Slip not found!',
        ];

        return response()->json($response);

    }
    

    $studentHistory=GlobalStudentHistory::where('id',$demand_slip_details->student_history_id)->first();

   
      //session check
    $currentTime = Carbon::now('Asia/Dhaka');
    $session=PaymentSession::where('user_id',$studentHistory->user_id)
        ->where('end_date_time','>',$currentTime)
        ->where('token',$data['Token'])
        ->where('ip_address',request()->ip())
        ->where('status',1)
        ->orderBy('id','DESC')
        ->first();
    
    if(!$session){      
        $response=[
            'status'=>'403',
            'message'=>'Payment Session expired!',
        ];

        return response()->json($response,$response['status']);
    }
   
    $user_id=$studentHistory->user_id;

    $user=Student::where('id',$user_id)->first();


    $site_id=$studentHistory->site_id;
//    $academic_group_id=$studentHistory->academic_group_id;
    $username = $user->username;
    $user_id =$user_id;
   
   $req_data=[
        'site_id'=>$site_id,
    //    'academic_group_id'=>$academic_group_id,
        'username'=>$username,
        'user_id'=>$user_id,
    ];

  
    if($data['Mode']=='success'){ 
        
      $res_data=$this->feePaymentAndSonaliPayTokenVerify($data,$req_data);

  
      if($res_data['Status']=='200'){
        $response=$res_data;

      $host = request()->getSchemeAndHttpHost();
      $site_voucher_link=$host.'/site-public/get-site-public-payment-slip/'.$res_data['InvoiceNo'].'/'.$res_data['TransactionId'];
      
      $response=[
            'message'=>$res_data['Message'],
            'status'=>$res_data['Status'],
            'transaction_id'=>$res_data['TransactionId'],
            'token'=>$res_data['Token'],
            'invoice_no'=>$res_data['InvoiceNo'],
            'paid_amount'=>$res_data['CustomerPaidAmount'],
            'gateway_voucher_link'=>$res_data['SonaliVoucherLink'],
            'site_voucher_link'=>$site_voucher_link,
        ];

      }else{

        $response=[
            'message'=>$res_data['Message'],
            'status'=>$res_data['Status'],
        ];
        $response_test=json_encode($res_data);

        $issue = new IssueDetail();
        $issue->issue_type='online-transaction-failed:site-student';
        $issue->issuer_type='site';
        $issue->issue_details=$response_test;
        $issue->site_id=$req_data['site_id'];
        $issue->username=$req_data['username'];
        $issue->ip_address=request()->ip();
        $issue->save();

      }

    }else{
        $response=[
            'status'=>'400',
            'message'=>'Your transaction was unsuccessful. Please check and retry!'
        ];

        $response_test=json_encode($response);

        $issue = new IssueDetail();
        $issue->issue_type='online-transaction-failed:site-student';
        $issue->issuer_type='site';
        $issue->issue_details=$response_test;
        $issue->site_id=$req_data['site_id'];
        $issue->username=$req_data['username'];
        $issue->ip_address=request()->ip();
        $issue->save();

    }

     // session clear
    $session->status=0;
    $session->save();

    return response()->json($response,$response['status']);

}


    public function getPublicStudentPaymentSlip(Request $request, $voucher_no){

        try{

            $site_id=$this->getSiteId($request);


            $check_payment = GlobalSiteStudentFeePaymentHistory::where('voucher_no', $voucher_no)
                ->where('site_id',$site_id)
                ->first();

            if (!$check_payment) {
                return response()->json(['message' => 'Data not found!'], 410);
            }
         

            $payment_details = $this->paymentSlipData($voucher_no);

            if($payment_details['status']!=200){
                return $payment_details['message'];
            }
    
            $payment_data=$payment_details['payment_data'];
            $student_info=$payment_details['student_info'];

            $report_tittle ='Student Fee Voucher';
            $report_tittle2  ='';
            $title_view='Student Fee Voucher';

            $siteInfo= GlobalSiteInfo::where('id',$site_id)
                ->select('id','web_student_fee_collection_status','show_subhead_in_payment_slip')
                ->first();
                
                $slip_key='student';
    
            $pdf = PDF::loadView('default.admin.site.student-fee.report.student-payment-voucher-pdf',
                compact('title_view','report_tittle','report_tittle2','payment_data','student_info','siteInfo','slip_key'));
    
            return $pdf->stream(time() . '-student-payment-slip.pdf');
    
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    
    }


}
