<?php

namespace App\Http\Controllers\Api\StudentPanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicCalendarHead;
use App\Models\Edu\GlobalAcademicCalendar\GlobalAcademicCalendarEvent;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;


class AcademicApiController extends ApiProjectController
{
    private $studentHistory;
    public function __construct(StudentHistory $studentHistory)
    {
       // $this->middleware('api.app.access');
       $this->middleware('auth:apps-api');
       $this->middleware('api.app.access');

        $this->studentHistory = $studentHistory;
    }

    

    
    public function getStudentAcademicCalendarForApi(Request $request)
    {

        try{
      
       $monthIncrement=$request->monthIncrement??0; 
       
        $eventModel = new GlobalAcademicCalendarEvent();

        $dateComponents = getdate(mktime(null, null, null, date('m') + $monthIncrement, 1, date('Y')));

        $month = $dateComponents['mon'];
        $year = $dateComponents['year'];
        $daysOfWeek = array('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
        //  $daysOfWeek = array('Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');

        // What is the first day of the month in question?
        $firstDayOfMonth = mktime(0, 0, 0, $month, 1, $year);

        // How many days does this month contain?
        $numberDays = date('t', $firstDayOfMonth);


        // Retrieve some information about the first day of the
        // month in question.
        $dateComponents = getdate($firstDayOfMonth);

        // What is the name of the month in question?
        $monthName = $dateComponents['month'];
        $dayOfWeek = $dateComponents['wday'];
        $currentDay = 1;

//      =====================empty column check=====================

        $totalNumberDays = $numberDays + $dayOfWeek;

        $dateColumnsNumbers = $totalNumberDays / 7;


        if (is_float($dateColumnsNumbers)){

            $roundNumber = round($dateColumnsNumbers);
            $multipliedNumber =  $roundNumber *7;

            if($multipliedNumber < $totalNumberDays){

                $increseased_number =  $roundNumber + 1;
                $undateColumnsNumbers = $increseased_number * 7 - $totalNumberDays;

            }else if($multipliedNumber > $totalNumberDays){

                $undateColumnsNumbers = $multipliedNumber - $totalNumberDays;
            }

        }else{
            $undateColumnsNumbers = 0;
        }



//      ========================empty column check end===========================

        // $arrayData=array();
        // for($b=1; $b<=$dayOfWeek; $b++){
        //     $arrayData[]="";

        // }

        // for ($i=1; $i<=$numberDays; $i++){

        //     $currentDayRel=str_pad($i, 2, "0", STR_PAD_LEFT);
        //     $date=$year.'-'.$month.'-'.$currentDayRel;

        //     $arrayData[][$i] = GlobalAcademicCalendarEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

        // }

        // for($c=1; $c<=$undateColumnsNumbers; $c++){

        //     $arrayData[]="";

        // }


        // $finalArrayData = array();

        // foreach ($arrayData as $key => $value){
        //     if($key<7){
        //         $finalArrayData['first_row'][$key] = $value;
        //     }elseif ($key>6 && $key<14){
        //         $finalArrayData['second_row'][$key] = $value;
        //     }elseif ($key>13 && $key<21){
        //         $finalArrayData['third_row'][$key] = $value;
        //     }elseif ($key>20 && $key<28){
        //         $finalArrayData['fourth_row'][$key] = $value;
        //     }elseif ($key>27 && $key<35){
        //         $finalArrayData['fifth_row'][$key] = $value;
        //     }elseif ($key>34 && $key<42){
        //         $finalArrayData['sixth_row'][$key] = $value;
        //     }
        // }

        $arrayData = array();
        // for ($b = 1; $b <= $dayOfWeek; $b++) {
        //     $arrayData[] = "";

        // }

    

           // dd($numberDays);
            $keys=0;
        for ($i = 1; $i <= $numberDays; $i++) {

            $currentDayRel = str_pad($i, 2, "0", STR_PAD_LEFT);
            $date = $year . '-' . $month . '-' . $currentDayRel;

            $datas = GlobalAcademicCalendarEvent::where('activate_date', $date)
               // ->where('site_id', $site_id)
               // ->where('academic_group_id', $academic_group_id)
                ->with('academicCalendarHead')
                ->select('activate_date','start_date','end_date','title','description','academic_calendar_head_id','subhead_color_id',
                'day_name','event_type')
                ->get();
            if(count($datas)){
                $arrayData[$keys++]=$datas;
            }
                
        }


        $ac_calendar_head = AcademicCalendarHead::get();

        $calendar_data=[
            // 'month_increment'=>$monthIncrement,
            // 'year'=>$year,
            // 'month'=>$month,
            // 'month_name'=>$monthName,
            // 'number_days'=>$numberDays,
            // 'days_of_week'=>$daysOfWeek,
            // 'day_of_week'=>$dayOfWeek,
            // 'event_model'=>$eventModel,
            'event_date_list'=>$arrayData,
            //'undate_columns_numbers'=>$undateColumnsNumbers,
            'ac_calendar_head'=>$ac_calendar_head,
        ];
        $data=[
            'month_wise_calendar_data'=>$calendar_data,
            'mode'=>'success',
            'status'=>'200',
        ];
        
        return response()->json($data, 200);


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);

        }
    }

    public function getStudentProfileForApi(){

        try{

        $auth= Auth::user();
        $this->authInfoSessionPut();

        $student_history=StudentHistory::with(['student'=>function($q){
            return $q->with('latestPhoto','latestPhotoName','presentCountry','permanentCountry','presentDivision','permanentDivision','presentDistrict',
        'permanentDistrict','presentThana','permanentThana','bloodGroup');
        },
        'version','shift','department','stClass','classGroup','session',
            'gender','year','section','religion'])
            ->where('user_id', $auth->id)
            ->where('status',true)
            ->orderBy('id','DESC')
            ->first();

           if(!$student_history){
             return response()->json(['message'=>'Student Not Found', 'status'=>'422', 'mode'=>'errors', 422]); 
           }
        //   dd($student_history->student->latestPhoto->path);
        
            $academic_info=[];
            $academic_info['version_name']=$student_history->version?$student_history->version->version_name:'';
            $academic_info['shift_name']=$student_history->shift?$student_history->shift->shift_name:'';
            $academic_info['year']=$student_history->year?$student_history->year->year_name:'';
            $academic_info['session']=$student_history->session?$student_history->session->session_name:'';
            $academic_info['department_name']=$student_history->department?$student_history->department->department_name:'';
            $academic_info['class_name']=$student_history->stClass?$student_history->stClass->class_name:'';
            $academic_info['class_group_name']=$student_history->classGroup?$student_history->classGroup->group_name:'';
            $academic_info['section_name']=$student_history->section?$student_history->section->section_name:'';

            $present_address=[];
            $present_address['country_name']=$student_history->student->presentCountry?$student_history->student->presentCountry->country_name:'';
            $present_address['division_name']=$student_history->student->presentDivision?$student_history->student->presentDivision->division_name:'';
            $present_address['district_name']=$student_history->student->presentDistrict?$student_history->student->presentDistrict->district_name:'';
            $present_address['thana_name']=$student_history->student->presentThana?$student_history->student->presentThana->thana_name:'';
            $present_address['address_name']=$student_history->student?$student_history->student->address:'';
           
            $permanent_address=[];
            $permanent_address['country_name']=$student_history->student->permanentCountry?$student_history->student->permanentCountry->country_name:'';
            $permanent_address['division_name']=$student_history->student->permanentDivision?$student_history->student->permanentDivision->division_name:'';
            $permanent_address['district_name']=$student_history->student->permanentDistrict?$student_history->student->permanentDistrict->district_name:'';
            $permanent_address['thana_name']=$student_history->student->permanentThana?$student_history->student->permanentThana->thana_name:'';
            $permanent_address['address_name']=$student_history->student?$student_history->student->address:'';

            $address=[];
            $address['present_address']=$present_address;
            $address['permanent_address']=$permanent_address;

            $profile=[];
            $profile['id']=$auth->id;
            $profile['username']=$auth->username;
            $profile['first_name']=$auth->first_name;
            $profile['last_name']=$auth->last_name;
            $profile['photo']=$student_history->student->latestPhoto?$student_history->student->latestPhoto->path:'/uploads/image-not.png';
            $profile['father_name']=$auth->father_name;
            $profile['mother_name']=$auth->mother_name;
            $profile['blade_group']=$student_history->student->bloodGroup?$student_history->student->bloodGroup->blood_group_name:'';
            $profile['academic_info']=$academic_info;
            $profile['address']=$address;
            $profile['contact_number']=$student_history->student?$student_history->student->contact_number:'';;

            $data=[
                'student_profile'=>$profile,
                'mode'=>'success',
                'status'=>'200',
            ];
            
            return response()->json($data, 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }

    public function getStudentAcademicSubjectListForApi(){
      //  dd('sf');
      try{

        $this->authInfoSessionPut();

        $student_history=StudentHistory::where('user_id', Auth::user()->id)
        ->where('status',true)
        ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session'])
        // ->select('id', 'user_id', 'student_roll_number', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
        //     'academic_class_group_id', 'academic_section_id', 'academic_session_id')
        ->orderBy('id','DESC')
        ->first();

        if(!$student_history){
            return response()->json(['message'=>'Student not found', 'status'=>'422', 'mode'=>'errors', 422]); 
        }

        $subject_settings=SubjectGroupConditionSetting::where('academic_year_id', $student_history->academic_year_id)
            ->where('academic_class_id', $student_history->academic_class_id)
            ->whereIn('academic_subject_id', $student_history->academic_subject_ids[1])
            ->orderBy('subject_position')
            ->orderBy('subject_code')
            ->get();

        $subject_list=[];

        foreach($subject_settings as $key=>$item){

            $condition_list=[];
            foreach($item->academic_subject_conditions as $keyy=>$itemm){
                $condition_list[$keyy]['condition']=$itemm->name;
            }

            $subject_list[$key]['id']=$item->academic_subject_id;
            $subject_list[$key]['subject_name']=$item->subject_name;
            $subject_list[$key]['subject_code']=$item->subject_code;
            $subject_list[$key]['academic_subject_conditions']=$condition_list;
        }

        $data=[
            'subject_list'=>$subject_list,
            'mode'=>'success',
            'status'=>'200',
        ];
        
        return response()->json($data, 200);

    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

    }
}
