<?php

namespace App\Http\Controllers\Api\StudentPanel;

use App\Forms\DataHelper;
use App\Http\Controllers\ProjectController;
use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\Site\Academic\GlobalSitePeriodTypeDuration;
use App\Models\Site\Live\MeetingInvitation;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\GlobalRoutineDetail;
use App\Models\Site\SiteShiftDetails;
use App\Models\Site\Student\Attendance\PeriodicAttendance;
use App\Models\Site\Student\GlobalStudentHistory;

use App\Traits\Site\EventTrait;
use App\Traits\Site\GlobalFunctionsTrait;
use App\Traits\Site\Routine\RoutineFunction;
use Carbon\Carbon;
use DateTime;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicSection;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\GlobalSiteExamDeclares;
use App\Models\Site\Exam\GlobalSiteExamDeclareStudent;
use App\Models\Site\Exam\GlobalSiteExaminationExamTypeSetting;
use App\Models\Site\Exam\GlobalSiteExamRoutine;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Result\GlobalSiteResultSystemSetting;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\SiteInfo;
use App\Models\Site\YearShiftVersionSessionSectionClassWiseSiteSettings;
use App\Models\SiteGroup\Site\Employee\Employee;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\Student\StudentHistory;

use PDF;
use Exception;
use Session;
use Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;

class StudentExamApiController extends ProjectController
{

    private $auth;


    public function __construct()
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');

    }



  
    public function siteStudentAllHistoryListForApi(){

        try{

        $auth= Auth::user();
        $academic_group_id=$auth->academic_group_id;
        $site_id=$auth->site_id;
        $id = $auth->id;

        $student_detail=GlobalStudentHistory::where('user_id', Auth::user()->id)
                ->where('site_id',$site_id)
                ->where('academic_group_id',$academic_group_id)
                ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session'])
                ->select('id', 'user_id', 'student_roll_number', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
                    'academic_class_group_id', 'academic_section_id', 'academic_session_id')
                ->get();

            $data=[
                'student_history_list'=>$student_detail,
                'mode'=>'success',
                'status'=>'200',
            ];
    
            return response()->json($data,200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }


 
    
    public function getExamSubjectRoutineList(Request $request){
        try{

        if(!$request->student_history_id || !$request->examination_id){
            return response()->json(['message'=>'Paramitter Missing', 'status'=>'422', 'mode'=>'errors', 422]); 
        }

        $auth= Auth::user();
        $academic_group_id=$auth->academic_group_id;
        $site_id=$auth->site_id;
        $id = $auth->id;

        Session::put('SITE_ID',$site_id);

        $exam_routine_ids=SiteExamDeclareStudentSubject::where('student_history_id', $request->student_history_id)
            ->where('examination_id', $request->examination_id)
            ->pluck('site_exam_routine_id')
            ->unique()
            ->filter();

            if(count($exam_routine_ids)<1){
                return response()->json(['message'=>'Routine Not found', 'status'=>'404', 'mode'=>'errors'],404); 
            }

        $routine_list=GlobalSiteExamRoutine::with(['academicExamType',
            'globalSubjectGroupConditionSetting'=>function($query){
                $query->select('id', 'academic_subject_id');
                $query->orderBy('subject_position');
            }])
            ->where('site_id', $site_id)
            ->where('academic_group_id', $academic_group_id)
            ->whereIn('id', $exam_routine_ids)
            ->select('id', 'site_subject_group_condition_setting_id',
                'academic_exam_type_id', 'exam_start_date', 'exam_start_time', 'exam_end_time','exam_duration',
                'examination_id')
            ->distinct('site_subject_group_condition_setting_id')
            ->orderBy('exam_start_date')
            ->get();


            $site_info =  SiteInfo::find(Session::get('SITE_ID'));

            $student_history=GlobalStudentHistory::findOrFail($request->student_history_id);

            $exam = Examination::findOrFail($request->examination_id);

         //   $report_tittle .=$result_name;
            $report_tittle="";
            $report_tittle .= '<br/>';
            $report_tittle .= 'Exam Routine';

           
    
            $year=AcademicYear::find($student_history->academic_year_id);
            $class_group=AcademicClassGroup::find($student_history->academic_class_group_id);
            $class=AcademicClass::find($student_history->academic_class_id);
            $section=AcademicSection::find($student_history->academic_section_id);

            $examination_name = $exam->examination_name;
            $year_name = $year->year_name;


            $report_tittle2='';

            $report_tittle2 .= 'Year : '.$year->year_name;
       
 
            if($class){
             $academic_class=$class?$class->class_name:'';
             $report_tittle2 .= ', Class : '.$academic_class;
      
            }
     
            if($class_group){
             $academic_class_group=$class_group?$class_group->group_name:'';
             $report_tittle2 .= ', Group : '.$academic_class_group;
      
            }
           
            $pdf = PDF::loadView('default.admin.site.exam.site-base-exam-routine-pdf',
            compact('routine_list', 'report_tittle', 'report_tittle2', 'site_info','examination_name','year_name'))
            ->setWarnings(false);
        
    
            $time = 'Exam-routine' . '-' . Carbon::now()->unix();
            $name = $time . '.pdf';
    
            return $pdf->stream($name);

          //  return response()->json($data,200);


    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

    }


    public function getExamTypeListForStudenApi(Request $request){
        try{

        if(!$request->student_history_id){
            return response()->json(['message'=>'Paramitter Missing', 'status'=>'422', 'mode'=>'errors', 422]); 
        }
        $auth= Auth::user();
        $site_id=$auth->site_id;

        Session::put('SITE_ID',$site_id);

        $examination_ids=SiteExamDeclareStudentSubject::where('student_history_id', $request->student_history_id)
            ->where('site_id',$site_id)
            ->pluck('examination_id')
            ->unique()
            ->filter();
           // dd($examination_ids);

        $examination_list=Examination::whereIn('id', $examination_ids)->get();

            $data=[
                'examination_list'=>$examination_list,
                'mode'=>'success',
                'status'=>'200',
            ];
    
            return response()->json($data,200);


    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

    }

    
    private function checkStudentPayment($request,$student_history){

        $examinationExamTypeCheck=SiteExaminationExamTypeSetting::
                where('academic_year_id', $student_history->academic_year_id)
                ->where('academic_class_id', $student_history->academic_class_id)
                ->where('examination_id', $request->examination_id)
                ->when(!empty($student_history->academic_department_id), function ($query) use ($student_history) {
                    return $query->where('academic_department_id', $student_history->academic_department_id);
                })
                ->first();

            //  dd($examinationExamTypeCheck,$student_history);

                if(!$examinationExamTypeCheck){
                    return ['mode'=>'errors', 'status'=>false]; 
                }

            // dd($examinationExamTypeCheck->admit_card_permission_with_due_payment);

                if($examinationExamTypeCheck->admit_card_permission_with_due_payment){ //admit_card_permission_with_due_payment
                    $demand_slip = SiteStudentFeeDemandSlipDetails::where('student_history_id', $student_history->id)
                        ->where('status', 1)
                        ->get();

                    if(count($demand_slip)>0){
                        return ['mode'=>'success', 'status'=>true]; 
                    }
                }

        return ['mode'=>'success', 'status'=>false]; 

    }




    public function studentExamDetailForAdmitCardPdfFroApi(Request $request){
        try{

            if(!$request->student_history_id || !$request->examination_id){
                return response()->json(['message'=>'Paramitter Missing', 'status'=>'422', 'mode'=>'errors', 422]); 
            }
    
        ini_set('memory_limit', '-1');

        $auth= Auth::user();
        $academic_group_id=$auth->academic_group_id;
        $site_id=$auth->site_id;

         
        Session::put('SITE_ID',$site_id);
        Session::put('ACADEMIC_GROUP_ID',$academic_group_id);

        $page_tittle = "Admit Card";
        $report_tittle = "<b>Admit Card</b> <br/>";
        $report_tittle2 = " ";
        $title_view = "Admit Card";

        $req_data=[
            'is_image_show'=>true,
            'is_subject_show'=>true,
            'is_description_show'=>true,
            'is_exam_date_show'=>false,
            'is_terms_and_condition_show'=>false,
        ];

        $student_history=StudentHistory::findOrFail($request->student_history_id);
    
        $checkPayment=$this->checkStudentPayment($request,$student_history);

        if($checkPayment['mode']=='errors'){
            return Response::json(['message'=>'Admit card not found!'],410);
        }

       if($checkPayment['status']==true){
             return Response::json(['message'=>'You must make the remaining payment first.', 'status'=>'410', 'mode'=>'errors'],410);
       }

        $student_list=$this->studentExamDetailForAdmitCard($request,$student_history);

      
        $examination=Examination::where('id', $request->examination_id)->first();
        $examination_name=$examination->examination_name;

        $year=AcademicYear::where('id', $student_history->academic_year_id)->first();
        $year_name=$year->year_name;

        //description 
        $institute_head = Employee::where('institute_head', 1)->first();
        $signature = $institute_head->signature ?? '/img/signature/signature.png';
  
       // $data=$request->all();
        
        $admitSettings=$this->checkSiteClassSettings($request,$student_history);
       
        $admit_card_description=$admitSettings?$admitSettings->admit_card_description:"";

        $pdf = PDF::loadView('default.admin.site.exam.report.exam-admit-card-pdf',
            compact('student_list', 'examination', 'examination_name', 'year_name', 'report_tittle',
                'page_tittle', 'report_tittle2', 'admit_card_description', 'title_view','req_data','signature'))
            ->setWarnings(false);


         $time = 'admit-card' . '-' . Auth::user()->id;
         $name = $time . '.pdf';
 
         return $pdf->stream($name);
       
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors'], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
     
    }

    private function studentExamDetailForAdmitCard($request,$student_history){


        $exam_declare_ids = SiteExamDeclares::where('academic_version_id', $student_history->academic_version_id)
            ->where('academic_year_id', $student_history->academic_year_id)
            ->where('academic_class_id', $student_history->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($student_history->academic_shift_id), function ($query) use ($student_history) {
                return $query->where('academic_shift_id', $student_history->academic_shift_id);
            })
            ->when(!empty($student_history->academic_department_id), function ($query) use ($student_history) {
                return $query->where('academic_department_id', $student_history->academic_department_id);
            })
            ->where('status', true)
            ->pluck('id');

            if(count($exam_declare_ids)<1){
                return response()->json(['message'=>'Admit Card Not found', 'status'=>'404', 'mode'=>'errors'],404); 
            }


         //   dd($exam_declare_ids);

        // $student_ids=GlobalSiteExamDeclareStudent::whereIn('site_exam_declare_id', $exam_declare_ids)
        //     ->where('status', true)
        //     ->pluck('student_history_id')
        //     ->unique()
        //     ->values();


        $subject_settings_ids=SubjectGroupConditionSetting::where('academic_year_id', $student_history->academic_year_id)
                ->where('academic_class_id', $student_history->academic_class_id)
                ->orderBy('subject_position')
                ->orderBy('subject_code')
                ->get()
                ->pluck('id')
                ->values();


        $placeholders = implode(',',array_fill(0, count($subject_settings_ids), '?'));

        $student_list=StudentHistory::with(['siteExamDeclareStudentSubject'=>function($query) use ($exam_declare_ids,$placeholders,$subject_settings_ids){
                $query->with(['subjectGroupConditionSetting'=>function($q){
                    $q->select('id', 'academic_subject_id','subject_code','subject_position');
                    $q->orderBy('id');
                    }]);
                $query->whereIn('site_exam_declare_id', $exam_declare_ids);
                $query->distinct('student_history_id', 'site_subject_group_condition_setting_id');
                $query->select('student_history_id', 'site_subject_group_condition_setting_id');
                $query->orderByRaw("field(site_subject_group_condition_setting_id,{$placeholders})", $subject_settings_ids);
            },'siteGroupStudentExamRoll'=>function($qww) use ($request){
               return $qww->where('examination_id',$request->examination_id);
            }])
            ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session', 'year', 'academicStudentCategory',
                'student'=>function($query){
                    $query->with(['gender', 'religion', 'latestPhoto'=>function($query){
                        $query->select('name','path','imageable_id');
                    }]);
                    $query->select('id', 'gender_id', 'religion_id');

                }])
            ->where('id', $request->student_history_id)
            ->select('id', 'user_id', 'student_roll_number', 'academic_year_id',
                'academic_department_id', 'academic_class_id', 'academic_shift_id', 'optional_subject_ids',
                'academic_student_category_id',
                'academic_class_group_id', 'academic_section_id', 'academic_session_id', 'student_roll_number_prefix')
            
                ->orderBy('student_roll_number')
                ->orderBy('academic_section_id')
                ->orderBy('academic_department_id')
                ->orderBy('academic_class_id')
                ->orderBy('academic_class_group_id')
                ->get();

               // dd($student_list[0]->siteExamDeclareStudentSubject);

           return $student_list;


    }

    private function checkSiteClassSettings($request,$student_history){
        
        $admitSettings=YearShiftVersionSessionSectionClassWiseSiteSettings::where('academic_year_id', $student_history->academic_year_id)
        ->where('academic_year_id', $student_history->academic_year_id)    
        ->where('academic_shift_id', $student_history->academic_shift_id)    
        ->when(!empty($student_history->academic_department_id), function ($query) use ($student_history) {
                return $query->where('academic_department_id', $student_history->academic_department_id);
            })
        ->when(!empty($student_history->academic_session_id), function ($query) use ($student_history) {
                return $query->where('academic_session_id', $student_history->academic_session_id);
            })
        // ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
        //         return $query->where('academic_section_id', $data['academic_section_id']);
        //     })
        ->first();
        return $admitSettings;
    }



    



}
