<?php

namespace App\Http\Controllers\Api\StudentPanel;

use App\Forms\DataHelper;
use App\Http\Controllers\ProjectController;
use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\Site\Academic\GlobalSitePeriodTypeDuration;
use App\Models\Site\Live\MeetingInvitation;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\GlobalRoutineDetail;
use App\Models\Site\SiteShiftDetails;
use App\Models\Site\Student\Attendance\PeriodicAttendance;
use App\Models\Site\Student\GlobalStudentHistory;

use App\Traits\Site\EventTrait;
use App\Traits\Site\GlobalFunctionsTrait;
use App\Traits\Site\Routine\RoutineFunction;
use Carbon\Carbon;
use DateTime;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Site\Employee\GlobalEmployee;
use App\Models\Site\Result\GlobalSiteResultSystemSetting;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;
use App\Traits\Site\Result\ExamResultTrait;
use PDF;
use Exception;
use Session;
use Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;

class StudentExamResultApiController extends ProjectController
{
    use DataHelper, RoutineFunction, EventTrait, ExamResultTrait;

    private $studentAttendance;
    private $periodTypeDuration;
    private $routineAllocation;
    private $studentHistory;
    private $routineDetail;
    private $meetingInvitation;
    private $periodicAttendance;
    private $siteShiftDetails;
    private $auth;


    public function __construct(GlobalStudentHistory $studentHistory, MeetingInvitation $meetingInvitation, GlobalStudentAttendance $studentAttendance, GlobalSitePeriodTypeDuration $periodTypeDuration,
    GlobalRoutineDetail $routineDetail, RoutineAllocation $routineAllocation, PeriodicAttendance $periodicAttendance, SiteShiftDetails $siteShiftDetails)
    {

        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');

        //$this->middleware('sitepagechecker');
        $this->periodicAttendance = $periodicAttendance;

        $this->meetingInvitation = $meetingInvitation;
        $this->studentAttendance = $studentAttendance;
        $this->periodTypeDuration = $periodTypeDuration;
        $this->routineAllocation = $routineAllocation;
        $this->studentHistory = $studentHistory;
        $this->routineDetail = $routineDetail;
        $this->siteShiftDetails = $siteShiftDetails;
        $this->auth = Auth::user();

    }



  
    public function siteStudentAllHistoryListForApi(){

        try{
        $auth= Auth::user();
        $academic_group_id=$auth->academic_group_id;
        $site_id=$auth->site_id;
        $id = $auth->id;

        $student_histories=GlobalStudentHistory::where('user_id', Auth::user()->id)
                ->where('site_id',$site_id)
                ->where('academic_group_id',$academic_group_id)
                ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session'])
                ->select('id', 'user_id', 'student_roll_number', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
                    'academic_class_group_id', 'academic_section_id', 'academic_session_id')
                ->get();

            $student_history_array=[];
            foreach($student_histories as $key=>$history){
                $student_history_array[$key]['id']          =   $history->id;
                $student_history_array[$key]['class_id']    =   $history->stClass?$history->stClass->id:null;
                $student_history_array[$key]['class_name']  =   $history->stClass?$history->stClass->class_name:'';
                $student_history_array[$key]['group_id']    =   $history->classGroup?$history->classGroup->id:null;
                $student_history_array[$key]['group_name']  =   $history->classGroup?$history->classGroup->group_name:'';
                $student_history_array[$key]['session_id']  =   $history->session?$history->session->id:null;
                $student_history_array[$key]['session_name']=   $history->session?$history->session->session_name:'';
                $student_history_array[$key]['section_id']  =   $history->section?$history->section->id:null;
                $student_history_array[$key]['section_name']=   $history->section?$history->section->section_name:'';
                $student_history_array[$key]['roll']        =   $history->student_full_roll_number;
            }

        $data=['student_history_list'=>$student_history_array,'mode'=>'success','status'=>'200'];

        return response()->json($data,200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }

    
    public function getStudentPrimaryResultListForStudentApi(Request $request){
        
    try{

        $data=$request->all();

        $auth= Auth::user();
        $academic_group_id=$auth->academic_group_id;
        $site_id=$auth->site_id;
        Session::put('SITE_ID',$site_id);
        $data['site_id']=$site_id;
        $data['academic_group_id']=$academic_group_id;

          $studentHistory=GlobalStudentHistory::where('id', $data['student_history_id'])
            ->select('academic_version_id', 'academic_year_id', 'academic_shift_id', 'academic_class_id',
                'academic_section_id', 'academic_class_group_id', 'academic_session_id', 'site_batch_detail_id',
                'academic_group_id')
            ->first();

        $checkGroupPermission=GlobalSiteGroupResultPermission::where('academic_year_id',$studentHistory->academic_year_id)
            ->where('academic_class_id',$studentHistory->academic_class_id)
            ->where('site_id',$data['site_id'])
            ->where('academic_group_id',$data['academic_group_id'])
            ->where('student_result_permission_status', true)
            ->pluck('academic_result_primary_type_id');


        $primary_exam_type_ids = GlobalSiteStudentPrimaryResultDetail::where('student_history_id', $request->student_history_id)
            ->where(function ($query) use ($checkGroupPermission) {
                $query->where(function ($q) {
                    $q->where('result_generated_by', 'site')
                    ->where('result_public_publish_status', true);
                })->orWhere(function ($q) use ($checkGroupPermission) {
                    $q->where('result_generated_by', 'site_group')
                    ->whereIn('academic_result_primary_type_id', $checkGroupPermission);
                });
            })
            ->where('site_id', $site_id)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->filter();


        $result_primary_type_list=AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)
            ->where('use_key', 'site')
            ->get();

        $modifiedList = $result_primary_type_list->map(function ($item) {
            if ($item->use_key === 'site_group') {
                $item->examination_name = $item->examination_name. '(Central Result)';
            }

            return $item;
        });


        $data=[
            'result_primary_type_list'=>$modifiedList,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);

    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

    }

    
    public function getPrimaryResultTypeResultDetailForStudentApi(Request $request){

        try{

        $auth= Auth::user();
        $data=[];
        $data=$request->all();
        $data['site_id']=$auth->site_id;
        $data['academic_group_id']=$auth->academic_group_id;

        $studentHistory=GlobalStudentHistory::where('id', $request->student_history_id)
            ->where('site_id',$data['site_id'])
            ->select('id','academic_version_id','academic_year_id','academic_shift_id','academic_class_id','academic_section_id','academic_class_group_id',
            'academic_session_id','site_batch_detail_id','academic_group_id')
            ->first();

        $student_history_ids=[$studentHistory->id];

        $data['academic_version_id']=$studentHistory->academic_version_id;
        $data['academic_year_id']=$studentHistory->academic_year_id;
        $data['academic_shift_id']=$studentHistory->academic_shift_id;
        $data['academic_class_id']=$studentHistory->academic_class_id;
        $data['academic_section_id']=$studentHistory->academic_section_id;
        $data['academic_class_group_id']=$studentHistory->academic_class_group_id;
        $data['academic_session_id']=$studentHistory->academic_session_id;
        $data['site_batch_detail_id']=$studentHistory->site_batch_detail_id;
        $data['academic_group_id']=$studentHistory->academic_group_id;

        $resultPdf=$this->primaryResultTypeBaseResultDetails($data,$student_history_ids,'site_student');

         $data=[
                'result_array'=>$resultPdf['result_array'],
                'mode'=>'success',
                'status'=>'200',
            ];
    
        return response()->json($data,200);


        
        // $student_ids=GlobalStudentHistory::where('academic_version_id', $student_detail['academic_version_id'])
        //         ->where('site_id',$site_id)
        //         ->where('academic_group_id',$academic_group_id)
        //          ->when(!empty($student_detail['academic_year_id']), function ($query) use ($student_detail) {
        //              return $query->where('academic_year_id', $student_detail['academic_year_id']);
        //          })
        //          ->when(!empty($student_detail['academic_shift_id']), function ($query) use ($student_detail) {
        //              return $query->where('academic_shift_id', $student_detail['academic_shift_id']);
        //          })
        //          ->when(!empty($student_detail['academic_department_id']), function ($query) use ($student_detail) {
        //              return $query->where('academic_department_id', $student_detail['academic_department_id']);
        //          })
        //          ->when(!empty($student_detail['academic_class_id']), function ($query) use ($student_detail) {
        //              return $query->where('academic_class_id', $student_detail['academic_class_id']);
        //          })
        //          ->when(!empty($student_detail['academic_session_id']), function ($query) use ($student_detail) {
        //              return $query->where('academic_session_id', $student_detail['academic_session_id']);
        //          })
        //          ->pluck('id');


        // $dataaa=SiteStudentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
        //     $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
        //         'academic_session_id', 'academic_student_category_id', 'board_registration_number',
        //         'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
        //         'registration_no');
        //     $query->with(['student' => function ($q) {
        //         $q->with('latestPhoto');
        //         $q->select('id');
        //         $q->where('user_type', 'student');
        //     },
        //         'year', 'shift','department','stClass','classGroup','session','section'
        //     ]);
        // }, 'academicResultPrimaryType'])
        //     ->where('student_history_id', $request->student_history_id)
        //     ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
        //     ->where('status', true)
        //     ->where('result_student_publish_status', true)
        //     ->get();

        //     $hight_marks_ids=SiteIndividualCombineSubjectResultStore::
        //     where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
        //         ->whereIn('student_history_id',$student_ids)
        //         ->where('status', true)
        //         ->pluck('exam_dependent_academic_subject_id')->unique()->filter();
    
        //     $hight_marks_list=[];
        //     foreach ($hight_marks_ids as $key => $value){
        //         $hight_marks_subject=SiteIndividualCombineSubjectResultStore::
        //         where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
        //             ->whereIn('student_history_id', $student_ids)
        //             ->where('exam_dependent_academic_subject_id', $value)
        //             ->where('status', true)
        //             ->orderBy('obtain_raw_total_marks', 'desc')
        //             ->select('exam_dependent_academic_subject_id', 'obtain_raw_total_marks','obtain_total_marks_for_show')
        //             ->first();
    
        //         if($hight_marks_subject){
        //             $hight_marks_list[]=$hight_marks_subject;
        //         }
    
        //     }

        // if(count($dataaa)<1){
        //     return response()->json(['message'=>'Data Not found', 'status'=>'404', 'mode'=>'errors'],404); 
        // }

        // $a_arr=Array();
        // $result_list_array=[];
        // foreach ($dataaa as $key => $value){

        //     $b_array=[];
        //     foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet){
        //         $b_array[]=$valuet->subject_detail;
        //     }


        //     $subject_ids=collect($b_array)->pluck('exam_dependent_academic_subject_id')->unique();
        //     $result_show_in_table_bellow_status_present=collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();

        //     $highest_marks_list=collect($hight_marks_list)->whereIn('exam_dependent_academic_subject_id', $subject_ids);


        //     $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
        //     $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
        //     $a_arr['student_history_id']=$value->student_history_id;
        //     $a_arr['fail_subject_count']=$value->fail_subject_count;
        //     $a_arr['gpa']=$value->gpa;
        //     $a_arr['grade']=$value->grade;
        //     $a_arr['student_rank']=$value->student_rank;
        //     $a_arr['site_result_primary_setting_id']=$value->site_result_primary_setting_id;
        //     $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
        //     $a_arr['subject_list']=$b_array;
        //     $a_arr['table_header']=$value->table_header;
        //     $a_arr['highest_marks']=$highest_marks_list;
        //     $a_arr['student_history']=$value->studentHistory;
            
        //     $a_arr['result_type_id']=$value->academicResultPrimaryType->id;

        //     $a_arr['result_show_in_table_bellow_status_present']=count($result_show_in_table_bellow_status_present)>0?1:0;
            
        //   //  $a_arr['total_student']=count($student_ids);
        //     $a_arr['total_student']=$value->total_student;

        //     $a_arr['student_photo']=$value->studentHistory->student->latestPhoto?
        //         $value->studentHistory->student->latestPhoto->name:'image-not.png';

        //     $a_arr['classtest_is_present']=$value->classtest_is_present;
        //     $a_arr['combine_subject_present']=$value->combine_subject_present;
        //     $a_arr['final_grade_without_optional']=$value->final_grade_without_optional;
        //     $a_arr['final_point_without_optional']=$value->final_point_without_optional;
        //     $a_arr['id']=$value->id;
        //     $a_arr['raw_obtain_marks_percentage']=number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
        //     $a_arr['sum_of_obtain_percent_total_marks']=$value->sum_of_obtain_percent_total_marks;
        //     $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
        //     $a_arr['sum_of_raw_total_marks']=$value->sum_of_raw_total_marks;
        //     $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
        //     $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;

        //     $a_arr['sum_of_obtain_total_marks_for_show']=$value->sum_of_obtain_total_marks_for_show;
        //     $a_arr['sum_of_obtain_total_percent_for_show']=$value->sum_of_obtain_total_percent_for_show;
          
        //     $a_arr['academic_days']=$value->academic_days;
        //     $a_arr['present_days']=$value->present_days;
        //     $a_arr['absent_days']=$value->absent_days;
        //     $a_arr['behaviour']=$value->behaviour;
        //     $a_arr['cultural_activities']=$value->cultural_activities;
        //     $a_arr['bncc']=$value->bncc;
        //     $a_arr['debate']=$value->bncc;
        //     $a_arr['scout']=$value->scout;
        //     $a_arr['sports']=$value->sports;
        //     $a_arr['others']=$value->others;
          
        // $result_list_array[$key]=array_merge($a_arr);

        // }

        //     $data=[
        //         'result_array'=>$result_list_array,
        //         'mode'=>'success',
        //         'status'=>'200',
        //     ];
    
        //     return response()->json($data,200);

    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()]);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',]);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors']);
    }
    }


    public function getPrimaryResultTypeResultDetailForStudentApiPdf(Request $request){

        try{

        $data=[];
        $data=$request->all();
        
        $student_history_ids=[$data['student_history_id']];
        $auth= Auth::user();
      
        $data['site_id']=$auth->site_id;
        $data['academic_group_id']=$auth->academic_group_id;

        $studentHistory=GlobalStudentHistory::where('id', $data['student_history_id'])
             ->where('site_id',$data['site_id'])
            ->select('id','academic_version_id','academic_year_id','academic_shift_id','academic_class_id','academic_section_id','academic_class_group_id',
            'academic_session_id','site_batch_detail_id','academic_group_id')
            ->first();
        
        $data['academic_version_id']=$studentHistory->academic_version_id;
        $data['academic_year_id']=$studentHistory->academic_year_id;
        $data['academic_shift_id']=$studentHistory->academic_shift_id;
        $data['academic_class_id']=$studentHistory->academic_class_id;
        $data['academic_section_id']=$studentHistory->academic_section_id;
        $data['academic_class_group_id']=$studentHistory->academic_class_group_id;
        $data['academic_session_id']=$studentHistory->academic_session_id;
        $data['site_batch_detail_id']=$studentHistory->site_batch_detail_id;
        $data['academic_group_id']=$studentHistory->academic_group_id;

        $resultPdf=$this->studentResulDetailsPdf($data,$student_history_ids,'site_student');

          if($resultPdf['status']==200){
            return $resultPdf['stream_pdf'];
        }else{
            return Response::json([
                'message' => 'Failed to Create Card Report',
                'status'=> $resultPdf['status']
            ]);
        }


    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

    }



    



}
