<?php

namespace App\Http\Controllers\Api\StudentPanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Quiz\Question\SiteQuizQuestionForStudent;
use App\Models\Site\Quiz\Question\StudentQuizAnswerDetails;
use App\Models\Site\Quiz\QuizDeclareSettings;
use App\Models\Site\Quiz\QuizDeclareStudents;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\User\UserMessage;
use App\Traits\PaginationTrait;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Session;
use Response;
use DB;


class StudentMessageController extends ApiProjectController
{
    use PaginationTrait;
    private $studentHistory;
    public function __construct(GlobalStudentHistory $studentHistory)
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');

        $this->studentHistory = $studentHistory;
    }

    

    public function getMessageList(Request $request)
    {

        try{

        $paginate = $request->paginate??10;
        
        $this->authInfoSessionPut();

        $message_list = UserMessage::with(['creator'=>function($q){
                    $q->select('id');
                }])
                ->where('user_id', Auth::id())
                ->where('message_type_key', 'message')
                ->orderBy('id','DESC')
                ->paginate($paginate);
                
            $data=[
                'message_list'=>$message_list,
                'mode'=>'success',
                'status'=>'200',
            ];
        
            return response()->json($data,200);


        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
      
    }

   
}
