<?php

namespace App\Http\Controllers\Api;


use App\Forms\DataHelper;
use App\Models\Academic\AcademicCalendarHead;


use App\Models\Academic\AcademicGroup;
use App\Models\Site\Notice\Notice;

use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting;
use App\Models\Site\Web\AboutUs\AboutUs;
use App\Models\Site\Web\Calendar\CalenderEvent;
use App\Models\Site\Web\ClassRoom\ClassRoom;
use App\Models\Site\Web\DesingSetting\SiteWebsiteHeaderDesign;
use App\Models\Site\Web\Event\Event;

use App\Models\Site\Web\SiteWebSiteVisitorDetail;

use Carbon\Carbon;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\DB;
use Session;
use Illuminate\Http\JsonResponse;
use Response;
use Auth;
use App\Models\Site\Web\Video\Video;
use Illuminate\Foundation\Application;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Web\Calendar\GlobarCalenderEvent;
use Illuminate\Validation\ValidationException;

use Illuminate\Database\Eloquent\ModelNotFoundException;

class WebSiteApiController extends Controller
{



    public function __construct()
    {
       // $this->middleware('auth:api');

        $this->middleware('api.app.access');
        $this->middleware('site_id.check');
    }

   
   
    // public function checkUserAuth(){
    
      
  
    //     if(Auth::user()){
    //         $auth_status=true;
    //     }else{
    //         $auth_status=false;
    //     }

    //     $data=[
    //         'auth_status'=>$auth_status,
    //         'mode'=>'success',
    //         'status'=>'200',
    //     ];

    //     return response()->json($data,200);

    // }

    private function getSiteId($request){
         
        if(empty($request->site_id)){
            $domain = "";
            if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                $getHost = explode(".", $_SERVER['HTTP_HOST']);
                $domain = array_shift($getHost);
            }
            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            $site_id = $site_info->id;
            Session::put('SITE_ID', $site_id);
        }else{
            Session::put('SITE_ID', $request->site_id);
            $site_id = $request->site_id;
        }
        return $site_id;
    }

       public function getSiteInfoAndSiteSettings(Request $request){
        $site_id = $this->getSiteId($request);

        $site_info = GlobalSiteInfo::where('id', $site_id)
                ->select('id','website_result_show_by_username')
                ->first();

        if (!$site_info) {
            return response()->json(['message' => 'Site not found','status'=>'404'], 404);
        }

        $data=[
            'id' => $site_info->id,
            'website_result_show_by_username' => $site_info->website_result_show_by_username,
            'site_alias' => $site_info->site_alias,
            'site_name' => $site_info->site_name,
            'site_email' => $site_info->site_email,
            'site_phone' => $site_info->site_phone,
            'site_address' => $site_info->site_address,
        ];

        return response()->json(['site_settings'=>$data,'status'=>'200','message'=>'success'], 200, []);

    }





    public function getAboutUs(Request $request)
    {
        try{
        $site_id=$this->getSiteId($request);

     //   $site_settings = SiteWebsiteHeaderDesign::where('site_id', $site_id)->select('site_id','aboutus_show_status',
      //  'theme_background_color','theme_text_color','theme_language')->first();

        $latest_about_data = AboutUs::where('status', 1)
            ->where('type','aboutus')
            ->where('site_id',$site_id)
            ->with('latestPhoto')
            ->orderBy('id', 'DESC')
            ->first();

          //  dd($latest_about_data);

            $latest_about_data_list = [
                'id' => $latest_about_data->id,
                'description' => $latest_about_data->description,
                'title' => $latest_about_data->title,
                'image' => $latest_about_data->latestPhoto?$latest_about_data->latestPhoto->path:null,
                // 'aboutus_show_status' => $site_settings?$site_settings->aboutus_show_status:true,
                // 'theme_background_color' => $site_settings?$site_settings->theme_background_color:true,
                // 'theme_text_color' => $site_settings?$site_settings->theme_text_color:true,
                //'theme_language' => $site_settings?$site_settings->theme_language:true,
            ];

  
            $image_src = "https://" . request()->getHost() . "/image/demo_image.jpg";

            if (!$latest_about_data) {
                $latest_about_data_list = [
                    'id' => 0,
                    'description' => "<p><img alt=\"\" src=\"$image_src\" style=\"height:60%; width:100%\" /></p><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc,</p>",
                    'title' => 'Sample History',
                    'aboutus_show_status' => true,
                ];
                
            }

            $data=[
                'about_us'=>$latest_about_data_list,
                'mode'=>'success',
                'status'=>'200',
            ];


        return response()->json($data, 200);

        }catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);

        }

    }


    public function getNoticeListWithPagination(Request $request)
    {
      
        try {
            $site_id=$this->getSiteId($request);

           // Session::put('SITE_ID', $site_id);
           // $site_id = Session::get('SITE_ID');

            $status = $request->status;
            $search_txt = $request->search_txt;
            $date_range = $request->date_range ? json_decode($request->date_range) : null;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';

            if (!$date_range) {
                throw new Error('Please select Date');
            }


            $date_start = $date_range->start??null;//.' 00:00:00';
            $date_end = $date_range->end ??null;

            $noticeList = (new Notice())
                ->where('status', true)
                ->where('type', 'notice')
                ->whereNotNull('web_publish_time')
                ->where('web_publish_time', '<=', Carbon::now())
                ->when(!empty($date_start), function ($query) use ($date_start) {
                    return $query->whereDate('created_at', '>=', $date_start);
                })
                ->when(!empty($date_end), function ($query) use ($date_end) {
                    return $query->whereDate('created_at', '<=', $date_end);
                })
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('doc_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('notice_name', $txt);
                    });
                })->with('files')
                ->orderBy('pin_status', 'DESC')
                ->orderBy('web_publish_time', 'DESC')
                ->orderBy('id', 'DESC')
                ->paginate($paginate);
            //  ->toSql();

            return $noticeList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

   

    public function visitorCount(Request $request){

        try{

        $site_id=$this->getSiteId($request);

        $clientIP = request()->ip();
        $today_find = Carbon::now();
        $today = $today_find->format('Y-m-d');

        $visitor = new SiteWebSiteVisitorDetail();

        $check_today_visitor = $visitor->where('ip_address', $clientIP)
            ->where('site_id', $site_id)
            ->where('visite_date', $today)
            ->first();

        if (!$check_today_visitor) {
            $visitor->ip_address = $clientIP;
            $visitor->site_id = $site_id;
            $visitor->visite_date = $today;
            $visitor->save();
        }


        $today_visitor = $visitor->where('site_id', $site_id)
            ->where('visite_date', $today)
            ->count();

        $total_visitor = $visitor->where('site_id', $site_id)
            ->count();


        $week_first_day = $today_find->subDays($today_find->dayOfWeek + 1);

        $weekly_visitor = $visitor->where('site_id', $site_id)
            ->where('visite_date', '<=', $today)
            ->where('visite_date', '>=', $week_first_day)
            ->count();


        $month_start_date = new Carbon('first day of this month');
        $month_start_day = $month_start_date->format('Y-m-d');

        $monthly_visitor = $visitor->where('site_id', $site_id)
            ->where('visite_date', '<=', $today)
            ->where('visite_date', '>=', $month_start_day)
            ->count();


        $visitor_count=[
            'today_visitor'=>$today_visitor,
            'weekly_visitor'=>$weekly_visitor,
            'monthly_visitor'=>$monthly_visitor,
            'total_visitor'=>$total_visitor,
        ];

        $data=[
            'visitor_count_list'=>$visitor_count,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);
    
    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);

    }
   


    }




    public function getMonthWiseCalendarList(Request $request)
    {
        try{
            if(!$request->academic_group_id){
                return response()->json(['message'=>'Academic Group ID Mission','status'=>'422'],422);
            }
           
        $site_id=$this->getSiteId($request);
        $academic_group_id=$request->academic_group_id;
       // dd($academic_group_id);

       // Session::put('ACADEMIC_GROUP_ID', $request->academic_group_id);
        $monthIncrement = $request->monthIncrement;
       
        $eventModel = new GlobarCalenderEvent();


        $dateComponents = getdate(mktime(null, null, null, date('m') + $monthIncrement, 1, date('Y')));

        $month = $dateComponents['mon'];
        $year = $dateComponents['year'];
        $daysOfWeek = array('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
        //  $daysOfWeek = array('Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');

        // What is the first day of the month in question?
        $firstDayOfMonth = mktime(0, 0, 0, $month, 1, $year);

        // How many days does this month contain?
        $numberDays = date('t', $firstDayOfMonth);


        // Retrieve some information about the first day of the
        // month in question.
        $dateComponents = getdate($firstDayOfMonth);

        // What is the name of the month in question?
        $monthName = $dateComponents['month'];
        $dayOfWeek = $dateComponents['wday'];
        $currentDay = 1;

     //   dd($dayOfWeek);

//      =====================empty column check=====================

        $totalNumberDays = $numberDays + $dayOfWeek;
//        return $totalNumberDays;

        $dateColumnsNumbers = $totalNumberDays / 7;


        if (is_float($dateColumnsNumbers)) {

            $roundNumber = round($dateColumnsNumbers);
            $multipliedNumber = $roundNumber * 7;

            if ($multipliedNumber < $totalNumberDays) {

                $increseased_number = $roundNumber + 1;
                $undateColumnsNumbers = $increseased_number * 7 - $totalNumberDays;

            } else if ($multipliedNumber > $totalNumberDays) {

                $undateColumnsNumbers = $multipliedNumber - $totalNumberDays;
            }

        } else {
            $undateColumnsNumbers = 0;
        }

        

//      ========================empty column check end===========================

        $arrayData = array();
        // for ($b = 1; $b <= $dayOfWeek; $b++) {
        //     $arrayData[] = "";

        // }

    


            $keys=0;
        for ($i = 1; $i <= $numberDays; $i++) {

            $currentDayRel = str_pad($i, 2, "0", STR_PAD_LEFT);
            $date = $year . '-' . $month . '-' . $currentDayRel;

            $datas = GlobarCalenderEvent::where('activate_date', $date)
                ->where('site_id', $site_id)
                ->where('academic_group_id', $academic_group_id)
                ->with('academicCalendarHead')
                ->select('activate_date','start_date','end_date','title','description','academic_calendar_head_id','subhead_color_id',
                'day_name','event_type','academic_group_id','site_id')
                ->get();
            if(count($datas)){
                $arrayData[$keys++]=$datas;
            }
                
        }


        $ac_calendar_head = AcademicCalendarHead::get();

        $calendar_data=[
            // 'month_increment'=>$monthIncrement,
            // 'year'=>$year,
            // 'month'=>$month,
            // 'month_name'=>$monthName,
            // 'number_days'=>$numberDays,
            // 'days_of_week'=>$daysOfWeek,
            // 'day_of_week'=>$dayOfWeek,
            //'event_model'=>$eventModel,
            'event_date_list'=>$arrayData,
          //  'undate_columns_numbers'=>$undateColumnsNumbers,
            'ac_calendar_head'=>$ac_calendar_head,
        ];
        $data=[
            'month_wise_calendar_data'=>$calendar_data,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    
        }
    }



    public function getAcademicGroupList(Request $request)
    {
        try{
            $site_id = $this->getSiteId($request);

            $academic_group_id = SiteInfoSetting::where('site_id', $site_id)->pluck('academic_group_id');
            $acc_group_list = AcademicGroup::whereIn('id', $academic_group_id)->get();
            $data=[
                'academic_group_list'=>$acc_group_list,
                'mode'=>'success',
                'status'=>'200',
            ];


         return response()->json($data, 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);

        }
    }


    public function getYearlyCalendarList(Request $request)
    {
        try{
            if(!$request->academic_group_id ){
                return response()->json(['message'=>'Paramiter Missing','status'=>'422'],422);
            }
            
        $site_id=$request->site_id;
        $academic_group_id=$request->academic_group_id;
        Session::put('SITE_ID', $request->site_id);
      //  Session::put('ACADEMIC_GROUP_ID', $request->academic_group_id);
        $academic_year = $request->academic_year ?? null;

        $daysOfMonth = array('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31');
        $ac_calendar_head = AcademicCalendarHead::get();
        if ($academic_year == null) {
            $dateComponents = getdate();
            $year = $dateComponents['year'];
            $yr = $year;
            $year_arr = [];
            for ($i = 1; $i <= 10; $i++) {
                $year_arr[] = $yr;
                $yr -= 1;
            }
        } else {
            $year = $academic_year;

            $dateComponents = getdate();
            $yer = $dateComponents['year'];
            $yr = $yer;
            $year_arr = [];
            for ($i = 1; $i <= 10; $i++) {
                $year_arr[] = $yr;
                $yr -= 1;
            }
        }


        $data = [];

        for ($m = 1; $m <= 12; ++$m) {
            $month_name = date('F', mktime(0, 0, 0, $m, 1));//mktime(hour,minute,second,month,day,year,is_dst)

            if ($month_name == 'January') {
                $data[0][] = 'Jan';

                $nmonth_id = date('m', strtotime('January'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));

                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = GlobarCalenderEvent::where('activate_date', $date)
                        ->where('site_id', $site_id)
                        ->where('academic_group_id', $academic_group_id)
                        ->with('academicCalendarHead')
                        ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[0][1] = $day_name;

            } else if ($month_name == 'February') {
                $data[1][] = 'Feb';

                $nmonth_id = date('m', strtotime('February'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 1;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = GlobarCalenderEvent::where('activate_date', $date)
                        ->where('site_id', $site_id)
                        ->where('academic_group_id', $academic_group_id)
                        ->with('academicCalendarHead')
                        ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[1][1] = $day_name;


            } else if ($month_name == 'March') {
//                $data[] = 'Mar';
                $data[2][] = 'Mar';

                $nmonth_id = date('m', strtotime('March'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = GlobarCalenderEvent::where('activate_date', $date)
                        ->where('site_id', $site_id)
                        ->where('academic_group_id', $academic_group_id)
                        ->with('academicCalendarHead')
                        ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[2][1] = $day_name;

            } else if ($month_name == 'April') {
//                $data[] = 'Apr';

                $data[3][] = 'Apr';

                $nmonth_id = date('m', strtotime('Apr'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = GlobarCalenderEvent::where('activate_date', $date)
                        ->where('site_id', $site_id)
                        ->where('academic_group_id', $academic_group_id)
                        ->with('academicCalendarHead')
                        ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[3][1] = $day_name;

            } else if ($month_name == 'May') {
//                $data[] = 'May';

                $data[4][] = 'May';

                $nmonth_id = date('m', strtotime('May'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                     $event = GlobarCalenderEvent::where('activate_date', $date)
                        ->where('site_id', $site_id)
                        ->where('academic_group_id', $academic_group_id)
                        ->with('academicCalendarHead')
                        ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[4][1] = $day_name;

            } else if ($month_name == 'June') {
//                $data[] = 'Jun';

                $data[5][] = 'Jun';

                $nmonth_id = date('m', strtotime('Jun'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                     $event = GlobarCalenderEvent::where('activate_date', $date)
                        ->where('site_id', $site_id)
                        ->where('academic_group_id', $academic_group_id)
                        ->with('academicCalendarHead')
                        ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[5][1] = $day_name;

            } else if ($month_name == 'July') {
//                $data[] = 'Jul';

                $data[6][] = 'Jul';

                $nmonth_id = date('m', strtotime('Jul'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                $event = GlobarCalenderEvent::where('activate_date', $date)
                    ->where('site_id', $site_id)
                    ->where('academic_group_id', $academic_group_id)
                    ->with('academicCalendarHead')
                    ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[6][1] = $day_name;

            } else if ($month_name == 'August') {
//                $data[] = 'Aug';

                $data[7][] = 'Aug';

                $nmonth_id = date('m', strtotime('Aug'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = GlobarCalenderEvent::where('activate_date', $date)
                        ->where('site_id', $site_id)
                        ->where('academic_group_id', $academic_group_id)
                        ->with('academicCalendarHead')
                        ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

//                        return $day_name;
                        $i += 1;
                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[7][1] = $day_name;

            } else if ($month_name == 'September') {
//                $data[] = 'Sep';

                $data[8][] = 'Sep';

                $nmonth_id = date('m', strtotime('Sep'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = GlobarCalenderEvent::where('activate_date', $date)
                        ->where('site_id', $site_id)
                        ->where('academic_group_id', $academic_group_id)
                        ->with('academicCalendarHead')
                        ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[8][1] = $day_name;

            } else if ($month_name == 'October') {
//                $data[] = 'Oct';

                $data[9][] = 'Oct';

                $nmonth_id = date('m', strtotime('Oct'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = GlobarCalenderEvent::where('activate_date', $date)
                    ->where('site_id', $site_id)
                    ->where('academic_group_id', $academic_group_id)
                    ->with('academicCalendarHead')
                    ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[9][1] = $day_name;

            } else if ($month_name == 'November') {
//                $data[] = 'Nov';

                $data[10][] = 'Nov';

                $nmonth_id = date('m', strtotime('Nov'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = GlobarCalenderEvent::where('activate_date', $date)
                    ->where('site_id', $site_id)
                    ->where('academic_group_id', $academic_group_id)
                    ->with('academicCalendarHead')
                    ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[10][1] = $day_name;

            } else if ($month_name == 'December') {
//                $data[] = 'Dec';

                $data[11][] = 'Dec';

                $nmonth_id = date('m', strtotime('Dec'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = GlobarCalenderEvent::where('activate_date', $date)
                    ->where('site_id', $site_id)
                    ->where('academic_group_id', $academic_group_id)
                    ->with('academicCalendarHead')
                    ->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

//                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;

                    } else {
//                        $event_details = "";
                        $day_name[$i][1] = [];
                        $day_name[$i][2] = [];
                        $day_name[$i][3] = [];
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = [];
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[11][1] = $day_name;

            }
        }

        $calendar_data=[
            'daysOfMonth'=>$daysOfMonth,
            'ac_calendar_head'=>$ac_calendar_head,
            'data'=>$data,
            'year'=>$year,
            'year_arr'=>$year_arr,
        ];
        $data=[
            'year_wise_calendar_data'=>$calendar_data,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }

    
    public function getEventListWithPagination(Request $request)
    {


        try {
          $paginate =  $request->paginate??8;

            Session::put('SITE_ID', $request->site_id);
    
           
                $gallery_list = Event::where('status', 1)
                    ->where('type', 'event')
                    ->with('files')
                    ->orderBy('id', 'ASC')
                    ->paginate($paginate);
    
                if (count($gallery_list) < 1) {
                    for ($i = 1; $i <= 8; $i++) {
                        $data['data'][$i] = [
                            'id' => 0,
                            'files' => [[
                                'id' => 0,
                                'path' => '/image/demo_image.jpg'
                            ]]
                        ];
    
                    }
                    $gallery_list = $data;
                }

    
                $data=[
                    'gallery_list'=>$gallery_list,
                    'mode'=>'success',
                    'status'=>'200',
                ];
        
                return response()->json($data,200);
    
    
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }

 

  


}
