<?php

namespace App\Http\Controllers\Assessment\ResultSetting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAssessmentCombineResultType;
use App\Models\Academic\AcademicAssessmentPrimaryResultType;
use App\Models\Academic\AcademicAssessmentScale;
use App\Models\Academic\AcademicClass;
use App\Models\Assessment\Assessment;
use App\Models\Assessment\AssessmentResultScaleSystemSetting;
use App\Models\AssessmentResult\AssessmentCombineResultSetting;
use App\Models\AssessmentResult\AssessmentResultPrimarySetting;
use App\Models\Site\Assessment\SiteAssessmentDeclare;
use App\Models\Site\Assessment\SiteAssessmentTypeAndTypeNoSetting;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentResultDetail;
use App\Models\Site\AssessmentResult\SiteAssessmentCombineResultSetting;
use App\Models\Site\AssessmentResult\SiteAssessmentResultPrimarySetting;
use App\Models\Site\AssessmentResult\SiteAssessmentResultScaleSystemSetting;

use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use Response;
use Session;

class AssessmentResultSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
    }

    public function index()
    {
        $viewType = 'Assessment Expertise List';
       
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getAssessmentResultSettingList(Request $request){

        $data = $request->all();

    
        $academic_primary_result_type=AcademicAssessmentPrimaryResultType::where('status', true)->get();

        $academic_combine_result_type=AcademicAssessmentCombineResultType::where('status', true)->get();

        $ssessmentList=Assessment::get();


        $resultSettingList = AssessmentResultPrimarySetting::where('status', true)->get();

        $combineResultSettingList = AssessmentCombineResultSetting::where('status', true)->get();


        $assessment_arr=Array();
        $assessment_array=[];

        foreach ($academic_primary_result_type as $key => $value) {

            $siteAssessmentList_arr=Array();
            $siteAssessmentList_array=[];
            foreach ($ssessmentList as $k => $v) {

             //   dd($v);


                $checkResultSetting=$resultSettingList
                ->where('academic_assessment_result_primary_type_id', $value['id'])
                    ->where('assessment_id', $v->id)
                    ->first();
                //    dd($checkResultSetting);

                if($checkResultSetting){
                    $siteAssessmentList_arr['select_assessment_id']=true;
                    $siteAssessmentList_arr['show_position']=$checkResultSetting->show_position;
                }
                else{
                    $siteAssessmentList_arr['select_assessment_id']=false;
                    $siteAssessmentList_arr['show_position']=null;
                }




                $siteAssessmentList_array[$k]=array_merge($siteAssessmentList_arr, $v->toArray());
            }

            $assessment_arr['assessment_list']=$siteAssessmentList_array;


            $checkPrimayTypeid=$resultSettingList->where('academic_assessment_result_primary_type_id', $value['id'])
                ->first();
            if($checkPrimayTypeid){
                $assessment_arr['select_primary_result_type']=true;
            }else{
                $assessment_arr['select_primary_result_type']=false;
            }



            $assessment_array[$key]=array_merge($assessment_arr, $value->toArray());
        }

       // return $assessment_array;





        $result_type_arr=Array();
        $result_type_array=[];

        foreach ($academic_combine_result_type as $key => $value) {

            $academic_primary_result_type_arr=Array();
            $academic_primary_result_type_array=[];
            foreach ($academic_primary_result_type as $k => $v) {


                $checkComResultSetting=$combineResultSettingList->where('academic_assessment_result_combine_type_id', $value['id'])
                    ->where('academic_assessment_result_primary_type_id', $v['id'])
                    ->first();


                if($checkComResultSetting){
                    $academic_primary_result_type_arr['select_primary_assessment_result_type_id']=true;
                    $academic_primary_result_type_arr['show_position']=$checkComResultSetting->show_position;
                }
                else{
                    $academic_primary_result_type_arr['select_primary_assessment_result_type_id']=false;
                    $academic_primary_result_type_arr['show_position']=null;
                }


                $academic_primary_result_type_array[$k]=array_merge($academic_primary_result_type_arr, $v->toArray());
            }

            $result_type_arr['result_type_list']=$academic_primary_result_type_array;



            $checkCombineTypeid=$combineResultSettingList->where('academic_assessment_result_combine_type_id', $value['id'])
                ->first();
            if($checkCombineTypeid){
                $result_type_arr['select_result_type']=true;
            }else{
                $result_type_arr['select_result_type']=false;
            }



            $result_type_array[$key]=array_merge($result_type_arr, $value->toArray());
        }


        return [$assessment_array, $result_type_array];


    }

    
    public function createUpdateAssessmentResultSetting(Request $request){

        $data = $request->all();

        $resultSettingList = AssessmentResultPrimarySetting::where('status', true)->get();

        $charges=[];
        $checkPrimayResultSettingId=[];
            foreach ($request->ResultTypeList as $key => $value) {
                if($value['select_primary_result_type']){

                    foreach ($value['assessment_list'] as $k => $v) {
                        if($v['select_assessment_id']){

                            if(count($resultSettingList)>0){

                                $checkResultSetting=$resultSettingList->where('academic_assessment_result_primary_type_id', $value['id'])
                                    ->where('assessment_id', $v['id'])
                                    ->first();
                                if($checkResultSetting){

                                    $checkPrimayResultSettingId[]=$checkResultSetting->id;

                                    $checkResultPercent=$resultSettingList->where('academic_assessment_result_primary_type_id', $value['id'])
                                        ->where('assessment_id', $v['id'])
                                        ->first();


                                    if(!$checkResultPercent){

                                        $checkResultSetting->update(['status'=>false]);
                                        $charges[] = [
                                            'academic_assessment_result_primary_type_id'=>$value['id'],
                                            'assessment_id'=>$v['id'],
                                            'status'=>true,
                                        ];
                                    }

                                }else{

                                    $charges[] = [
                                        'academic_assessment_result_primary_type_id'=>$value['id'],
                                        'assessment_id'=>$v['id'],
                                        'status'=>true
                                    ];

                                }
                            }
                            else{
                                $charges[] = [
                                    'academic_assessment_result_primary_type_id'=>$value['id'],
                                    'assessment_id'=>$v['id'],
                                    'status'=>true
                                ];
                            }
                        }
                    }
                }
            }


            if(count($resultSettingList)>0){
                $resultId=$resultSettingList->pluck('id');
                $resultIdDiff=array_diff($resultId->toArray(), $checkPrimayResultSettingId);
                AssessmentResultPrimarySetting::whereIn('id', $resultIdDiff)->delete();
            }

            if(count($charges)>0){
                AssessmentResultPrimarySetting::insert($charges);
            }

        $combineResultSettingList = AssessmentCombineResultSetting::where('status', true)->get();

        $chargest=[];
        $checkCombineResultSettingId=[];
        foreach ($request->CombineResultTypeList as $key => $value) {
            if($value['select_result_type']){


                foreach ($value['result_type_list'] as $k => $v) {
                    if($v['select_primary_assessment_result_type_id']){

                        if(count($combineResultSettingList)>0){

                            $checkComResultSetting=$combineResultSettingList->where('academic_assessment_result_combine_type_id', $value['id'])
                                ->where('academic_assessment_result_primary_type_id', $v['id'])
                                ->first();
                            if($checkComResultSetting){

                                $checkCombineResultSettingId[]=$checkComResultSetting->id;

                                $checkComResultPercent=$combineResultSettingList->where('academic_assessment_result_combine_type_id', $value['id'])
                                    ->where('academic_assessment_result_primary_type_id', $v['id'])
                                    ->where('show_position', $v['show_position'])
                                    ->first();


                                if(!$checkComResultPercent){

                                    $checkComResultSetting->update(['status'=>false]);
                                    $chargest[] = [
                                        'academic_assessment_result_combine_type_id'=>$value['id'],
                                        'academic_assessment_result_primary_type_id'=>$v['id'],
                                        'show_position'=>$v['show_position'],
                                        'status'=>true,
                                    ];

                                }

                            }else{

                                $chargest[] = [
                                    'academic_assessment_result_combine_type_id'=>$value['id'],
                                    'academic_assessment_result_primary_type_id'=>$v['id'],
                                    'show_position'=>$v['show_position'],
                                    'status'=>true,
                                ];

                            }
                        }
                        else{
                            $chargest[] = [
                                'academic_assessment_result_combine_type_id'=>$value['id'],
                                'academic_assessment_result_primary_type_id'=>$v['id'],
                                'show_position'=>$v['show_position'],
                                'status'=>true,
                            ];
                        }

                    }
                }
            }
        }


        if(count($resultSettingList)>0){
            $resultId=$resultSettingList->pluck('id');
            $resultIdDiff=array_diff($resultId->toArray(), $checkPrimayResultSettingId);
            AssessmentCombineResultSetting::whereIn('id', $resultIdDiff)->delete();
        }

        if(count($chargest)>0){
            AssessmentCombineResultSetting::insert($chargest);
        }


        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);


    }


    
    public function getAssessmentResultScaleList(Request $request){

        $data = $request->all();
       
        $academic_result_system=AcademicAssessmentScale::where('status', 1)->orderBy('serial','ASC')->get();
     
        $siteResultSystemSettingPresent=AssessmentResultScaleSystemSetting::where('status',true)->get();

        $class_list_arr=Array();

            $result_system_arr=Array();
            $result_system_array=[];
            foreach ($academic_result_system as $k => $v) {

                if(count($siteResultSystemSettingPresent)>0){
                    $check= $siteResultSystemSettingPresent->where('academic_assessment_scale_id',$v['id'])->first();
                   // dd($check);

                    if($check){
                        $result_system_arr['select_result_system']=true;
                        $result_system_arr['level_from']=$check->level_from;
                        $result_system_arr['level_to']=$check->level_to;
                        $result_system_arr['graph_level']=$check->graph_level;
                        $result_system_arr['pass_fail_status']=$check->pass_fail_status?'pass':'fail';
                    }
                    else{
                        $result_system_arr['select_result_system']=false;
                        $result_system_arr['level_from']=null;
                        $result_system_arr['level_to']=null;
                        $result_system_arr['graph_level']=null;
                        $result_system_arr['pass_fail_status']=null;
                    }
                }
                else{
                    $result_system_arr['select_result_system']=false;
                    $result_system_arr['level_from']=null;
                    $result_system_arr['level_to']=null;
                    $result_system_arr['graph_level']=null;
                    $result_system_arr['pass_fail_status']=null;
                }

                $result_system_array[$k]=array_merge($v->toArray(), $result_system_arr);
            }



            if(count($siteResultSystemSettingPresent)>0) {
                $checks = $siteResultSystemSettingPresent->first();

                if($checks){
                    $class_list_arr['select_class']=true;
                }else{
                    $class_list_arr['select_class']=false;
                }
            }else{
                $class_list_arr['select_class']=false;
            }


            return $result_system_array;
        
    }


    



    public function createUpdateAssessmentResultScale(Request $request){

        $data = $request->all();
        //dd($data);

        $siteResultSystemSettingPresent=AssessmentResultScaleSystemSetting::get();


        $present_ids=[];
        if(count($siteResultSystemSettingPresent)>0){
            $present_ids=$siteResultSystemSettingPresent->pluck('id');
        }


        $charges=[];
        $check_ids=[];

                foreach ($request->ResultScalSettingList as $k => $v) {

                    if($v['select_result_system']){

                        if(count($siteResultSystemSettingPresent)>0){

                          $check= $siteResultSystemSettingPresent->where('academic_assessment_scale_id',$v['id'])->first();

                            if($check){

                                $check_ids[]=$check->id;

                                $check->update([
                                    'academic_assessment_scale_id'=>$v['id'],
                                    'level_from'=>$v['level_from'],
                                    'level_to'=>$v['level_to'],
                                    'graph_level'=>$v['graph_level'],
                                    'pass_fail_status'=>$v['pass_fail_status']=='pass'?true:false,
                                    'status'=>true,
                                ]);



                            }
                            else{
                                $charges[] = [
                                    'academic_assessment_scale_id'=>$v['id'],
                                    'level_from'=>$v['level_from'],
                                    'level_to'=>$v['level_to'],
                                    'graph_level'=>$v['graph_level'],
                                    'pass_fail_status'=>$v['pass_fail_status']=='pass'?true:false,
                                    'status'=>true,
                                ];

                            }


                        }
                        else{
                            $charges[] = [
                                'academic_assessment_scale_id'=>$v['id'],
                                'level_from'=>$v['level_from'],
                                'level_to'=>$v['level_to'],
                                'graph_level'=>$v['graph_level'],
                                'pass_fail_status'=>$v['pass_fail_status']=='pass'?true:false,
                                'status'=>true,
                            ];

                        }

                    }

                }




            




        if(count($charges)>0){
            AssessmentResultScaleSystemSetting::insert($charges);
        }


        if(count($present_ids)>0){
            $resultSystemAbsentCheck=array_diff($present_ids->toArray(), $check_ids);

            AssessmentResultScaleSystemSetting::whereIn('id', $resultSystemAbsentCheck)->delete();
        }

        




        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);


    }








}
