<?php

namespace App\Http\Controllers\Assessment\Setting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassWiseSubject;
use App\Models\Academic\AcademicSubject;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Assessment\Assessment;
use App\Models\Assessment\AssessmentExpertise;
use App\Models\Assessment\AssessmentExpertiseWiseTopic;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;
use App\Models\Assessment\ExpertiseAssessmentTypeAndTypeNoSetting;
use App\Models\Site\Assessment\SiteAssessmentTypeAndTypeNoSetting;
use Session;
use Response;

class AcademicAssessmentAndTypeNoSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    //    $this->middleware('eduworlduserchecker');
    }

    public function index()
    {
        $viewType = 'Assessment Type List';
       
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getYearClassAndAssessmentList(){
        
        $topicExpertise=AssessmentExpertiseWiseTopic::where('status',true)->get();
      
        // $topic_expertise_ids=$topicExpertise->pluck('expertise_id')
        //         ->unique()
        //         ->filter();

        // $assessmentExpertise=AssessmentExpertise::whereIn('id',$topic_expertise_ids)
        //         ->where('status',true)
        //         ->get();

        // $expertise_ids=$assessmentExpertise->pluck('id')
        //             ->unique()
        //             ->filter();

        $academic_class_ids=$topicExpertise->pluck('academic_class_id')
                    ->unique()
                    ->filter();
        $academic_class_list=AcademicClass::whereIn('id',$academic_class_ids)->get();


        $academic_year_list=AcademicYear::where('status',true)->orderBy('serial_no','DESC')->get();
        $assessment_list=Assessment::get();
        $assessment_type_list=AssessmentType::get();

        return [$academic_class_list,$academic_year_list,$assessment_list,$assessment_type_list];

    }

    public function getSubjectAssessmentExpertiseAndTypeSetup(Request $request){
       
        $data = $request->all();

    
            $assessment_type_no_list=AssessmentTypeNo::where('assessment_type_id', $request->assessment_type_id)
                    
                    ->when($request->assessment_type_id=='1', function($q) use ($request){
                        return $q->where('academic_class_id', $request->academic_class_id);
                    })
                    ->orderBy('serial')
                   // ->pluck('type_no');
                    ->get();

                   // dd($assessment_type_no_list);
        $subject_id_array=[
            '0'=>1,
            '1'=>2,
            '2'=>3,
            '3'=>8,
            '4'=>9,
            '5'=>10,
            '6'=>11,
            '7'=>48,
            '8'=>282,
            '9'=>278,
            '10'=>279,
            '11'=>280,
            '12'=>281,
        ];
            $academic_subject_ids = AcademicClassWiseSubject::where('academic_class_id',$request->academic_class_id)
                ->whereIn('academic_subject_id',$subject_id_array)
                ->pluck('academic_subject_id')
                ->filter()

                ->unique();
          //  $subject_id_array=['0'=>1,'1'=>2,'2'=>3,'3'=>8,'4'=>9,'5'=>10];

            $academic_subject=AcademicSubject::whereIn('id',$academic_subject_ids)->get();

            $subject_list=[];
            $key=0;
            foreach($academic_subject as $subject){

              
                $assessmentExpertiseTopics=AssessmentExpertiseWiseTopic::where('assessment_type_id',$request->assessment_type_id)
                        ->when($data['assessment_type_id']==1,function($q) use ($subject){
                            $q->where('academic_subject_id',$subject->id);
                        })
                        ->when($data['assessment_type_id']==1,function($q) use ($data){
                            $q->where('academic_class_id',$data['academic_class_id']);
                        })
                        // ->where('academic_subject_id',$subject->id)
                        // ->where('academic_class_id',$request->academic_class_id)
                        ->orderBy('expertise_id')
                        ->orderBy('serial')
                        ->get();
                   //     dd($assessmentExpertiseTopics);

                $expertise_ids=$assessmentExpertiseTopics->pluck('expertise_id')
                    ->unique()
                    ->filter();
                $assessmentExpertise=AssessmentExpertise::where('assessment_type_id',$request->assessment_type_id)
                    ->whereIn('id',$expertise_ids)
                    ->get();
                  
                // $expertise_ids=$assessmentExpertise->pluck('id')
                //     ->unique()
                //     ->filter();

                $subjectAssessmentSettings=ExpertiseAssessmentTypeAndTypeNoSetting::
                    where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->where('assessment_id',$data['assessment_id'])
                    ->whereIn('expertise_id',$expertise_ids)
                    ->where('assessment_type_id',$data['assessment_type_id'])
                    ->where('academic_subject_id',$subject->id)
                    ->get();
                
                $expertise_list=[];
                if(count($assessmentExpertise)){
                foreach($assessmentExpertise as $e_key=>$expertise){

                $expertise_list[$e_key]['id']=$expertise->id;
                $expertise_list[$e_key]['expertise_name']=$expertise->name;
                $expertise_list[$e_key]['expertise_english_name']=$expertise->english_name;
                  
                $assessment_topics=$assessmentExpertiseTopics->where('expertise_id',$expertise->id);
                 
              //  dd($assessment_topics);
                    $topic_list=[];
                    $keys=0;
                    if(count($assessment_topics)){
                        foreach($assessment_topics as $topic){
                           
                            $checkTopic=$subjectAssessmentSettings->where('topic_id',$topic->id);
                           // dd($checkTopic);
                            if(count($checkTopic)){
                                $topic_list[$keys]['topic_select_status']=true;
                            }else{
                                $topic_list[$keys]['topic_select_status']=false;
                            }

                            $type_no_list=[];
                            $keyss=0;
                            foreach($assessment_type_no_list as $type_item){
                                $checkTypeNo=$checkTopic->where('assessment_type_no_id',$type_item->id);

                                if(count($checkTypeNo)){
                                    $type_no_list[$keyss]['type_no_select_status']=true;
                                }else{
                                    $type_no_list[$keyss]['type_no_select_status']=false;
                                }
                                $type_no_list[$keyss]['id']=$type_item->id;
                                $type_no_list[$keyss]['type_no_name']=$type_item->type_no;
                                $keyss++;
                            }

                            $topic_list[$keys]['id']=$topic->id;
                            $topic_list[$keys]['topic_no']=$topic->topic_no;
                            $topic_list[$keys]['topic_name']=$topic->topic_name;
                            $topic_list[$keys]['type_no_list']=$type_no_list;
                            $keys++;
                        }
                    }else{

                        $type_no_list=[];
                            $keyss=0;
                            foreach($assessment_type_no_list as $type_item){
                                $type_no_list[$keyss]['type_no_select_status']=false;
                                $type_no_list[$keyss]['id']=null;
                                $type_no_list[$keyss]['type_no_name']=null;
                                $keyss++;
                            }
                            $topic_list[$keys]['topic_select_status']=null;
                            $topic_list[$keys]['id']=null;
                            $topic_list[$keys]['topic_name']=null;
                            $topic_list[$keys]['type_no_list']=null;

                    }
                    $expertise_list[$e_key]['topic_list']= $topic_list;

                }
            }
            
                    
                $subject_list[$key]['academic_subject_id']=$subject->id;
                $subject_list[$key]['subject_name']=$subject->subject_name;
                $subject_list[$key]['expertise_list']=$expertise_list;
                $key++;

            }


        return $subject_list;

    }


    
    public function submitSubjectTopicsAssessmentAndTypeNoSetup(Request $request){

        $data = $request->all();

      //  dd($data);

        $subjectTopicAssessmentNo=ExpertiseAssessmentTypeAndTypeNoSetting::
                where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('assessment_id',$data['assessment_id'])
                ->where('assessment_type_id',$data['assessment_type_id'])
                ->get();


            $presentIDArray=$subjectTopicAssessmentNo->pluck('id');

         //   dd($presentIDArray);
            $row_key=0;
            $charges=[];
            $presentID=Array();
            $presentTableIDArray=[];
            foreach ($request->SubjectList as $key => $value) {
               
                    $subjectWiseSettings=collect($subjectTopicAssessmentNo)->where('academic_subject_id',$value['academic_subject_id']);
                  
                    if(count($value['expertise_list'])>0){
                    foreach ($value['expertise_list'] as $e_keys => $e_value) {


                        foreach ($e_value['topic_list'] as $keys => $values) {
                       
                        if($values['topic_select_status']){

                            $subjectTopicWiseSettings=$subjectWiseSettings->where('subject_topic_id',$values['id']);

                            foreach($values['type_no_list'] as $keyss => $valuess){
                                if($valuess['type_no_select_status']){
                                    $checkPresentData=$subjectTopicWiseSettings
                                        ->where('assessment_type_no_id',$valuess['id'])
                                        ->first();
        
                                if($checkPresentData){
        
                                    $presentID[$row_key]=$checkPresentData->id;
                                    
                                    $row_key++;
                                }else{
                                    $charges[] = [
                                        'academic_year_id'=>$data['academic_year_id'],
                                        'academic_class_id'=>$data['academic_class_id'],

                                        'assessment_id'=>$data['assessment_id'],
                                        'assessment_type_id'=>$data['assessment_type_id'],
                                        'academic_subject_id'=>$value['academic_subject_id'],
                                        'expertise_id'=>$e_value['id'],
                                        'topic_id'=>$values['id'],
                                        'assessment_type_no_id'=>$valuess['id'],
                                    ];
                                }
                                }
                            }

                        }

                    }

                    
                    }
                    }
                
                $presentTableIDArray[$key]=array_merge($presentID);


            }


            if(count($charges)>0){
                ExpertiseAssessmentTypeAndTypeNoSetting::insert($charges);
            }

            $collection = collect($presentTableIDArray);
            $assessmentTypeNoSettingArrayCollapsed = ($collection->collapse())->unique();
           
            $assessmentTypeNoSettingAbsentCheck=array_diff($presentIDArray->toArray(), $assessmentTypeNoSettingArrayCollapsed->toArray());
           
            ExpertiseAssessmentTypeAndTypeNoSetting::whereIn('id', $assessmentTypeNoSettingAbsentCheck)->delete();

        
        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
    }



   

}
