<?php

namespace App\Http\Controllers\Company\Branch;

use App\Models\Company\Branch\Branch;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class BranchController extends Controller
{
    private $branch;

    public function __construct(Branch $branch)
    {
        $this->middleware('auth');

        $this->branch = $branch;

    }


    public function index()
    {
        $viewType = 'Branch List';
        return view('default.admin.company.branch.index', compact('viewType'));
    }

    public function create(Request $validatedRequest)
    {

        $this->validate($validatedRequest, [
            'name' => 'required',
            'address' => 'required'
        ]);


        $this->branch = new Branch();

        if (count($this->branch->ownFields) > 0) {
            foreach ($this->branch->ownFields as $ownField) {
                if ($validatedRequest->{$ownField}) {
                    $this->branch->{$ownField} = $validatedRequest->{$ownField};
                }
            }
        }

        if ($this->branch->save()) {
            return Response::json(['message' => 'Saved Successfully!', 'mode' => 'Saved!'], 200);

        }
    }

    public function update(Request $validatedRequest, $id)
    {

        $this->validate($validatedRequest, [
            'name' => 'required',
            'address' => 'required'
        ]);

        $toEdit = $this->branch->findOrFail($id);
        $toEdit->br_code = $validatedRequest->br_code;

        if (count($toEdit->ownFields) > 0) {
            foreach ($toEdit->ownFields as $ownField) {
                if ($validatedRequest->{$ownField}) {
                    $toEdit->{$ownField} = $validatedRequest->{$ownField};
                }
            }
        }

        if ($toEdit->save()) {
            return Response::json(['message' => 'Updated Successfully', 'mode' => 'Updated!'], 200);
        }
    }


    //Api================================Api======

    public function getBranchList()
    {
        $list = $this->branch->with(['manager'=> function ($q) {
            $q->with(['companyRoles'=> function ($qq) {
                $qq->where('key', 'b_manager');
            }]);
        }])->get();
        return response()->json($list, 200, [], JSON_NUMERIC_CHECK);

    }


}
