<?php

namespace App\Http\Controllers\Department;


use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Department\Department;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;


class DepartmentController extends ProjectController
{
    use FormControll;

    private $department;

    public function __construct(Department $department)
    {

        $this->middleware('auth');

        $this->department = $department;
    }

    public function index()
    {
        $viewType = 'Department List';
        $model = $this->department->orderBy('id','DESC')->paginate(10);
        //dd($model);
        return view('default.admin.department.index',compact('viewType','model'));
    }

    public function createDeptForm()
    {
        $viewType = 'Create Department';
        return view('default.admin.department.create',compact('viewType'));
    }


    public function createDepartment(Requests\Validator $validatedRequest)
    {
        //dd($validatedRequest);

         $this->department->create([
            'name'=>ucwords($validatedRequest->get('name')),
            'type'=>ucwords($validatedRequest->get('type')),
            'status'=>ucwords($validatedRequest->get('status')),
            'position'=>1
        ]);



        return redirect()->route('department-list')->withSuccess('Successfully Created');




    }

    public function editDeptForm($id)
    {
        $viewType = 'Edit Department';

        $departmentToEdit =$this->editFormModel($this->department->findOrFail($id)) ;

        return view('default.admin.department.edit',compact('departmentToEdit','viewType'));

    }

    public function editDepartment($id, Requests\Validator $validatedRequest)
    {

        $departmentToEdit = $this->department->findOrFail($id);

        $isEdited =  $departmentToEdit->update([
            'name'=>ucwords($validatedRequest->get('name')),
            'type'=>ucwords($validatedRequest->get('type')),
            'status'=>$validatedRequest->get('status')
        ]);

        if ($isEdited){
            return redirect()->route('department-list')->withSuccess('Successfully Updated');
        }
        return redirect()->route('department-list')->withError('Something Went Wrong!');

    }

    public function viewDepartment($id)
    {
        $viewType='Department';
        $departmentToView = $this->department->findOrFail($id);
        return view('default.admin.department.view',compact('viewType','departmentToView'));


    }

    public function deleteDepartment($id)
    {
        $departmentToDelete = $this->department->findOrFail($id);

        if($departmentToDelete->delete()){

            return back();
        }
        return back()->withErrors('Not successfully deleted');
    }

}
