<?php

namespace App\Http\Controllers\Edu\Accounts\AccountsHead;

use App\Models\Edu\Accounts\AccountsHead;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Pagination\Paginator;
use Carbon\Carbon;
use Error;
use Auth;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Image;
use Response;
use Storage;
use Session;

class AccountsHeadController extends Controller
{
    private $accountsHead;

    public function __construct(AccountsHead $accountsHead)
    {
//        $this->middleware('auth:api');
//        $this->middleware('api.access');
        $this->middleware('eduworlduserchecker');
        $this->middleware('auth');
        $this->accountsHead = $accountsHead;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType ="Accounts Head";
        return view('default.admin.layouts.master',compact('viewType'));
    }

    public function getAccountsHeadListWithPagination(Request $request)
    {
//        return $request;

        $search_accounts_head_id = $request->search_accounts_head_id;
        $paginate = $request->paginate;

        $acc_head_list = AccountsHead::when($search_accounts_head_id, function ($q) use($search_accounts_head_id){
                                            $q->where('id', $search_accounts_head_id);
                                        })->orderBy('id', 'DESC')->paginate($paginate);

        $acc_head_list_for_search = AccountsHead::where('status', 1)->get();

        return [$acc_head_list,$acc_head_list_for_search];

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, AccountsHead $accountsHead)
    {
        //==============validation=============
        if(!$request->name || !$request->key_name || !$request->entry ){
            throw new Error('Please, fill the required fields');
        }
        if (count($accountsHead->ownFields) > 0) {
            foreach ($accountsHead->ownFields as $field) {
                if ($request->{$field}) {
                    $accountsHead->{$field} = $request->{$field};
                }
            }
            $accountsHead->created_by = Auth::user()->id;
            $accountsHead->created_date = Carbon::today();
            $accountsHead->head_key = 'head';
            if($accountsHead->save()){
                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
//        return $request;
        //==============validation=============
        if(!$request->name || !$request->key_name || !$request->entry ){
            throw new Error('Please, fill the required fields');
        }
        $acc_head = AccountsHead::findOrFail($request->id);
        if (count($acc_head->ownFields) > 0) {
            foreach ($acc_head->ownFields as $field) {
                if ($request->{$field}) {
                    $acc_head->{$field} = $request->{$field};
                }
            }
            $acc_head->created_by = Auth::user()->id;
            $acc_head->created_date = Carbon::today();
            $acc_head->status = (int)$request->status;

            if($acc_head->save()){
                return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $acc_head = AccountsHead::findOrFail($id);
        if($acc_head->delete()){
            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Deleted'], 200);
        }
    }
}
