<?php

namespace App\Http\Controllers\Edu\ClassRoom;

use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicSubject;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Edu\ClassRoom\EduClassRoom;
use App\Models\Site\Web\ClassRoom\WebsiteClassRoomLink;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Input;
use App\Models\Image\Photo;
use Carbon\Carbon;
use Error;
use Auth;
use Exception;
use File;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Image;
use Response;
use Storage;
use Session;

class ClassRoomController extends Controller
{
    private $classRoom;
    private $academicSubject;

    public function __construct(EduClassRoom $classRoom, AcademicSubject $academicSubject)
    {
//        $this->middleware('auth:api');
//        $this->middleware('api.access');
        $this->middleware('eduworlduserchecker');
        $this->middleware('auth');
        $this->classRoom = $classRoom;
        $this->academicSubject = $academicSubject;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType ="Class Room";
        return view('default.admin.layouts.master',compact('viewType'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    public function getEduClassRoomList(Request $request)
    {
        $pause_status = $request->pause_status;
        $search_txt = $request->search_txt;
        $academic_gorup_id = $request->academic_gorup_id;
        $academic_department_id = $request->academic_department_id;
        $academic_class_id = $request->academic_class_id;
        $academic_subject_id = $request->academic_subject_id;
        $date_range = $request->date_range ? json_decode($request->date_range) : null;
        $paginate = $request->paginate ?? 20;
        $txt = '%' . $search_txt . '%';

        $date_start = $date_range->start;
        $date_end = $date_range->end ?? $date_start;


        $class_room_list = EduClassRoom::whereDate('publish_date', '>=', $date_start)
            ->whereDate('publish_date', '<=', $date_end)
            ->where('entry_type', 'edu')
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->whereTranslationLike('topic_title', $txt)
                        ->orWhereTranslationLike('topic_description', $txt);

                });
            })
            ->when($pause_status, function ($qr) use($pause_status){
                return $qr->where('pause_status', (int)$pause_status);
            })
            ->when($academic_gorup_id, function ($qrr) use($academic_gorup_id){
                return $qrr->where('academic_gorup_id', (int)$academic_gorup_id);
            })
            ->when($academic_department_id, function ($qrry) use($academic_department_id){
                return $qrry->where('academic_department_id', (int)$academic_department_id);
            })
            ->when($academic_class_id, function ($qq) use($academic_class_id){
                return $qq->where('academic_class_id', $academic_class_id);
            })
            ->when($academic_subject_id, function ($q) use($academic_subject_id){
                return $q->where('academic_subject_id', $academic_subject_id);
            })


            ->with('academicGroup', 'academicClass', 'academicSubject', 'academicDepartment', 'academicYear', 'files', 'user', 'websiteClassRoomLink')
            ->orderBy('id', 'DESC')
            ->get();
        $class_room_list_final = [];
        if(count($class_room_list)){
            foreach ($class_room_list as $k => $v){
                $class_room_list_final[$k]['data'] = $v;
                $publish_to_ids = "";
                if($v->publish_to){
                    $publish_to_ids = explode(',', $v->publish_to);
                }
                $class_room_list_final[$k]['publish_to'] = $publish_to_ids ?? null;
            }
        }

//        $class_room_list_final->paginate($paginate);
        $classRoomListPage = new Paginator($class_room_list_final, $paginate);

        //==============academic group==========================
        $department_list = [];
        $academic_group_ids = EduClassRoom::where('entry_type', 'edu')->pluck('academic_group_id');
        $academic_group_list = AcademicGroup::whereIn('id', $academic_group_ids)->get();

        //==============department==========================
        $department_list = [];
        $department_ids = EduClassRoom::where('entry_type', 'edu')->pluck('academic_department_id');
        $department_list = AcademicDepartment::whereIn('id', $department_ids)->get();

        //==============class==========================
        $class_list = [];
        $class_ids = EduClassRoom::where('entry_type', 'edu')->pluck('academic_class_id');
        $class_list = AcademicClass::whereIn('id', $class_ids)->get();

        //==============department==========================
        $subject_list = [];
        $subject_ids = EduClassRoom::where('entry_type', 'edu')->pluck('academic_subject_id');
        $subject_list = AcademicSubject::whereIn('id', $subject_ids)->get();

        return [$academic_group_list, $department_list, $class_list , $subject_list, $classRoomListPage];
    }

    public function getYearAcademicGroupDepartmentClassSubjectList()
    {
        $year_list = AcademicYear::where('status', 1)->orderBy('id', 'DESC')->get();

        $academic_group_list = AcademicGroup::get();

        $department_list = AcademicDepartment::where('status', 'Active')->get();

        $class_list = AcademicClass::where('status', 1)->get();

        $subject_list = AcademicSubject::get();

        return [$year_list, $academic_group_list, $department_list, $class_list, $subject_list];
    }

    public function createEduClassRoomLesson(Request $request, EduClassRoom $classRoom)
    {


        if(!$request->academic_group_id ||!$request->academic_class_id || !$request->academic_subject_id || !$request->topic_title || !$request->topic_description || !$request->publish_date){
            throw new Error('Please, fill the required fields');
        }


        if (count($classRoom->ownFields) > 0) {
            foreach ($classRoom->ownFields as $field) {
                if ($request->{$field}) {
                    $classRoom->{$field} = $request->{$field};
                }
            }
            $classRoom->entry_type = 'edu';
            $classRoom->entry_date = Carbon::today();
            $classRoom->status = 1;
            $classRoom->approve_status = 1;
            $classRoom->created_by = Auth::user()->id;

            $publish_to_ids_string = implode(',', $request->publish_to);

            $classRoom->publish_to = $publish_to_ids_string;

            $latest_data = EduClassRoom::where('entry_type', 'edu')->orderBy('id', 'DESC')->first();
            if($latest_data){
                $classRoom->serial_no = $latest_data->serial_no + 1;
            }else{
                $classRoom->serial_no = 1;
            }
//            return $classRoom;

            if ($classRoom->save()) {
                $files = range(1, $request->length);
                $file_path = null;

                if ($request->length) {
                    foreach ($files as $k => $val) {
                        $file = Input::file('files' . $k);
                        $file_name = $classRoom->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                        Storage::disk('uploads')->put($file_name, File::get($file));
                        $file_path = '/uploads/files/' . $file_name;
                        $file = Input::file('files' . $k);
                        $file_type = $file->getClientMimeType();

                        if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                            Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                                $constraint->aspectRatio();
                            })->save('uploads/files/' . $file_name);

                        } else {
                            Storage::disk('uploads')->put($file_name, File::get($file));
                        }

                        $classRoom->files()->create([
                            'user_id' => Auth::user()->id,
                            'path' => $file_path,
                            'name' => $file->getClientOriginalName(),
                        ]);
                    }
                }
                $latest_data = EduClassRoom::where('entry_type', 'edu')->orderBy('id', 'DESC')->first();
                if(count($request->siteLinkList)){
                    foreach ($request->siteLinkList as $kk => $vv){
                        if($vv){
                            $classRoomLink = new WebsiteClassRoomLink();

                            $classRoomLink->website_class_room_id = $latest_data->id;
                            $classRoomLink->link_type = 'site';
                            $classRoomLink->link = $vv;
                            $classRoomLink->status = 1;
                            $classRoomLink->save();

                        }
                    }

                }
                if(count($request->videoLinkList)){
                    foreach ($request->videoLinkList as $kkk => $vvv){
                        if($vvv){
                            $classRoomLink = new WebsiteClassRoomLink();

                            $classRoomLink->website_class_room_id = $latest_data->id;
                            $classRoomLink->link_type = 'video';
                            $classRoomLink->link = $vvv;
                            $classRoomLink->status = 1;
                            $classRoomLink->save();

                        }
                    }

                }

                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);

            }

        }
    }

    public function getEduClassRoomLessonDetails($id)
    {
        $class_room_list = EduClassRoom::with('academicGroup','academicClass', 'academicSubject', 'academicDepartment', 'academicYear', 'files', 'user', 'websiteClassRoomLink')
            ->findOrFail($id);
        $publish_to_ids = [];
        if($class_room_list->publish_to){
            $publish_to_ids = explode(',', $class_room_list->publish_to);
        }


        return [$class_room_list, $publish_to_ids];
    }

    public function updateEduClassRoomLesson(Request $request)
    {

        if(!$request->academic_class_id || !$request->academic_class_id || !$request->academic_subject_id || !$request->topic_title || !$request->topic_description || !$request->publish_date){
            throw new Error('Please, fill the required fields');
        }

        $deletes = $request->deletes ? explode(',', $request->deletes) : [];
        $user_id = Auth::user()->id;

        $classRoom = $this->classRoom->findOrFail($request->id);

        if($request->serial_no != $classRoom->serial_no){

            $updateClassRoomSerial = EduClassRoom::where('entry_type', 'edu')->where('serial_no', $request->serial_no)->first();
            if($updateClassRoomSerial){
                $updateClassRoomSerial->update([
                    'serial_no' =>  $classRoom->serial_no,
                ]);
            }

        }

        foreach ($classRoom->ownFields as $k => $ownField) {
            if ($request->{$ownField}) {
                $classRoom->{$ownField} = $request->{$ownField};
            }
        }
        $publish_to_ids_string = implode(',', $request->publish_to);

        $classRoom->publish_to = $publish_to_ids_string;

        if($request->pause_status == 'true'){
            $classRoom->pause_status = $request->pause_status = 1;
        }else{
            $classRoom->pause_status = $request->pause_status = 0;
        }



        if($classRoom->save()){
            $existLink = WebsiteClassRoomLink::where('website_class_room_id', $classRoom->id)->get();
            if(count($existLink)){
                foreach ($existLink as $kk => $vv){
                    $vv->delete();
                }

            }

            if(count($request->siteLinkList)){
                foreach ($request->siteLinkList as $kkk => $vvv){
                    if($vvv){
                        $classRoomLink = new WebsiteClassRoomLink();

                        $classRoomLink->website_class_room_id = $classRoom->id;
                        $classRoomLink->link_type = 'site';
                        $classRoomLink->link = $vvv;
                        $classRoomLink->status = 1;
                        $classRoomLink->save();

                    }
                }

            }
            if(count($request->videoLinkList)){
                foreach ($request->videoLinkList as $kkkk => $vvvv){
                    if($vvvv){
                        $classRoomLink = new WebsiteClassRoomLink();

                        $classRoomLink->website_class_room_id = $classRoom->id;
                        $classRoomLink->link_type = 'video';
                        $classRoomLink->link = $vvvv;
                        $classRoomLink->status = 1;
                        $classRoomLink->save();

                    }
                }

            }
            if ($request->length) {
                $files = range(1, $request->length);
                $file_path = null;
                foreach ($files as $k => $val) {

                    $file = Input::file('files' . $k);
                    $file_type = $file->getClientMimeType();

                    $file_name = $classRoom->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                    $file_path = '/uploads/files/' . $file_name;

                    if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                        Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                            $constraint->aspectRatio();
                        })->save('uploads/files/' . $file_name);

                    } else {
                        Storage::disk('uploads')->put($file_name, File::get($file));
                    }

                    $this->deleteFiles($classRoom);


                    $classRoom->files()->create([
                        'user_id' => Auth::user()->id,
                        'path' => $file_path,
                        'name' => $file->getClientOriginalName(),
                    ]);
                }
            }

            if (count($deletes)) {
                foreach ($deletes as $k => $id) {
                    $the_photo = Photo::where('id', $id)->first();
                    $fssf[$k] = $the_photo;
                    if($the_photo){
                        $image_path = public_path($the_photo->path);
                        if (File::exists($image_path)) {
                            unlink($image_path);
                        }
                    }

                }
            }
            return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
        }

    }

    private function deleteFiles($about)
    {
        foreach ($about->files as $k => $file) {
            $the_photo = Photo::where('id', $file->id)->first();
            $image_path = public_path($the_photo->path);
            if (File::exists($image_path)) {
                unlink($image_path);
            }
            $the_photo->delete();
        }
    }

    public function deleteClassRoom($id)
    {
        try {

            $classRoom = $this->classRoom->findOrFail($id);
            $classRoom->delete();
            $classRoom->deleteTranslations();
            $this->deleteFiles($classRoom);
            $existLink = WebsiteClassRoomLink::where('website_class_room_id', $classRoom->id)->get();
            if(count($existLink)){
                foreach ($existLink as $kk => $vv){
                    $vv->delete();
                }

            }

            return Response::json(['message' => 'Successfully Deleted!'], 200);

        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
