<?php

namespace App\Http\Controllers\Edu\Email;

use App\Mail\Edu\SendMailToInstitute;
use App\Models\Edu\Email\EduWebMailDocument;
use App\Models\Edu\NonSite\AllInstituteList;
use Error;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Mail;
use Response;

class EduEmailManagementController extends Controller
{

    private $eduWebMailDocument;
    public function __construct(EduWebMailDocument $eduWebMailDocument)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->eduWebMailDocument = $eduWebMailDocument;
    }


    public function createUpdateWebmailDocumentList(Request $request)
    {


        if ($request->edu_web_mail_document_id) {

            $get_present_data = $this->eduWebMailDocument->where('id', $request->edu_web_mail_document_id)->first();

            $get_present_data->main_image_path = $request->main_image_path;
            $get_present_data->document_name = $request->document_name;
            $get_present_data->document_desctiption = $request->document_desctiption;
            $get_present_data->aditional_image_path = $request->aditional_image_path;

            $get_present_data->save();
        } else {

            $this->eduWebMailDocument->create([
                'main_image_path' => $request->main_image_path,
                'document_name' => $request->document_name,
                'document_desctiption' => $request->document_desctiption,
                'aditional_image_path' => $request->aditional_image_path,
            ]);
        }

        return response()->json(['message' => 'Successfully Updated'], 200);
    }




    public function getCreatedEmailList(Request $request)
    {


        try {
            $status = $request->status;
            $search_txt = $request->search_txt;
            $date_range = $request->date_range ? json_decode($request->date_range) : null;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';

            if (!$date_range) {
                throw new Error('Please select Date');
            }


            $date_start = $date_range->start; //.' 00:00:00';
            $date_end = $date_range->end ?? $date_start;

            $list = $this->eduWebMailDocument
                ->where('status', $status)
                ->whereDate('created_at', '>=', $date_start)
                ->whereDate('created_at', '<=', $date_end)
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('document_name', 'LIKE', $txt)
                            ->orWhere('document_desctiption', 'LIKE', $txt);
                    });
                })
                ->orderBy('id', 'DESC')
                ->paginate($paginate);

            return response()->json($list, 200);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }



    public function showWebMailDesign(Request $request)
    {

        //        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
        //            'message' => 'Successfully Created Card Report'], 200);

        $mail_detail = $this->eduWebMailDocument->where('id', $request->edu_web_mail_document_id)->first();


        $main_image_path = $mail_detail->main_image_path;
        $document_desctiption = $mail_detail->document_desctiption;
        $aditional_image_path = $mail_detail->aditional_image_path;



        return view('edu.mail.show-non-site-invite-credential-mail', compact('main_image_path', 'document_desctiption', 'aditional_image_path'));
    }


    public function sendConbineEmailToInstitute(Request $request)
    {

        try {




            $data = [];
            $data['academic_group_id'] = $request->academic_group_id;
            $data['division_id'] = $request->division_id;
            $data['district_id'] = $request->district_id;
            $data['thana_id'] = $request->thana_id;
            $data['academic_education_level_id'] = $request->academic_education_level_id;
            $data['academic_institute_management_type_id'] = $request->academic_institute_management_type_id;
            $data['gender_id'] = $request->gender_id;
            $data['accepted_as_site'] = $request->accepted_as_site;

            $email_id = $request->email_id;
            $confirmed = $request->confirmed;

            if (count($request->all_institute_id) <= 0) {
                throw new Error('Please select Institute !');
            }


            if (count($request->all_institute_id) > 0) {
                $email_array = AllInstituteList::whereIn('id', $request->all_institute_id)
                    ->pluck('institution_email')->filter()
                    ->toArray();
            } else {
                $email_array = AllInstituteList::when($data['academic_group_id'], function ($query) use ($data) {
                    return $query->where('academic_group_id', $data['academic_group_id']);
                })
                    ->when($data['division_id'], function ($query) use ($data) {
                        return $query->where('division_id', $data['division_id']);
                    })
                    ->when($data['district_id'], function ($query) use ($data) {
                        return $query->where('district_id', $data['district_id']);
                    })
                    ->when($data['thana_id'], function ($query) use ($data) {
                        return $query->where('thana_id', $data['thana_id']);
                    })
                    ->when(!empty($data['academic_education_level_id']), function ($query) use ($data) {
                        return $query->where('academic_education_level_id', $data['academic_education_level_id']);
                    })
                    ->when($data['academic_institute_management_type_id'], function ($query) use ($data) {
                        return $query->where('academic_institute_management_type_id', $data['academic_institute_management_type_id']);
                    })
                    ->when($data['gender_id'], function ($query) use ($data) {
                        return $query->where('gender_id', $data['gender_id']);
                    })
                    ->where('accepted_as_site', $data['accepted_as_site'])
                    ->where('status', true)
                    ->pluck('institution_email')
                    ->filter()
                    ->toArray();
            }



            if (count($email_array) < 1) {
                throw new Error('No Institute found for the condition !');
            }


            if (!$confirmed) {

                return Response::json(['message' => 'You are going to send email:' . count($email_array) . ' Institute'], 412);
            } else {


                $email_detail = EduWebMailDocument::where('id', $email_id)->first();



                $document_name = $email_detail->document_name;
                $main_image_path = $email_detail->main_image_path;
                $document_desctiption = $email_detail->document_desctiption;
                $aditional_image_path = $email_detail->aditional_image_path;


                foreach ($email_array as $key => $value) {

                    $subject = $document_name;

                    $data = [
                        'main_image_path' => $main_image_path,
                        'document_desctiption' => $document_desctiption,
                        'aditional_image_path' => $aditional_image_path,
                    ];

                    $user_mail = $value ?? 'edudeskbd@gmail.com';
                    Mail::to([$user_mail])->send(new \App\Mail\Edu\SendMailToInstitute($subject, $data));
                    // Mail::to('mahmudaljahin@gmail.com')->send(new \App\Mail\Edu\SendMailToInstitute('Test Subject', $data));

                    //Mail::to(['eduworlderp@gmail.com'])->send(new SendMailToInstitute($subject, $data));


                }








                return Response::json(['mode' => 'Success', 'message' => ''], 200);
                //                return Response::json(['mode' => 'Success', 'message' => ''], 200);
            }
        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }



    public function deleteWebMailDesign(Request $request)
    {

        $this->eduWebMailDocument->where('id', $request->edu_web_mail_document_id)->delete();

        return response()->json(['message' => 'Successfully Delete'], 200);
    }
}
