<?php

namespace App\Http\Controllers\Edu\NonSite;

use App\Imports\Edu\NonSiteEntryImport;
use App\Models\Academic\AcademicEducationLevel;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicInstituteManagementType;
use App\Models\District\District;
use App\Models\Division\Division;
use App\Models\Edu\NonSite\AllInstituteList;
use App\Models\Edu\NonSite\AllInstituteListExcel;
use App\Models\Gender\Gender;
use App\Models\Thana\Thana;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Maatwebsite\Excel\Facades\Excel;
use PDF;

class NonSiteEntryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Institute list';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getAcademicGroupDivisionDistrictThanaList()
    {

        $academic_group_list = AcademicGroup::get();
        $division = Division::get();
        $division_list = array_values(array_sort($division, function ($value) {
            return $value['division_name'];
        }));



        $district = District::get();
        $district_list = array_values(array_sort($district, function ($value) {
            return $value['district_name'];
        }));


        $thana = Thana::get();
        $thana_list = array_values(array_sort($thana, function ($value) {
            return $value['thana_name'];
        }));


        $education_level_list = AcademicEducationLevel::orderBy('name')->get();
        $management_list = AcademicInstituteManagementType::orderBy('name')->get();
        $gender_list = Gender::get();


        return response()->json(
            [
                'academic_group_list' => $academic_group_list,
                'division_list' => $division_list,
                'district_list' => $district_list,
                'thana_list' => $thana_list,
                'education_level_list' => $education_level_list,
                'management_list' => $management_list,
                'gender_list' => $gender_list,


            ]
        );
    }



    public function getNonSiteInstituteListPdf(Request $request)
    {
       
        $data = json_decode($request->input('data'), true);

        $NonSiteInstituteList = collect($data)->transform(function ($institute) {
            return [
                'id' => $institute['id'],
                'academic_group_id' => $institute['academic_group_id'],
                'division_name' => $institute['division_name'] ?? '',
                'division_id' => $institute['division_id'] ?? '',
                'district_name' => $institute['district_name'] ?? '',
                'district_id' => $institute['district_id'] ?? '',
                'thana_name' => $institute['thana_name'] ?? '',
                'thana_id' => $institute['thana_id'] ?? '',
                'eiin' => $institute['eiin'] ?? '',
                'institution_name' => $institute['institution_name'] ?? '',
                'institution_mobile' => $institute['institution_mobile'] ?? '',
                'institution_email' => $institute['institution_email'] ?? '',
                'accepted_as_site' => $institute['accepted_as_site'] ?? 0,
                'academic_education_level_name' => $institute['academic_education_level_name'] ?? '',
                'academic_education_level_id' => $institute['academic_education_level_id'] ?? '',
                'academic_institute_management_type_name' => $institute['academic_institute_management_type_name'] ?? '',
                'academic_institute_management_type_id' => $institute['academic_institute_management_type_id'] ?? '',
                'gender_name' => $institute['gender_name'] ?? '',
                'gender_id' => $institute['gender_id'] ?? '',
            ];
        });

        $report_tittle = 'Non Site Institute List';


        $pdf = PDF::loadView('default.non_site_institute', compact('report_tittle', 'NonSiteInstituteList'));
        return $pdf->stream(time()  . '-institute.pdf');
    }
    public function getNonSiteInstituteList(Request $request)
    {


        $data = $request->all();


        $search_txt = $request->search_txt;
        $status = $request->status;
        $paginate = $request->paginate ?? 20;
        $txt = '%' . $search_txt . '%';


        $institute_list = AllInstituteList::with([
            'division',
            'district',
            'thana',
            'academicEducationLevel',
            'academicInstituteManagementType',
            'gender'
        ])
            ->when($data['academic_group_id'], function ($query) use ($data) {
                return $query->where('academic_group_id', $data['academic_group_id']);
            })->when($data['division_id'], function ($query) use ($data) {
                return $query->where('division_id', $data['division_id']);
            })->when($data['district_id'], function ($query) use ($data) {
                return $query->where('district_id', $data['district_id']);
            })->when($data['thana_id'], function ($query) use ($data) {
                return $query->where('thana_id', $data['thana_id']);
            })->when(!empty($data['academic_education_level_id']), function ($query) use ($data) {
                return $query->where('academic_education_level_id', $data['academic_education_level_id']);
            })
            ->when($data['academic_institute_management_type_id'], function ($query) use ($data) {
                return $query->where('academic_institute_management_type_id', $data['academic_institute_management_type_id']);
            })
            ->when($data['gender_id'], function ($query) use ($data) {
                return $query->where('gender_id', $data['gender_id']);
            })
            ->where('accepted_as_site',  $data['accepted_as_site'])
            ->when($search_txt, function ($qu) use ($txt) {
                return $qu->where(function ($query) use ($txt) {
                    $query->where('institution_email', 'LIKE', $txt)
                        ->orWhere('institution_mobile', 'LIKE', $txt)
                        ->orWhere('institution_name', 'LIKE', $txt);
                });
            })
            ->paginate($paginate);




        $institute_list->getCollection()->transform(function ($institute) {

            return [


                'id' => $institute->id,
                'academic_group_id' => $institute->academic_group_id,
                'division_name' => $institute->division->division_name ?? '',
                'division_id' => $institute->division_id ?? '',
                'district_name' => $institute->district->district_name ?? '',
                'district_id' => $institute->district_id ?? '',
                'thana_name' => $institute->thana->thana_name ?? '',
                'thana_id' => $institute->thana_id ?? '',
                'eiin' => $institute->eiin ?? '',

                'institution_name' => $institute->institution_name ?? '',
                'institution_mobile' => $institute->institution_mobile ?? '',
                'institution_email' => $institute->institution_email ?? '',
                'accepted_as_site' => $institute->accepted_as_site,

                'academic_education_level_name' => $institute->academicEducationLevel->name ?? '',
                'academic_education_level_id' => $institute->academic_education_level_id ?? '',
                'academic_institute_management_type_name' => $institute->academicInstituteManagementType->name ?? '',
                'academic_institute_management_type_id' => $institute->academic_institute_management_type_id ?? '',
                'gender_name' => $institute->gender->gender_name ?? '',
                'gender_id' => $institute->gender_id ?? '',

            ];
        });


        return $institute_list;
    }




    public function createNonSiteInstituteInfo(Request $request)
    {


        $AllInstituteList = AllInstituteList::where('institution_email', $request->institution_email)->first();

        if ($AllInstituteList) {
            return Response::json(['message' => 'This Institute is present!', 'mode' => 'Error'], 412);
        } else {

            $AllInstituteList = new AllInstituteList();

            $AllInstituteList->academic_group_id = $request->academic_group_id;
            $AllInstituteList->division_id = $request->division_id;
            $AllInstituteList->district_id = $request->district_id;
            $AllInstituteList->thana_id = $request->thana_id;
            $AllInstituteList->eiin = $request->eiin;
            $AllInstituteList->institution_name = $request->institution_name;
            $AllInstituteList->academic_education_level_id = $request->academic_education_level_id;
            $AllInstituteList->academic_institute_management_type_id = $request->academic_institute_management_type_id;
            $AllInstituteList->institution_mobile = $request->institution_mobile;
            $AllInstituteList->institution_email = $request->institution_email;
            $AllInstituteList->gender_id = $request->gender_id;
            $AllInstituteList->accepted_as_site = $request->accepted_as_site;

            $AllInstituteList->save();
        }




        return Response::json([
            'message' => 'Successfully Save',
            'mode' => 'success'
        ], 200);
    }





    public function updateNonSiteInstituteInfo(Request $request)
    {

        $AllInstituteList = AllInstituteList::where('id', $request->id)->first();

        $AllInstituteList->academic_group_id = $request->academic_group_id;
        $AllInstituteList->division_id = $request->division_id;
        $AllInstituteList->district_id = $request->district_id;
        $AllInstituteList->thana_id = $request->thana_id;
        $AllInstituteList->eiin = $request->eiin;
        $AllInstituteList->institution_name = $request->institution_name;
        $AllInstituteList->academic_education_level_id = $request->academic_education_level_id;
        $AllInstituteList->academic_institute_management_type_id = $request->academic_institute_management_type_id;
        $AllInstituteList->institution_mobile = $request->institution_mobile;
        $AllInstituteList->institution_email = $request->institution_email;
        $AllInstituteList->gender_id = $request->gender_id;
        $AllInstituteList->accepted_as_site = $request->accepted_as_site;

        $AllInstituteList->save();


        return Response::json([
            'message' => 'Successfully Updated',
            'mode' => 'success'
        ], 200);
    }


    public function deleteNonSiteInstituteInfo(Request $request)
    {

        AllInstituteList::where('id', $request->id)->delete();

        //        AllInstituteList::truncate();

        return Response::json([
            'message' => 'Successfully Deleted',
            'mode' => 'success'
        ], 200);
    }

    /**
     * @param Request $request
     */
    public function newInstituteEntryExcelFileUpload(Request $request)
    {

        if (!($request->academic_group_id)) {
            return Response::json(['message' => 'Plese Select Academic Group!', 'mode' => 'Error'], 412);
        }


        $fileName = time() . '.' . $request->file->getClientOriginalExtension();
        $request->file->move(storage_path('pdf'), $fileName);




        $import = new NonSiteEntryImport;
        Excel::import($import, storage_path('pdf') . '/' . $fileName);
        $row_count = $import->getRowCount();


        $get_excel_all_data = AllInstituteListExcel::with(['divisionlist', 'districtlist', 'thanalist'])
            ->get();


        AllInstituteListExcel::where('id', '>=', 1)->delete();
        //        AllInstituteListExcel::truncate();

        $email_ids = $get_excel_all_data->pluck('institution_email')->unique();



        $check_same_email = AllInstituteList::whereIn('institution_email', $email_ids)
            ->get();

        if (count($check_same_email) > 0) {
            $same_email = $check_same_email->pluck('institution_email')->unique();
            $excel_data_list = $get_excel_all_data->whereNotIn('institution_email', $same_email);
        } else {
            $excel_data_list = $get_excel_all_data;
        }

        $created = [];
        foreach ($excel_data_list as $key => $value) {

            \Log::info($value->districtlist->district_name);

            $AllInstituteList = new AllInstituteList();


            $AllInstituteList->academic_group_id = $request->academic_group_id;
            $AllInstituteList->division_id = $value->divisionlist->division_id;
            $AllInstituteList->district_id = $value->districtlist->district_id;
            $AllInstituteList->thana_id = $value->thanalist ? $value->thanalist->thana_id : null;
            $AllInstituteList->eiin = $value['eiin'];
            $AllInstituteList->institution_name = $value['institution_name'];
            $AllInstituteList->academic_education_level_id = $value->academic_education_level['id'];
            $AllInstituteList->academic_institute_management_type_id = $value->academic_institute_management_type['id'];
            $AllInstituteList->institution_mobile = $value['institution_mobile'];
            $AllInstituteList->institution_email = strtolower(str_replace(' ', '', $value['institution_email']));
            $AllInstituteList->gender_id = $value->gender['id'];
            $AllInstituteList->status = true;
            $AllInstituteList->accepted_as_site = false;

            $AllInstituteList->save();


            //            $created[] = [
            //                'division_id' => $value->divisionlist->division_id,
            //                'district_id' => $value->districtlist->district_id,
            //                'thana_id' => $value->thanalist?$value->thanalist->thana_id:null,
            //                'eiin' => $value['eiin'],
            //                'institution_name' => $value['institution_name'],
            //                'academic_education_level_id' => $value->academic_education_level['id'],
            //                'academic_institute_management_type_id' => $value->academic_institute_management_type['id'],
            //                'institution_mobile' => $value['institution_mobile'],
            //                'institution_email' => strtolower(str_replace(' ', '', $value['institution_email'])),
            //                'gender_id' => $value->gender['id'],
            //                'status' => true,
            //                'accepted_as_site' => false,
            //
            //            ];

        }

        //        if(count($created)>0){
        //            AllInstituteList::insert($created);
        //        }



        return Response::json([
            'message' => 'Successfully Updated',
            'mode' => 'success'
        ], 200);
    }
}
