<?php

namespace App\Http\Controllers\Edu\PaymentGateway;

use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Academic\AcademicPaymentType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Error;


class AcademicPaymentTypeController extends Controller
{
    private $academicPaymentType;

    /**
     * DesignationController constructor.
     * @param Designation $designation
     */
    public function __construct(AcademicPaymentType $academicPaymentType)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->academicPaymentType = $academicPaymentType;
    }

    public function index()
    {

        $viewType = 'Academic Payment Type';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.designation.index', compact('viewType', 'model'));

    }

    /**
     * @param Request $validatedRequest
     * @return \Illuminate\Http\RedirectResponse|null
     */
    public function getAcademicPaymentTypeList()
    {
        $payment_type_list =  $this->academicPaymentType->where('status', 1)->get();
        return $payment_type_list;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getAcademicPaymentTypeListWithPagination(Request $request)
    {
        $paginate = $request->paginate ?? 15;
        $search_txt = $request->search_txt;
//        return $search_with_payment_type;

        $txt = '%' . $search_txt . '%';

//
//        $academic_payment_list =  AcademicPaymentType::where('status', 1)
//            ->paginate($paginate);

        $academic_payment_list =  AcademicPaymentType::when($search_txt, function ($q) use($txt){
                $q->where('name', 'LIKE', $txt)
                    ->orWhere('name_key', 'LIKE', $txt);

            })
            ->where('status', 1)
            ->paginate($paginate);



        return $academic_payment_list ;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, AcademicPaymentType $academicPaymentType)
    {
      
//        return $request;
        //==============validation=============
        $this->validate($request, [
            "name" => "required",
            "name_key" => "required",
        ]);


        if (count($academicPaymentType->ownFields) > 0) {
            foreach ($academicPaymentType->ownFields as $field) {
                if ($request->{$field}) {
                    $academicPaymentType->{$field} = $request->{$field};
                }
            }
            $academicPaymentType->status = $request->status;
            $academicPaymentType->save();
        }

        return Response::json(['message' => 'Payment Type Successfully Saved!', 'mode' => 'Saved!'], 200);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
//        return $request->academic_online_payment_marchent_type_id['id'];
        //==============validation=============


        $academicPaymentType = AcademicPaymentType::findOrFail($request->id);
        if (count($academicPaymentType->ownFields) > 0) {
            foreach ($academicPaymentType->ownFields as $field) {
                if ($request->{$field}) {
                    $academicPaymentType->{$field} = $request->{$field};
                }
            }

            $academicPaymentType->status = $request->status;
            $academicPaymentType->save();
        }
        return Response::json(['message' => 'Payment Type Successfully Updated!', 'mode' => 'Updated!'], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $paymentType = AcademicPaymentType::where('id',$id)->first();
        $check_used = AcademicOnlinePaymentMethod::where('payment_type_key', $paymentType->name_key)->first();
        if($check_used){
            throw new Error('Sorry! can not be deleted! this payment type is used!');
        }else{
            $paymentTypeDelete = $paymentType->delete();
            return Response::json(['message' => 'Payment Type Successfully Deleted!', 'mode' => 'Deleted!'], 200);
        }


    }
}
