<?php

namespace App\Http\Controllers\Edu\Role;

use App\Models\Edu\EduRole;
use Exception;
use HttpException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpKernel\Exception\UnprocessableEntityHttpException;
use Whoops\Exception\ErrorException;

class RoleController extends Controller
{

    private $eduRole;

    public function __construct(EduRole $eduRole)
    {
        $this->middleware('auth');
        $this->eduRole = $eduRole;
        $this->middleware('eduworlduserchecker');

    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Edu Role List";
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.edu.role.list', compact('viewType'));
    }

    public function getFullRoleList()
    {
        return EduRole::all();
    }

    public function getRolesWithPaginate()
    {
        return EduRole::paginate(15);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return JsonResponse
     */
    public function store(Request $request)
    {
        try {
            $this->validate($request, [
                'name' => 'required|unique:edu_roles',
                'description' => 'max:120'

            ]);

            if ($request->name=='administrator'){
                return JsonResponse::create(['message' => 'Can"t create administrator role!'], 410);

            }

            if (count($this->eduRole->ownFields)) {
                foreach ($this->eduRole->ownFields as $field => $ownField) {
                    if ($request->{$ownField} || $request->status) {
                        $this->eduRole->{$ownField} = $request->{$ownField};
                    }
                }
            }
            $this->eduRole->save();
            return JsonResponse::create(['message' => 'Role Created Successfully!'], 200);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        }catch (ValidationException $exception) {
           return JsonResponse::create(['message' => $exception->getMessage(),'errors'=>$exception->validator->getMessageBag()->toArray()],422);
        }catch (Exception $exception) {
            return JsonResponse::create(['message' =>  $exception->getMessage()], 410);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return JsonResponse
     */
    public function update(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'name' => 'required|unique:edu_roles,name,' . $id . ',id',
                'description' => 'max:120'

            ]);
            $eduRole = EduRole::findOrFail($id);
            if ($request->name=='administrator'){
                return JsonResponse::create(['message' => 'Can"t Do Anything with "administrator" role!'], 200);
            }

            if (count($eduRole->ownFields)) {
                foreach ($eduRole->ownFields as  $field => $ownField) {
                    if ($request->{$ownField} || $request->status) {
                        $eduRole->{$ownField} = $request->{$ownField};
                    }
                }
            }
            $eduRole->save();
            return JsonResponse::create(['message' => 'Role Updated Successfully!'], 200);

        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        }catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(),'errors'=>$exception->validator->getMessageBag()->toArray()],422);
        }catch (Exception $exception) {
            return JsonResponse::create(['message' =>  $exception->getMessage()], 410);
        }


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


}
