<?php

namespace App\Http\Controllers\Edu\Site\Report;

use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteMembership;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Web\SiteWebSiteVisitorDetail;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User\EmployeeHistory;
use Exception;
use Illuminate\Http\JsonResponse;

class SiteReportController extends Controller
{

    private $site;
    private $siteInfoSetting;
    public function __construct(SiteInfo $site, GlobalSiteInfoSetting $siteInfoSetting)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->site = $site;
        $this->siteInfoSetting = $siteInfoSetting;
    }


    public function index()
    {
        $viewType = 'Report list';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getSiteReportListWithPagination(Request $request){
        try {

            $data=$request->all();

            $site_group_id = $request->site_group_id;
            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';
            $date_range = $request->date_range ? json_decode($request->date_range) : null;


            $date_start='';
            $date_end='';
            if($date_range){
                $date_start = $date_range->start;//.' 00:00:00';
                $date_end = $date_range->end ?? $date_start;
            }


            

            $list = $this->site->with(['siteMembership'=>function($query){
                    $query->with(['package']);
                }, 'latestVisitor'])
                ->when($site_group_id, function ($q) use ($site_group_id) {
                    return $q->where('site_group_id', $site_group_id);

                })
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })
                ->withCount(['siteWebSiteVisitorDetail'=>function($query) use($date_start, $date_end){

                    $query->when($date_start, function ($querys) use ($date_start){
                        return  $querys->whereDate('created_at', '>=', $date_start);
                    });
                    $query->when($date_end, function ($querys) use ($date_end){
                        return  $querys->whereDate('created_at', '<=', $date_end);
                    });


                }])
                ->withCount(['globalStudentHistory'=>function($query){
                    $query->where('status', true);
                }])
                ->withCount(['employeeHistory'=>function($query){
                    $query->where('status', true);
                }])
                ->when($data['division_id'], function ($query) use ($data) {
                    return $query->where('division_id', $data['division_id']);
                })
                ->when($data['district_id'], function ($query) use ($data) {
                    return $query->where('district_id', $data['district_id']);
                })
                ->when($data['thana_id'], function ($query) use ($data) {
                    return $query->where('thana_id', $data['thana_id']);
                })

                ->orderBy('id')
                ->paginate($paginate);



            $site_ids = $this->site->when($site_group_id, function ($q) use ($site_group_id) {
                    return $q->where('site_group_id', $site_group_id);
                })
                ->when($data['division_id'], function ($query) use ($data) {
                    return $query->where('division_id', $data['division_id']);
                })
                ->when($data['district_id'], function ($query) use ($data) {
                    return $query->where('district_id', $data['district_id']);
                })
                ->when($data['thana_id'], function ($query) use ($data) {
                    return $query->where('thana_id', $data['thana_id']);
                })
                ->pluck('id')
                ->unique();

            $total_visitor = SiteWebSiteVisitorDetail::whereIn('site_id', $site_ids)
                    ->when($date_start, function ($querys) use ($date_start){
                        return  $querys->whereDate('created_at', '>=', $date_start);
                    })
                    ->when($date_end, function ($querys) use ($date_end){
                        return  $querys->whereDate('created_at', '<=', $date_end);
                    })
                    ->count();

            $total_student = GlobalStudentHistory::whereIn('site_id', $site_ids)
                ->where('status', true)
                ->count();

            $total_employee = EmployeeHistory::whereIn('site_id', $site_ids)
                ->where('status', true)
                ->count();
        

            $list->getCollection()->transform(function ($site_list) {

                return [

                    'id' => $site_list->id ?? 0,
                    'site_name' => $site_list->site_name,
                    'site_alias' => $site_list->site_alias,
                    'site_logo' => $site_list->site_logo,
                    'site_email' => $site_list->site_email ?? 0,
                    'site_phone' => $site_list->site_phone ?? 0,
                    'sms_balance' => $site_list->siteMembership->sms_balance ?? 0,
                    'per_sms_cost' => $site_list->siteMembership->per_sms_cost ?? 0,
                    'sms_send_company' => $site_list->siteMembership->sms_send_company ?? 0,
                    'sms_send_type' => $site_list->siteMembership->sms_send_type ?? 0,
                    'payment_amount' => $site_list->siteMembership->payment_amount ?? 0,
                    'package_name' => $site_list->siteMembership->package->name ?? 0,
                    'web_site_visitor_count' => $site_list->site_web_site_visitor_detail_count ?? 0,
                    'student_history_count' => $site_list->global_student_history_count ?? 0,
                    'employee_history_count' => $site_list->employee_history_count ?? 0,

                    'site_created_at' => $site_list->created_at ?? '',
                    'last_visitor_date' => $site_list->latestVisitor?$site_list->latestVisitor->visite_date:'',

                ];

            });







            return response()->json(
                [
                    'summary_list'=>$list,
                    'total_visitor'=>$total_visitor,
                    'total_student'=>$total_student,
                    'total_employee'=>$total_employee,


                ]);




            return response()->json($list, 200);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

}
