<?php

namespace App\Http\Controllers\Edu\Site;

use App\Models\Modules\SubModule;
use App\Models\Package\EduPackage;
use App\Models\Site\Permission\GlobalSiteRoleAccess;
use App\Models\Site\Role\GlobalSiteRole;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Session\AdmissionPaymentSession;
use App\Models\Session\PaymentSession;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\GlobalSiteStudentHeadWiseFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Student\Student;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionBoardApprove;
use App\Models\Site\TC\SiteStudentTC;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use App\Traits\Site\Fee\SonaliPayAdmissionFeeTrait;
use App\Traits\Site\Fee\SonaliPayStudentFeeTrait;
use Carbon\Carbon;

class SiteOnlinePaymentRecoveryController extends Controller
{

    use SonaliPayStudentFeeTrait, SonaliPayAdmissionFeeTrait;

    private $eduPackage;

    public function __construct(EduPackage $eduPackage)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->eduPackage = $eduPackage;
    }


    public function index()
    {

        $viewType = 'Online Payment Recovery';
        return view('default.admin.layouts.master', compact('viewType'));

    }

    public function getStudentTransactionTokenList(Request $request){

       $student=Student::where('username',$request->username)->where('status',true)->first();

       if(!$student){
           return response()->json(['status'=>410,'message'=>'Student not found'],410);
       }

       $session = PaymentSession::where('user_id', $student->id)
        ->whereBetween('created_at', [Carbon::now()->subDays(30), Carbon::now()])
        ->orderBy('id', 'DESC')
        ->get();

        return $session;

       
    }


    public function verifyStudentTransactionToken(Request $request){


        $req_data=[
            'Token'=>$request->token,
            'site_id'=>$request->site_id,
            'username'=>'EduWorldUser',
        ];

        $api_response=$this->verifyTransectionSonaliPayToken('site-student',$req_data);

        if($api_response['Status']!='200'){
            return ['Message'=>$api_response['Message'], 'Status'=>$api_response['Status']];
        }

        return $api_response;

    }

    public function updateStudentFee(Request $request){

        $this->validate($request, [
            'verified_token' => 'required',
            'transaction_id' => 'required',
            'invoice_no' => 'required',
            'invoice_date' => 'required'
        ]);

        $data=[
            'Token'=>$request->verified_token,
            'TransactionId'=>$request->transaction_id,
            'InvoiceNo'=>$request->invoice_no,
            'InvoiceDate'=>$request->invoice_date,
        ];


          $payment_update= $this->updateSoanliPayment($data);
       
          if($payment_update['status']=='200'){
            return response()->json(['message'=>'success', 'status'=>'200'], 200);
          }else{
            return response()->json(['message'=>$payment_update['message'], 'status'=>'410'], 410);
          }

      
        return response()->json(['message'=>'Site Error', 'status'=>'410'], 410);

     
    }


    public function recoveryStudentFeeSubhead(Request $request)
    {
        $student=Student::where('username',$request->username)->where('status',true)->first();
        if(!$student){
            return response()->json(['status'=>410,'message'=>'Student not found'],410);
        }

        $studentHistories=GlobalStudentHistory::where('user_id',$student->id)->where('status',1)->get();

        $student_history_ids = $studentHistories->pluck('id')->values();

        $paymentHistories=GlobalSiteStudentFeePaymentHistory::where('id',$request->payment_id)->get();

        $totalPaymentAmount=$paymentHistories->sum('paid_amount');

        $slipIds=$paymentHistories->pluck('site_student_fee_demand_slip_details_id')->values();

        // $slip_generated_ids=GlobalSiteStudentFeeDemandSlipDetails::whereIn('id',$slipIds)
        //     ->where('site_id',$student->site_id)
        //     ->where('status',0)
        //     ->get();
           // ->pluck('site_student_fee_generate_ids');

      //  dd($paymentHistories);

      $total_generated_amount=0;
      $fee_generated_ids=[];
      foreach($request->studentFeeGeneratedList as $keyss=>$feeSubhead){
          $fee_generated_ids[$keyss]=$feeSubhead['id'];
          $total_generated_amount+=$feeSubhead['amount'];
      }

        $studentFeeGenerate=GlobalSiteStudentFeeGenerate::whereIn('student_history_id',$student_history_ids)
            ->whereIn('id',$fee_generated_ids)
            ->where('status',1)
            ->get();


        if($totalPaymentAmount!=$total_generated_amount){
            return response()->json(['status'=>410,'message'=>'Payment amount and generated Amount not match!'],410);
        }

        foreach($slipIds as $slipId){
            $slipDetails=GlobalSiteStudentFeeDemandSlipDetails::where('id', $slipId)
                ->where('site_id',$student->site_id)
                ->where('status',0)
                ->first();

                $studentFeeGenerat=GlobalSiteStudentFeeGenerate::whereIn('student_history_id',$student_history_ids)
                    ->where('site_student_fee_demand_slip_detail_id',$slipId)
                    ->whereIn('id',$fee_generated_ids)
                    ->where('status',1)
                    ->get();

                if($slipDetails){
                    foreach($studentFeeGenerat as $studentFee){
                        $studentFeeGenerated=GlobalSiteStudentFeeGenerate::where('id',$studentFee->id)->first();


                        if($studentFeeGenerated){
                            $subHeadHistory=GlobalSiteStudentHeadWiseFeePaymentHistory::where('student_fee_generate_id',$studentFeeGenerated->id)
                                 ->where('status',1)
                                 ->first();
                             if($subHeadHistory){
                                 $subHeadHistory->pay_amount=$studentFeeGenerated->amount;  
                                 $subHeadHistory->amount=$studentFeeGenerated->amount;
                                 $subHeadHistory->sub_total_pay_amount=$studentFeeGenerated->amount;
                                 $subHeadHistory->save();
 
                             }else{
                                
                                $subHeadHistory= new GlobalSiteStudentHeadWiseFeePaymentHistory;
                                
                                $subHeadHistory->site_id=$slipDetails->site_id;
                                $subHeadHistory->student_history_id=$studentFeeGenerated->student_history_id;
                                $subHeadHistory->site_student_fee_payment_history_id=$request->payment_id;
                                $subHeadHistory->student_fee_generate_id=$studentFeeGenerated->id;

                                $subHeadHistory->amount=$studentFeeGenerated->amount;

                                $subHeadHistory->payable_amount=$studentFeeGenerated->amount;
                                $subHeadHistory->pay_amount=$studentFeeGenerated->amount;
                            
                                $subHeadHistory->sub_total_pay_amount=$studentFeeGenerated->amount;
                            // $subHeadHistory->sub_total_waiver_amount=$lastHistory->sub_total_waiver_amount;
                            
                                $subHeadHistory->payment_due_status=false;
                            
                                $subHeadHistory->payment_collected_status=true;
                                $subHeadHistory->collected_gateway='admin';
                                $subHeadHistory->status=true;
                                $subHeadHistory->save();
                             }
                         }

                    }

                }
            
        }

        $generated_fee_ids=$studentFeeGenerate->pluck('id')->toArray();
      //  $payment_history_ids=$paymentHistories->pluck('id')->toArray();


        $subHeadHistoryTotalAmount=GlobalSiteStudentHeadWiseFeePaymentHistory::whereIn('student_fee_generate_id',$generated_fee_ids)
                                ->where('status',1)
                                ->sum('pay_amount');

        if($totalPaymentAmount!=$subHeadHistoryTotalAmount){
            return response()->json(['status'=>410,'message'=>'Payment amount and Subhead amount not match!'],410);
        }

        return response()->json(['status'=>200,'message'=>'Payment recovery success'],200);

    }



    public function getEduStudentPaymentList(Request $request){

        
        $student=Student::where('username',$request->username)->where('status',true)->first();
        if(!$student){
            return response()->json(['status'=>410,'message'=>'Student not found'],410);
        }

        $studentHistories=GlobalStudentHistory::where('user_id',$student->id)->where('status',1)->get();

        $student_history_ids = $studentHistories->pluck('id')->values();

        $paymentHistories=GlobalSiteStudentFeePaymentHistory::whereIn('student_history_id', $student_history_ids)
            ->where('site_id',$student->site_id)
            ->where('online_payment_status',true)
         //   ->where('status',1)
            ->orderBy('id', 'ASC')
            ->get();

        return $paymentHistories;

    }


    public function getEduStudentFeeList(Request $request){

        $payHist=GlobalSiteStudentFeePaymentHistory::where('id',$request->payment_id)->first();

        $slipDetails=GlobalSiteStudentFeeDemandSlipDetails::where('id', $payHist->site_student_fee_demand_slip_details_id)
            ->where('status',0)
            ->first();

        $fee_generate_id_splite = explode(',', $slipDetails->site_student_fee_generate_ids);

      //  dd($fee_generate_id_splite);


        $studentFeeGenerat=GlobalSiteStudentFeeGenerate::with('academicFeeSubHead','academicFeeHead','academicFeeType')
            ->whereIn('id',$fee_generate_id_splite)
            ->where('status',1)
            ->get();

          //  dd($studentFeeGenerat);

        $feeGeneratedArray=[];
        $generated_amount=0;
        foreach($studentFeeGenerat as $key=>$fee){

            if ($fee->academicFeeHead->head_key == 'monthly') {
                $type = AcademicMonthName::where('id',$fee->fee_head_type_id)->first();

                $feeGeneratedArray[$key]['type_name']=$type->name;

            }
            elseif ($fee->academicFeeHead->head_key == 'examination') {
                $type = Examination::where('id',$fee->fee_head_type_id)->first();

                $feeGeneratedArray[$key]['type_name']=$type->examination_name;

            }
            elseif ($fee->academicFeeHead->head_key == 'admission') {
                $type = AcademicAdmissionFeeType::where('id',$fee->fee_head_type_id)->first();

                $feeGeneratedArray[$key]['type_name']=$type->name;

            }
            elseif ($fee->academicFeeHead->head_key == 'general') {
                $type = AcademicGeneralFeeType::where('id',$fee->fee_head_type_id)->first();

                $feeGeneratedArray[$key]['type_name']=$type->name;

            }
            else{
                $feeGeneratedArray[$key]['type_name']='';
            }



            $feeGeneratedArray[$key]['id']=$fee->id;
            $feeGeneratedArray[$key]['amount']=$fee->amount;
          //  $feeGeneratedArray[$key]['type_name']=$fee->academicFeeType?$fee->academicFeeType->name:'';
            $feeGeneratedArray[$key]['head_name']=$fee->academicFeeHead?$fee->academicFeeHead->name:'';
            $feeGeneratedArray[$key]['sub_head_name']=$fee->academicFeeSubHead?$fee->academicFeeSubHead->name:'';
            $feeGeneratedArray[$key]['amount']=$fee->amount;
            $generated_amount+=$fee->amount;
        }

     //   dd($studentFeeGenerat);
       

        return [$feeGeneratedArray,$generated_amount];

    }


    public function eduStudentGeneratedFeeUpdate(Request $request){

        $payHist=GlobalSiteStudentFeePaymentHistory::where('id',$request->payment_id)->first();

        foreach($request->studentFeeGeneratedList as $generatedFee){
            $studentFee=GlobalSiteStudentFeeGenerate::where('id',$generatedFee['id'])->where('status',1)->first();

            $studentFee->site_student_fee_demand_slip_detail_id=$payHist->site_student_fee_demand_slip_details_id;
            $studentFee->demand_slip_create_status=true;
            $studentFee->amount=$generatedFee['amount'];
            $studentFee->save();

        }

        return response()->json(['status'=>200,'message'=>'Subhead update success'],200);

      
    }

    public function eduStudentGeneratedFeeCheckAndDelete(Request $request){

        $payHist=GlobalSiteStudentFeePaymentHistory::where('id',$request->payment_id)->first();
        $slipDetails=GlobalSiteStudentFeeDemandSlipDetails::where('id', $payHist->site_student_fee_demand_slip_details_id)
            ->where('status',0)
            ->first();

            $ids = $slipDetails->site_student_fee_generate_ids;

            if (!empty($ids)) {  
                $idsArray = explode(',', $ids); 
            
                $filteredIds = array_filter($idsArray, function ($id) use ($request) {
                    return $id !== (string) $request->fee_generated_id; 
                });
            
                $newIds = implode(',', $filteredIds);

            
               $slipDetails->site_student_fee_generate_ids = $newIds; 
               $slipDetails->save(); 

            //    $studentFee=GlobalSiteStudentFeeGenerate::where('id',$request->fee_generated_id)->where('status',1)->first();
              
            //     $studentFee->site_student_fee_demand_slip_detail_id=null;
            //     $studentFee->demand_slip_create_status=false;
            //     $studentFee->save();
            }

            return response()->json(['status'=>200,'message'=>'Subhead Deleted successfully'],200);
     
    }



    public function getAdmissionTransactionTokenList(Request $request){

        $boardApproveCandite=GlobalSiteStudentAdmissionBoardApprove::where('board_roll_number',$request->admission_roll_number)->where('status',true)->first();
 
        if(!$boardApproveCandite){
            return response()->json(['status'=>410,'message'=>'Date not found'],410);
        }
 
        $session = AdmissionPaymentSession::where('site_student_admission_board_approve_id', $boardApproveCandite->id)
            ->whereBetween('created_at', [Carbon::now()->subDays(7), Carbon::now()])
            ->get();
 
         return $session;
 
     }

     public function verifyAdmissionTransactionToken(Request $request){

        $checkToken = AdmissionPaymentSession::where('site_id', $request->site_id)
            ->where('token',$request->token)
            ->first();
        
        if(!$checkToken){
            return response()->json(['Status'=>410,'Message'=>'Token not found'],410);
        }

        $req_data=[
            'Token'=>$request->token,
            'site_id'=>$request->site_id,
            'username'=>'EduWorldUser',
        ];

        $api_response=$this->verifyTransectionSonaliPayToken('site-admission',$req_data);

        if($api_response['Status']!='200'){
            return ['Message'=>$api_response['Message'], 'Status'=>$api_response['Status']];
        }

        return $api_response;

    }


    public function updateAdmissionFee(Request $request){

        $this->validate($request, [
            'verified_token' => 'required',
            'transaction_id' => 'required',
            'invoice_no' => 'required',
            'invoice_date' => 'required'
        ]);

        $data=[
            'Token'=>$request->verified_token,
            'TransactionId'=>$request->transaction_id,
            'InvoiceNo'=>$request->invoice_no,
            'InvoiceDate'=>$request->invoice_date,
        ];

        $boardApproveCandite=GlobalSiteStudentAdmissionBoardApprove::where('invoice_no',$request->invoice_no)->where('status',true)->first();
 
        if(!$boardApproveCandite){
            return response()->json(['status'=>410,'message'=>'Date not found'],410);
        }
 
          $payment_update= $this->updateSoanliAdmissionPayment($data);
       
          if($payment_update['status']=='200'){
            return response()->json(['message'=>'success', 'status'=>'200'], 200);
          }else{
            return response()->json(['message'=>$payment_update['message'], 'status'=>'410'], 410);
          }

      
        return response()->json(['message'=>'Site Error', 'status'=>'410'], 410);

     
    }



}
