<?php

namespace App\Http\Controllers;

use App\Models\Academic\AcademicGroup;
use App\Models\Company\GlobalCompany;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\StudentRegistration\GlobalSiteBaseStudentRegistrationDeclare;
use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\GlobalSiteGroupSetting;
use Artisan;
use Auth;
use Carbon\Carbon;
use Exception;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Response;
use Session;
use App\Models\Site\Web\DesingSetting\SiteWebsiteHeaderDesign;



use App\Traits\Device\OrganizeSavedDeviceLogTrait;
use App\Models\Edu\Device\DeviceLog;

class HomeController extends Controller
{
    use OrganizeSavedDeviceLogTrait;
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $auth;

    public function __construct(Guard $auth)
    {
        // $this->middleware('auth');

        $this->auth = $auth;
    }



    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       

        $viewType = trans('tittle.web.home');
        if (!$this->checkUserAlias()) {
            return view('default.auth.wrong-url', compact('viewType'));
        }

        if (Session::get("USER_TYPE") == 'eduworld') {
            return redirect()->to('/edu/application');
        }

        if (Session::get("USER_TYPE") == 'site_group' && request()->is('/')) {
            return redirect()->to('/login'); // for temporary
        }
      //  dd(Session::get('SITE_ID'));

        return view('web.index', compact('viewType'));

    }

    public function pdfPageTest(){
        return view('test.pdf-page-test');
    }


    public function organizeSavedDeviceLog1()
    {


        $now = Carbon::now();
        $now1 = Carbon::now();

        $previous_date = "2023-08-09";
        $today = "2023-08-09";

        $get_device_log = (new DeviceLog())
          //  ->whereBetween('access_date', [$previous_date, $today])
            ->where('access_date', $today)
            ->where('executed_status', 0)
            ->orderBy('access_time', 'ASC')
            ->get();

        // return $get_device_log;

        return $this->organizeSavedDeviceLog($get_device_log);

    }

    public function eduLogin()
    {
        $viewType = 'Home page';

        if ($this->auth->check()) {
            return redirect()->route('admin');
        }

        if ($this->auth->guest()) {
            if (!$this->checkUserAlias()) {
                return view('default.auth.wrong-url', compact('viewType'));
            }
        }

        return view('web.index', compact('viewType'));

        return redirect()->intended(route('admin'));
    }

    public function eduApplication()
    {

        $viewType = 'Application Form';

        if ($this->auth->check()) {
            //return redirect()->route('admin');
        }

        if ($this->auth->guest()) {
            if (!$this->checkUserAlias()) {
                return view('default.auth.wrong-url', compact('viewType'));
            }
        }

        return view('web.index', compact('viewType'));

        return redirect()->intended(route('admin'));
    }





    public function eduFeature()
    {

        $viewType = 'Feature';

//        return view('edu.mail.show-non-site-invite-credential-mail' , compact('viewType'));
//        return view('mail.user-credential-mail' , compact('viewType'));

        if ($this->auth->check()) {
            //return redirect()->route('admin');
        }

        if ($this->auth->guest()) {
            if (!$this->checkUserAlias()) {
                return view('default.auth.wrong-url', compact('viewType'));
            }
        }

        return view('web.index', compact('viewType'));

        return redirect()->intended(route('admin'));
    }




    public function checkUserAlias()
    {
        $domain = "";
        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
            $getHost = explode(".", $_SERVER['HTTP_HOST']);
            $domain = array_shift($getHost);
        }

        // Session::flush();


        $edu = ['eduworld', 'eduworlderp', 'eduworldapp', 'artshop'];

        // in_array($domain, $number_list)

        if (in_array($domain, $edu)) {

           // dd('edu');

            Session::put('USER_TYPE', 'eduworld');
            Session::put('ALIAS', 'eduworld');
            Session::put('ALIAS1', 'eduworld');
            Session::put('LOGO', 'edu.png');
            Session::put('LOGO_PATH', 'image/edu.png');
            Session::forget('FULL_NAME');

            return true;


        } else {//site_group or site


            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            if ($site_info) {//site


              //  $s_setting = $site_info->siteInfoSettings()->first();
                $s_setting = $site_info->siteInfoSettings()->whereIn('academic_group_id',explode(',',$site_info->academic_group_ids))->first();

               // dd($s_setting);

                Session::put('SITE_ID', $site_info->id);
                Session::put('ACADEMIC_GROUP_ID', $s_setting->academic_group_id ?? 0);
                Session::put('ACADEMIC_GROUP_NAME', $s_setting->academicGroup->academic_group_name ?? 0);
                Session::put('ACADEMIC_KEY', $s_setting->academicGroup->academic_key ?? 0);

                Session::put('ALIAS', $site_info->site_alias);
                Session::put('ALIAS1', $site_info->site_alias);
                Session::put('USER_TYPE', 'site');
                Session::put('FULL_NAME', $site_info->site_name);
                Session::put('LOGO_PATH', $site_info->site_logo);

                return true;

            } else if ($site_group = GlobalSiteGroup::where('group_alias', $domain)->first()) {//site_group

                Session::put('SITE_GROUP_ID', $site_group->id);
                Session::put('ALIAS', $site_group->group_alias);
                Session::put('ALIAS1', $site_group->group_alias);
                Session::put('USER_TYPE', 'site_group');
                Session::put('FULL_NAME', $site_group->name);
                Session::put('LOGO', $site_group->group_logo);
                Session::put('LOGO_PATH', 'img/site_group/logo/' . $site_group->group_logo);


                $get_acc_group = GlobalSiteGroupSetting::where('site_group_id', Session::get('SITE_GROUP_ID'))->first();
                if ($get_acc_group) {
                    $acc_gr = AcademicGroup::where('id', $get_acc_group->academic_group_id)->orderBy('serial')->first();

                    Session::put('ACADEMIC_GROUP_ID', $acc_gr->id ?? 0);
                    Session::put('ACADEMIC_GROUP_NAME', $acc_gr->academic_group_name ?? 0);
                    Session::put('ACADEMIC_KEY', $acc_gr->academic_key ?? 0);

                    return true;
                }


            } else if ($company = GlobalCompany::where('alias', $domain)->first()) {//company

                Session::put('COMPANY_ID', $company->id);
                Session::put('ALIAS', $company->alias);
                Session::put('ALIAS1', $company->alias);
                Session::put('USER_TYPE', 'company');
                Session::put('FULL_NAME', $company->name);
                Session::put('LOGO', $company->logo);
                Session::put('LOGO_PATH', 'img/company/' . $company->logo);
                return true;
            }
        }
        return false;
    }

    private function getSiteActivity()
    {
        $domain = "";
        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
            $getHost = explode(".", $_SERVER['HTTP_HOST']);
            $domain = array_shift($getHost);
        }

        $site_list = GlobalSiteInfo::select('id', 'site_logo')->where('site_alias', $domain)->first();


        $date_formate = Carbon::today();
        $today = $date_formate->format('Y-m-d');


        if ($site_list) {
            $registration_declare_group_ids = GlobalSiteBaseStudentRegistrationDeclare::where('site_id', $site_list->id)
                ->where('duration_from_date', '<=', $today)
                ->where('duration_to_date', '>=', $today)
                ->where('status', true)
                ->pluck('academic_group_id')->unique();

        } else {
            $registration_declare_group_ids = [];
        }


        if (count($registration_declare_group_ids) > 0) {
            $std_registration_declared_time_present = 1;
        } else {
            $std_registration_declared_time_present = 0;

        }


        return $std_registration_declared_time_present;
    }


    public function openReport($name)
    {
        try {
            if (!file_exists(storage_path('pdf/' . $name))) {
                return "The file existed only for 1 day and deleted today!";
            }
            return response()->file(storage_path('pdf/' . $name));

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


}
