<?php
/**
 * Created by PhpStorm.
 * User: raja
 * Date: 5/26/16
 * Time: 12:07 PM
 */

namespace App\Http\Controllers\Permission;


use App\Http\Controllers\Controller;

use App\Http\Controllers\ProjectController;
use App\Models\Menu\Menu;
use App\Models\Permission\GroupAccess;
use App\Models\Role\Role;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class GroupAccessController extends ProjectController
{
    private $groupAccess;

    public function __construct(GroupAccess $groupAccess)
    {

        $this->groupAccess = $groupAccess;
    }

    public function assignAccess(Request $request)
    {


        $accessType = $request->access_type;
        $accessRole = $request->access_role_id;
        $accessRoleName = Role::findOrfail($request->access_role_id);
        $accessMenu = $request->access_menu_id;
        $groupAccess = $this->groupAccess;


        if (file_exists(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('SITE_ALIAS') . '/' . $accessRoleName->name . '.blade.php'))) {
            unlink(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('SITE_ALIAS') . '/' . $accessRoleName->name . '.blade.php'));
        }

        return response()->json(['success'=>'Permission Process is Under Construction!']);

        $childMenus = Menu::whereParentId($accessMenu)->pluck('id')->toArray();

        if (count($childMenus)>0) {
            foreach ($childMenus as $child) {
                $hasChildAccess = $groupAccess->whereMenuId($child)->whereRoleId($accessRole)->first();

                if (!$hasChildAccess) {
                    $this->groupAccess->create([
                        'menu_id' => $child,
                        'role_id' => $accessRole,
                        'view' => true
                    ]);
                }else{
                    $hasChildAccess->delete();
                }
            }

        }

        $insertedRow = $groupAccess->whereMenuId($accessMenu)->whereRoleId($accessRole)->first();

        if(is_null($insertedRow)){

            $this->groupAccess->create([
                'menu_id'=>$accessMenu,
                'role_id'=>$accessRole,
                'view' => true
            ]);
           return response()->json(['success'=>'Permission Assigned Successfully!']);

        }else{
            $insertedRow->delete();
            return response()->json(['success'=>'Permission Removed Successfully!']);
        }


        // return response()->json(['success'=>'Permission Removed Successfully!']);
    }

    /*public function access()
    {
        dd('hello');
    }*/

}