<?php
/**
 * Created by PhpStorm.
 * User: raja
 * Date: 6/18/16
 * Time: 12:12 PM
 */

namespace App\Http\Controllers;


use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Academic\AcademicSection;
use App\Models\Attendance\StudentAttendance;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\SiteClassSessionSerialSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\SiteShiftDetails;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use App\Traits\SmsFunctionsTrait;
use Carbon\Carbon;
use DB;
use Error;
use Exception;
use File;
use Illuminate\Http\Request;
use Response;
use Session;

abstract class ProjectController extends Controller
{
    use SmsFunctionsTrait;


    private $studentAttendance;
    private $siteShiftDetails;
    private $academicClass;
    private $academicSection;
    private $periodTypeDuration;
    private $routineDetail;
    private $siteShiftClassGroupSectionSetting;
    private $routineAllocation;


    public function __construct(RoutineDetail $routineDetail, StudentAttendance $studentAttendance, RoutineAllocation $routineAllocation,
                                SiteShiftDetails $siteShiftDetails, AcademicSection $academicSection, SiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting,
                                AcademicClass $academicClass, SitePeriodTypeDuration $periodTypeDuration)


    {


        $this->studentAttendance = $studentAttendance;
        $this->siteShiftDetails = $siteShiftDetails;
        $this->academicClass = $academicClass;
        $this->academicSection = $academicSection;
        $this->routineDetail = $routineDetail;
        $this->routineAllocation = $routineAllocation;
        $this->periodTypeDuration = $periodTypeDuration;
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;

    }


    /* protected function modelList($model)
     {
         return $model->paginate(1);
     }*/


    public function deleteUserSidebar($user_id, $site_alias)
    {
        if (file_exists(base_path("resources/views/default/sidebars/" . $site_alias . '/' . $user_id . '.blade.php'))) {
            unlink(base_path("resources/views/default/sidebars/" . $site_alias . '/' . $user_id . '.blade.php'));
            return true;
        }
        return false;

    }

    public function getSiteSubModuleIds($site_id)
    {

    }

    public function clearDatabaseSessionForSiteUsers($site_id, $user_id = null)
    {


    }


    public function checkClassSectionGroup($academic_version_id, $academic_year_id, $academic_shift_id, $academic_department_id,
                                           $academic_class_id, $academic_class_group_id, $academic_section_id, $academic_session_id)
    {

        if (!$academic_version_id || !$academic_year_id || !$academic_shift_id || !$academic_class_id) {
            throw new Error("Please Select * Marked Fields!");
        }


//        check class group exist
        $group_present = SiteShiftClassGroupSectionSetting::
        where('academic_version_id', $academic_version_id)
            ->where('academic_year_id', $academic_year_id)
            ->where('academic_shift_id', $academic_shift_id)
            ->when($academic_department_id, function ($query) use ($academic_department_id) {
                return $query->where('academic_department_id', $academic_department_id);
            })
            ->where('academic_class_id', $academic_class_id)
            ->whereNotNull('academic_class_group_id')
            ->first();

        if ($group_present && !$academic_class_group_id) {
            throw new Error("Please Select Class Group!");
        }
//        check section exist
        $section_present = SiteShiftClassGroupSectionSetting::
        where('academic_version_id', $academic_version_id)
            ->where('academic_year_id', $academic_year_id)
            ->where('academic_shift_id', $academic_shift_id)
            ->when($academic_department_id, function ($query) use ($academic_department_id) {
                return $query->where('academic_department_id', $academic_department_id);
            })
            ->where('academic_class_id', $academic_class_id)
            ->first();
        if ($section_present && $section_present->academic_section_ids && !$academic_section_id) {
            throw new Error("Please Select Section!");
        }
//        check session exist for class
        $session_exist = SiteClassSessionSerialSetting::
        where('academic_class_id', $academic_class_id)
            ->first();/*
        if ($other_field){

            if ($other_field){

            }
            throw new Error("Please Select * Marked Fields!");
        }*/


        if ($session_exist && $session_exist->session_present && !$academic_session_id) {
            throw new Error("Please Select Session!");
        }
    }

    public function checkClassSection(array $data, $other_field = null)
    {


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
            throw new Error("Please Select * Marked Fields!");
        }

        $get_section_class_group_detail = SiteShiftClassGroupSectionSetting::
        where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_class_id', $data['academic_class_id'])
            ->first();

        // dd($data);

        if (!$get_section_class_group_detail) {
            throw new Error("No SiteShiftClassGroupSectionSetting");
        }


        if ($get_section_class_group_detail->academic_class_group_id && !$data['academic_class_group_id']) {
            throw new Error('Please Select Group');
        } else if ($get_section_class_group_detail->academic_section_ids && !$data['academic_section_id']) {
            throw new Error('Please Select Section');
        }


//        check class group exist
        $group_present = SiteShiftClassGroupSectionSetting::
        where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_class_id', $data['academic_class_id'])
            ->whereNotNull('academic_class_group_id')
            ->first();

        if ($group_present && !$data['academic_class_group_id']) {
            throw new Error("Please Select Class Group!");
        }


//        check section exist
        $section_present = SiteShiftClassGroupSectionSetting::
        where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_class_id', $data['academic_class_id'])
            ->first();


        if ($section_present && $section_present->academic_section_ids && !$data['academic_section_id']) {
            throw new Error("Please Select Section!");
        }
//        check session exist for class
        $session_exist = SiteClassSessionSerialSetting::
        where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('academic_class_id', $data['academic_class_id'])
            ->first();

        if ($session_exist && $session_exist->session_present && !$data['academic_session_id']) {
            throw new Error("Please Select Session!");
        }


        $SiteInfoTableData = SiteInfoSetting::select('id', 'batch_present_status')
            ->first();

        if ($SiteInfoTableData->batch_present_status && !$data['site_batch_detail_id']) {
            throw new Error("Please Select Batch!");
        }
    }


    public function checkVersionYearShiftDept(array $data)
    {


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id']) {
            throw new Error("Please Select * Marked Fields!");
        }

        $get_section_class_group_detail = SiteShiftClassGroupSectionSetting::
        where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            /*  ->when($data['academic_department_id'], function ($query) use ($data) {
                  return $query->where('academic_department_id', $data['academic_department_id']);
              })*/
            ->first();

        // dd($get_section_class_group_detail);


        if (!$get_section_class_group_detail) {
            throw new Error("No ShiftClassGroupSectionSetting Found! <a target='_blank' href='" . route('site-shift-class-group-section-setting-opening-page') . "'>Click Here</a>");
            //  return Response::json(['message' => 'No Class Found For The Year! Go: <a href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);

        }


        if (!$data['academic_department_id'] && $get_section_class_group_detail->academic_department_id) {
            throw new Error("Please Select Department!");
        }
    }

    public function convertNumberToWord($num = false)
    {
        $num = str_replace(array(',', ' '), '', trim($num));
        if (!$num) {
            return false;
        }
        $num = (int)$num;
        $words = array();
        $list1 = array('', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven',
            'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
        );
        $list2 = array('', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety', 'hundred');
        $list3 = array('', 'thousand', 'million', 'billion', 'trillion', 'quadrillion', 'quintillion', 'sextillion', 'septillion',
            'octillion', 'nonillion', 'decillion', 'undecillion', 'duodecillion', 'tredecillion', 'quattuordecillion',
            'quindecillion', 'sexdecillion', 'septendecillion', 'octodecillion', 'novemdecillion', 'vigintillion'
        );
        $num_length = strlen($num);
        $levels = (int)(($num_length + 2) / 3);
        $max_length = $levels * 3;
        $num = substr('00' . $num, -$max_length);
        $num_levels = str_split($num, 3);
        for ($i = 0; $i < count($num_levels); $i++) {
            $levels--;
            $hundreds = (int)($num_levels[$i] / 100);
            $hundreds = ($hundreds ? ' ' . $list1[$hundreds] . ' hundred' . ' ' : '');
            $tens = (int)($num_levels[$i] % 100);
            $singles = '';
            if ($tens < 20) {
                $tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
            } else {
                $tens = (int)($tens / 10);
                $tens = ' ' . $list2[$tens] . ' ';
                $singles = (int)($num_levels[$i] % 10);
                $singles = ' ' . $list1[$singles] . ' ';
            }
            $words[] = $hundreds . $tens . $singles . (($levels && ( int )($num_levels[$i])) ? ' ' . $list3[$levels] . ' ' : '');
        } //end for loop
        $commas = count($words);
        if ($commas > 1) {
            $commas = $commas - 1;
        }
        return implode(' ', $words);
    }

    function getDomain($alias)
    {

        $url = config('app.url');
        $parsedUrl = parse_url($url);
        $host = $parsedUrl['host'];
        $host_names = explode(".", $host);
        $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

        if ($host_names[count($host_names) - 1] == 'bd') {
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
        }
        if (count($host_names) == 2) {
            $bottom_host_name = $host_names[count($host_names) - 1];
        }
        $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;

        return $domain;
    }


    public function getDataArray($request)
    {


        //  \Log::info($request);
        $data = [];
        $data['academic_version_id'] = $request['academic_version_id'];
        $data['academic_year_id'] = $request['academic_year_id'];
        $data['academic_department_id'] = $request['academic_department_id'];
        $data['academic_class_id'] = $request['academic_class_id'];
        $data['academic_section_id'] = $request['academic_section_id'];
        $data['academic_shift_id'] = $request['academic_shift_id'];
        $data['academic_class_group_id'] = $request['academic_class_group_id'];
        $data['academic_period_type_id'] = $request['academic_period_type_id'] ?? null;
        $data['academic_session_id'] = $request['academic_session_id'];

        return $data;
    }


    public function getStudentHistoryDetails($data)
    {

        $student_history = (new StudentHistory())
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->first();

        $res_text = '';
        $res_text .= '<b>Version:</b>' . ($student_history->version->version_name ?? '');


        if ($student_history->year && $data['academic_year_id']) {
            $res_text .= '<b> Year:</b>' . ($student_history->year->year_name ?? '');
        }
        if ($student_history->shift && $data['academic_shift_id']) {
            $res_text .= ' <b> Shift:</b>' . ($student_history->shift->shift_name ?? '');
        }
        if ($student_history->department && $data['academic_department_id']) {
            $res_text .= ' <b>Dept:</b>' . ($student_history->department->name ?? '');
        }
        if ($student_history->stClass && $data['academic_class_id']) {
            $res_text .= ' <b>Class:</b>' . ($student_history->stClass->class_name ?? '');
        }
        if ($student_history->classGroup && $data['academic_class_group_id']) {
            $res_text .= ' <b>Group:</b>' . ($student_history->classGroup->group_name ?? '');
        }
        if ($student_history->section && $data['academic_section_id']) {
            $res_text .= ' <b>Section:</b>' . ($student_history->section->section_name ?? '');
        }


        return $res_text;
    }

    public function sendSms($site_id, $numbers, $sms_txt)
    {

        try {

            $this->sendSmsUsingQueue($numbers, $sms_txt);
            return true;

        } catch (Exception $exception) {
            $issue = new    IssueDetail();
            $issue->issue_type = 'sms';
            $issue->issue_details = $exception->getMessage();
            $issue->site_id = $site_id;
            $issue->save();

            return false;


        }
    }

    public function is_base64_string($string)  //check base 64 encode
    {
        // Check if there is no invalid character in string
        if (!preg_match('/^(?:[data]{4}:(text|image|application)\/[a-z]*)/', $string)) {
            return false;
        } else {
            return true;
        }

    }


    public function deleteFile($path)  //delete any file from path
    {

        if ($path) {
            $image_path = public_path($path);
            if (File::exists($image_path)) {
                unlink($image_path);
                return true;
            }
        }

        return false;

    }
    

    public function checkSiteGroupResultPermission($request){

        $primaryResult=AcademicResultPrimaryType::where('id', $request->academic_result_primary_type_id)->where('use_key','site_group')->first();
  // dd($primaryResult);
        if($primaryResult){          
            $permissions=GlobalSiteGroupResultPermission::where('site_id',Session::get('SITE_ID'))
                ->where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('academic_result_primary_type_id',$request->academic_result_primary_type_id)
                ->first();

              //  dd($permissions);

                if($permissions){
                    return $permissions->site_result_permission_status;
                }else{
                    return false;
                }
        }else{
            return true;
        }
    }

    public function mathValue($condition,$value){
        
        if($condition=='floor'){
            $mark_value= floor($value);
        }else if($condition=='ceil'){
            $mark_value= ceil($value);
        }else if($condition=='round'){
            $mark_value= round($value);
        }else if($condition=='original'){
            $mark_value= $this->smartTruncate($value, 2);
        }else{
            $mark_value=$value;
        }
        return $mark_value;
    }


    private function smartTruncate($value, $precision = 2)
    {
        $multiplier = pow(10, $precision);
        $truncated = intval($value * $multiplier) / $multiplier;

        if (fmod($truncated, 1.0) == 0.0) {
            return (int) $truncated;
        }
        return $truncated;

    }


    

}
