<?php

namespace App\Http\Controllers\Section;

use App\Forms\SectionForm;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Student\Section;
use App\Models\Subject\Subject;
use Illuminate\Http\Request;
use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Requests\Validator;

use App\Http\Requests;
use App\Http\Controllers\Controller;

class SectionController extends Controller
{
    use Lang, FormControll, DataHelper;

    private $section;

    /**
     * RolesController constructor.
     * @param Request $request
     * @param Role $role
     */
    public function __construct( Section $section)
    {

        $this->middleware('auth');


        $this->section = $section;
    }

    public function index(Section $section)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $sectionList = $section->paginate(20);
        //dd($sectionList);

        $viewType = 'Section List';

        return view('default.admin.section.index',compact('viewType', 'sectionList', 'locale', 'defaultLocale'));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createSectionForm()
    {
        $viewType = 'Create Section';

        return view('default.admin.section.create',compact('viewType'));

    }

    /**
     * @param Requests\Validator $validatedRequest
     * @return mixed
     */
    public function createSection(Requests\Validator $validatedRequest)
    {

        //'unique:sizes,size_value,null,null,size_metric,'.$request->size_metric.',null,null,column3,check3'


        $isCreated =  $this->section->create([
//            'student_class_id'=>$validatedRequest->get('student_class_id'),
//            'user_id'=>$validatedRequest->get('user_id'),
            'section_name'=>ucwords($validatedRequest->get('section_name')),
//            'merit_level'=>ucwords($validatedRequest->get('merit_level')),
//            'total_result_system_id'=>ucwords($validatedRequest->get('total_result_system_id')),
            'status'=>ucwords($validatedRequest->get('status'))
        ]);

        return back()->withSuccess('Successfully Created');
    }

    public function getSectionEditForm($id, SectionForm $sectionForm)
    {
        $viewType = 'Edit Section';
        $editSection = $sectionForm;
        $sectionData =$this->editFormModel($this->section->findOrFail($id)) ;
        //dd($sectionData);
        return view('default.admin.section.edit',compact('sectionData','viewType','editSection'));
    }

    public function editSection($id, Validator $validatedRequest)
    {
        $sectionToEdit = $this->section->findOrFail($id);

        $isEdited =  $sectionToEdit->update([
            'section_name'=>ucwords($validatedRequest->get('section_name')),
//            'merit_level'=>ucwords($validatedRequest->get('merit_level')),
//            'student_class_id'=>$validatedRequest->get('student_class_id'),
//            'user_id'=>$validatedRequest->get('user_id'),
//            'total_result_system_id'=>ucwords($validatedRequest->get('total_result_system_id')),
            'status'=>ucwords($validatedRequest->get('status'))
        ]);

        return $isEdited?back()->withSuccess('Successfully updated'):null;
    }

    public function deleteSection($id)
    {
//        $sectionToDelete = $this->section->findOrFail($id);
//
//        if($sectionToDelete->delete()){
//
//            return back()->withSuccess('Successfully deleted');
//        }
//        return back()->withErrors('Not successfully deleted');
    }



    public function getSectionByClass($class_id, Subject $subject)
    {



        $groupPresentCount = SiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
            ->get()
            ->count();


                    $SiteClassBaseSection = SiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('academic_class_id', $class_id)
                        ->where('academic_shift_id', 1)
                        ->first();







        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);

        $SectionDataList = AcademicSection::select('id', 'section_name')
            ->whereIn('id', $SectionData)
            ->get();

        $subjectOfClass = $subject->whereStudentClassId($class_id)->get();



        return json_encode([$SectionDataList,$subjectOfClass]);
    }








}
