<?php
/**
 * Created by PhpStorm.
 * User: raja
 * Date: 6/26/16
 * Time: 12:47 PM
 */

namespace App\Http\Controllers\Settings;


use App\Http\Controllers\Controller;
use App\Models\Menu\Menu;
use App\Models\Setting\Setting;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Http\Requests;
use App\Models\Permission\GroupAccess;
use App\Models\Role\GlobalRole;
use App\Models\Role\Role;
use App\Models\Site\SiteAccess;
use App\Subdomain\Xmlapi;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;



class SettingController extends ProjectController
{

    private $menus;
    private $setting;

    public function __construct(Menu $menu, Setting $setting )
    {
        $this->middleware('auth');
        $this->menus = $menu;
        $this->setting = $setting;

    }
    public function doSettings()
    {
    	$menus = $this->menus;
    	$viewType = 'All Settings';
    	return view('default.admin.settings.setting',compact('viewType','menus'));
    }

    public function index($id=null)
    {
        $siteid = $id;

        //dd($id);

        /*$viewType = 'Setting List';
        $settings = $this->setting->where('site_id',1)->orderBy('id','DESC')->paginate(10);
        //dd($settings);
        return view('default.admin.settings.index',compact('viewType','settings'));*/
        $viewType = 'Create Site Setting';
        $settings = $this->setting->where('site_id',$id)->get()
            ->mapWithKeys(function ($item) {
            return [$item['setting_name'] => $item['setting_value']];
        })->all();

        return view('default.admin.settings.create',compact('viewType', 'settings','siteid'));
    }


/*    public function createSiteSettingForm()
    {

    }
*/
    public function createSiteSetting(Request $validatedRequest)
    {

     foreach ($validatedRequest->configuration as $key=>$value){
         $settingToEdit = $this->setting->where('site_id', $validatedRequest->site_id)->where('setting_name', $key)->first();
         //dd($value);

             if($settingToEdit && $settingToEdit->setting_name  == $key){
                 //dd($settingToEdit->setting_name);
                 $settingToEdit->setting_value = $value;
                 //dd($value);
                 $settingToEdit->save();
             }else
             {
                 $this->setting->create([
                     'setting_name'=>$key,
                     'setting_value'=>$value,
                     'site_id'=>$validatedRequest->site_id,
                     ]);
             }

        }

        return back()->withSuccess('Successfully Created');

    }


}