<?php

namespace App\Http\Controllers\Site\Accounts\AccountsGroup;

use App\Models\Edu\Accounts\AccountsHead;
use App\Models\Site\Accounts\AccountsGroup;
use App\Models\Site\Accounts\AccountsSubGroup;
use App\Models\Site\Accounts\Ledger;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Error;
use Auth;
use Response;
use Storage;
use Session;

class AccountsGroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

     public function __construct()
     {
         $this->middleware('auth');
     }
    public function index()
    {
        $viewType = "Accounts Group";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getAccountsHeadList()
    {
        $acc_head_list = AccountsHead::where('status', 1)->get();
        return $acc_head_list;
    }

    public function getAccountsGroupList()
    {
        $acc_group_list = AccountsGroup::where('status', 1)->get();
        return $acc_group_list;
    }

    public function getAccountsGroupListByAccountsHeadId($id)
    {
        $acc_group_list = AccountsGroup::where('status', 1)->where('accounts_head_id', $id)->get();
        return $acc_group_list;
    }

    public function getAccountsGroupListWithPagination(Request $request)
    {
       $search_accounts_head_id = $request->search_accounts_head_id;
       $search_accounts_group_id = $request->search_accounts_group_id;
       $paginate = $request->paginate;

        $acc_group_list = AccountsGroup::with('accountsHead')
                                        ->where('status', 1)
                                        ->when($search_accounts_head_id, function ($q) use($search_accounts_head_id){
                                            $q->where('accounts_head_id', $search_accounts_head_id);
                                        })
                                        ->when($search_accounts_group_id, function ($qr) use($search_accounts_group_id){
                                            $qr->where('id', $search_accounts_group_id);
                                        })
                                        ->orderBy('id','ASC')->paginate($paginate);

        $accounts_head_ids = AccountsGroup::where('status', 1)->pluck('accounts_head_id');
        $account_head_list_for_search = AccountsHead::whereIn('id', $accounts_head_ids)->get();

        $acc_group_list_for_search = AccountsGroup::where('status', 1)->get();

        return [$acc_group_list, $account_head_list_for_search, $acc_group_list_for_search];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, AccountsGroup $accGroup)
    {
        //=============validation==========
        if(!$request->accounts_head_id || !$request->name){
            throw new Error('Please, fill the required fields!');
        }
        //==============create=============
        if (count($accGroup->ownFields) > 0) {
            foreach ($accGroup->ownFields as $field) {
                if ($request->{$field}) {
                    $accGroup->{$field} = $request->{$field};
                }
            }
            $accGroup->head_key = 'accountsgroup';
            $accGroup->created_date = Carbon::today();
//            $accGroup->status = 1;
            $accGroup->created_by = Auth::user()->id;

            if($accGroup->save()){
                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //=============validation==========
        if(!$request->accounts_head_id || !$request->name){
            throw new Error('Please, fill the required fields!');
        }
        //==============update=============

        $acc_group = AccountsGroup::findOrFail($request->id);
        if (count($acc_group->ownFields) > 0) {
            foreach ($acc_group->ownFields as $field) {
                if ($request->{$field}) {
                    $acc_group->{$field} = $request->{$field};
                }
            }
            $acc_group->head_key = 'accountsgroup';
            $acc_group->created_date = Carbon::today();
//            $accGroup->status = 1;
            $acc_group->created_by = Auth::user()->id;

            if($acc_group->save()){
                return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $check_use_in_sub_group = AccountsSubGroup::where('site_accounts_group_id', $id)->first();
        if($check_use_in_sub_group){
            throw new Error('Sorry! cannot delete being used in sub-group!');
        }
        $check_use_in_ledger = Ledger::where('parent_id', $id)->where('parent_head_key', 'accountsgroup')->first();
        if($check_use_in_ledger){
            throw new Error('Sorry! can not delete being used in ledger!');
        }
        $acc_group = AccountsGroup::findOrFail($id);
        if ($acc_group->delete()){
            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
        }
    }
}
