<?php

namespace App\Http\Controllers\Site\Accounts\AccountsLedger;

use App\Models\Academic\AcademicMonthName;
use App\Models\Edu\Accounts\AccountsHead;
use App\Models\Site\Accounts\Accounts;
use App\Models\Site\Accounts\AccountsGroup;
use App\Models\Site\Accounts\AccountsSubGroup;
use App\Models\Site\Accounts\Ledger;
use App\Models\Site\Accounts\SiteAccountsEmployeeSalary;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Pagination\Paginator;
use Carbon\Carbon;
use PDF;
use Error;
use Auth;
use Response;
use Storage;
use Session;

class AccountsLedgerController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Accounts Ladger";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getAccountsLedgerParentList()
    {

        $final_data_list = [];
        $srl = 0;

        $accounts_head_list = AccountsHead::where('status', 1)->get();

        $accounts_group_list = AccountsGroup::with('accountsHead')->where('status', 1)->get();

        $accounts_sub_group_list = AccountsSubGroup::with(['accountsGroup' => function ($q) {
            $q->with('accountsHead');
        }])->where('status', 1)->get();

        //         if(count($accounts_head_list)){
        //             foreach ($accounts_head_list as $key => $value){
        //                 $final_data_list[$srl]['id'] = $value->id;
        // //                $final_data_list[$srl]['name'] = $value->name.' (head)';
        //                 $final_data_list[$srl]['name'] = $value->code.'-'.$value->name;
        //                 $final_data_list[$srl]['head_key'] = $value->head_key;
        //                 $final_data_list[$srl]['data'] = $value;
        //                 $srl++;
        //             }
        //         }
        //         if(count($accounts_group_list)){
        //             foreach ($accounts_group_list as $ky => $val){
        //                 $final_data_list[$srl]['id'] = $val->id;
        // //                $final_data_list[$srl]['name'] = $val->name.' (group)';
        //                 $final_data_list[$srl]['name'] =  $val->accountsHead['code'].'-'.$val->accountsHead['name'].'>>'. $val->name;
        //                 $final_data_list[$srl]['head_key'] = $val->head_key;
        //                 $final_data_list[$srl]['data'] = $val;
        //                 $srl++;
        //             }
        //         }
        if (count($accounts_sub_group_list)) {
            foreach ($accounts_sub_group_list as $k => $v) {
                $final_data_list[$srl]['id'] = $v->id;
                //                $final_data_list[$srl]['name'] = $v->name.' (subgroup)';
                $final_data_list[$srl]['name'] = $v->accountsGroup['accountsHead']['code'] . '-' . $v->accountsGroup['accountsHead']['name'] . ' => ' . $v->accountsGroup['name'] . ' => ' . $v->name;
                $final_data_list[$srl]['head_key'] = $v->head_key;
                $final_data_list[$srl]['data'] = $v;
                $srl++;
            }
        }

        return $final_data_list;
    }

    public function ChartOfAccountsDownload(Request $request)
    {

        $parent_id = $request->parent_id;
        $parent_head_key = $request->parent_head_key;
        $ledger_id = $request->ledger_id;
        $paginate = $request->paginate;

    //    $final_data = AccountsHead::with('AccountsGroup')->get()->mapWithKeys(function($accountHead) {
    //         $AccountsGroup_id    = $accountHead->AccountsGroup->pluck('id');
    //         $AccountsSubGroup    = AccountsSubGroup::whereIn('site_accounts_group_id', $AccountsGroup_id)->get();
    //         $AccountsSubGroup_id =  $AccountsSubGroup->pluck('id');
    //         $Ledger              = Ledger::whereIn('parent_id', $AccountsSubGroup_id)->get();

    //         return [
    //             $accountHead->id => [
    //                 'accounts_head'  => $accountHead->id . '-' . $accountHead->name,
    //                 'accounts_group' => $accountHead->AccountsGroup->mapWithKeys(function($group) use ($AccountsSubGroup, $Ledger) {
    //                     $relatedSubGroups = $AccountsSubGroup->where('site_accounts_group_id', $group->id);

    //                     return [
    //                         $group->name => [
    //                             'accounts_sub_group' => $relatedSubGroups->mapWithKeys(function($subGroup) use ($Ledger) {
    //                                 $relatedLedgers = $Ledger->where('parent_id', $subGroup->id);
    //                                 return [
    //                                     $subGroup->name => $relatedLedgers->pluck('name')->toArray()
    //                                 ];
    //                             })->toArray(),
    //                         ],
    //                     ];
    //                 })->toArray(),
    //             ]
    //         ];
    //     })->toArray();
        $final_data = AccountsHead::with('AccountsGroup')->get()->mapWithKeys(function($accountHead) {
            $AccountsGroup_id    = $accountHead->AccountsGroup->pluck('id');
            $AccountsSubGroup    = AccountsSubGroup::whereIn('site_accounts_group_id', $AccountsGroup_id)->get();
            $AccountsSubGroup_id =  $AccountsSubGroup->pluck('id');
            $Ledger              = Ledger::whereIn('parent_id', $AccountsSubGroup_id)->get();

            return [
                $accountHead->id => [
                    'accounts_head'  =>  $accountHead->name,
                    'accounts_group' => $accountHead->AccountsGroup->mapWithKeys(function($group) use ($AccountsSubGroup, $Ledger) {
                        $relatedSubGroups = $AccountsSubGroup->where('site_accounts_group_id', $group->id);

                        return [
                            $group->name => [
                                'accounts_sub_group' => $relatedSubGroups->mapWithKeys(function($subGroup) use ($Ledger) {
                                    $relatedLedgers = $Ledger->where('parent_id', $subGroup->id);
                                    return [
                                        $subGroup->name => $relatedLedgers->map(function($ledger) {
                                            return [
                                                'name'           => $ledger->name,
                                                'initial_amount' => $ledger->initial_amount,
                                                'ledger_code'    => $ledger->ledger_code,
                                            ];
                                        })->toArray(),
                                    ];
                                })->toArray(),
                            ],
                        ];
                    })->toArray(),
                ]
            ];
        })->toArray();


        // return $final_data;



        // $pdf = PDF::loadView('default.site.accounts.chart-of-accounts-download', compact('final_data'))->setPaper('a4', 'landscape');
        $pdf = PDF::loadView('default.site.accounts.chart-of-accounts-download', compact('final_data'))->setPaper('a4', 'landscape')->setWarnings(false);


        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]), 'message' => 'Successfully sdfsafdsdfsd Created Card Report'], 200);

    }
    public function getAccountsLedgerListWithPagination(Request $request)
    {
        //        return $request;
        $parent_id = $request->parent_id;
        $parent_head_key = $request->parent_head_key;
        $ledger_id = $request->ledger_id;
        $paginate = $request->paginate;

        //=================ledger data list===============
        $accounts_ledger_list = Ledger::where('status', 1)
            ->when($parent_id, function ($q) use ($parent_id) {
                $q->where('parent_id', $parent_id);
            })
            ->when($parent_head_key, function ($qr) use ($parent_head_key) {
                $qr->where('parent_head_key', $parent_head_key);
            })
            ->when($ledger_id, function ($qrr) use ($ledger_id) {
                $qrr->where('id', $ledger_id);
            })
            ->orderBy('id', 'ASC')->paginate($paginate);


        $accounts_ledger_list->getCollection()->transform(function ($value, $key) {
            if ($value->parent_head_key == 'head') {
                $acc_head_name = AccountsHead::where('id', $value->parent_id)->first();
                $final_data['parent_name'] = $acc_head_name->code . '-' . $acc_head_name->name;
                //                    $final_data[$srl]['parent_name'] = $acc_head_name->name.' (head)';
            }
            if ($value->parent_head_key == 'accountsgroup') {
                $acc_group_name = AccountsGroup::with('accountsHead')->where('id', $value->parent_id)->first();
                $final_data['parent_name'] = $acc_group_name->accountsHead['code'] . '-' . $acc_group_name->accountsHead['name'] . '>>' . $acc_group_name->name;
                //                    $final_data[$srl]['parent_name'] = $acc_group_name->name.' (group)';
            }
            if ($value->parent_head_key == 'accountssubgroup') {
                $acc_sub_group_name = AccountsSubGroup::with(['accountsGroup' => function ($q) {
                    $q->with('accountsHead');
                }])->where('id', $value->parent_id)->first();
                $final_data['parent_name'] = $acc_sub_group_name->accountsGroup['accountsHead']['code'] . '-' . $acc_sub_group_name->accountsGroup['accountsHead']['name'] . '>>' . $acc_sub_group_name->accountsGroup['name'] . '>>' . $acc_sub_group_name->name;
            }

            return [
                'id' => $value->id,
                'srl' => $key,
                'data' => $value,
                'parent_name' =>  $final_data['parent_name'],
            ];
        });

        //        if(count($accounts_ledger_list)){
        //            foreach ($accounts_ledger_list as $kk => $vv){
        //                if($vv->parent_head_key == 'head'){
        //                    $acc_head_name = AccountsHead::where('id', $vv->parent_id)->first();
        //                    $final_data[$srl]['parent_name'] = $acc_head_name->name;
        ////                    $final_data[$srl]['parent_name'] = $acc_head_name->name.' (head)';
        //                }
        //                if($vv->parent_head_key == 'accountsgroup'){
        //                    $acc_group_name = AccountsGroup::with('accountsHead')->where('id', $vv->parent_id)->first();
        //                    $final_data[$srl]['parent_name'] = $acc_group_name->accountsHead['name'].'>>'. $acc_group_name->name;
        ////                    $final_data[$srl]['parent_name'] = $acc_group_name->name.' (group)';
        //                }
        //                if($vv->parent_head_key == 'accountssubgroup'){
        //                    $acc_sub_group_name = AccountsSubGroup::with(['accountsGroup'=>function($q){
        //                        $q->with('accountsHead');
        //                    }])->where('id', $vv->parent_id)->first();
        //                    $final_data[$srl]['parent_name'] = $acc_sub_group_name->accountsGroup['accountsHead']['name'].'>>'.$acc_sub_group_name->accountsGroup['name'].'>>'. $acc_sub_group_name->name;
        //                }
        //                $final_data[$srl]['srl'] = $srl;
        //                $final_data[$srl]['id'] = $vv->id;
        //                $final_data[$srl]['data'] = $vv;
        //                $srl++;
        //            }
        //
        //        }
        //        $final_paginate_data = new Paginator($final_data, $paginate);

        //=====================search ledger list===============

        $accounts_ledger_list_for_search = Ledger::where('status', 1)->get();

        $accounts_head_ids = Ledger::where('status', 1)->where('parent_head_key', 'head')->pluck('parent_id');
        $acc_head = AccountsHead::whereIn('id', $accounts_head_ids)->get();

        $accounts_group_ids = Ledger::where('status', 1)->where('parent_head_key', 'accountsgroup')->pluck('parent_id');
        $acc_group = AccountsGroup::with('accountsHead')->whereIn('id', $accounts_group_ids)->get();

        $accounts_sub_group_ids = Ledger::where('status', 1)->where('parent_head_key', 'accountssubgroup')->pluck('parent_id');
        $acc_sub_group = AccountsSubGroup::with(['accountsGroup' => function ($q) {
            $q->with('accountsHead');
        }])->whereIn('id', $accounts_sub_group_ids)->get();



        //=====================search parent list===============
        $searchable_parent_data = [];
        $sl = 0;
        if (count($acc_head)) {
            foreach ($acc_head as $k => $v) {
                //                $searchable_parent_data[$sl]['parent_name'] = $v->name.' (head)';
                $searchable_parent_data[$sl]['parent_name'] = $v->code . '-' . $v->name;
                $searchable_parent_data[$sl]['id'] = $v->id;
                $searchable_parent_data[$sl]['parent_head_key'] = $v->head_key;
                $sl++;
            }
        }
        if (count($acc_group)) {
            foreach ($acc_group as $kk => $vv) {
                //                $searchable_parent_data[$sl]['parent_name'] = $vv->name.' (group)';
                $searchable_parent_data[$sl]['parent_name'] = $vv->accountsHead['code'] . '-' . $vv->accountsHead['name'] . '>>' . $vv->name;
                $searchable_parent_data[$sl]['id'] = $vv->id;
                $searchable_parent_data[$sl]['parent_head_key'] = $vv->head_key;
                $sl++;
            }
        }
        if (count($acc_sub_group)) {
            foreach ($acc_sub_group as $kkk => $vvv) {
                $searchable_parent_data[$sl]['parent_name'] = $vvv->accountsGroup['accountsHead']['name'] . '-' . $vvv->accountsGroup['accountsHead']['name'] . '>>' . $vvv->accountsGroup['name'] . '>>' . $vvv->name;
                $searchable_parent_data[$sl]['id'] = $vvv->id;
                $searchable_parent_data[$sl]['parent_head_key'] = $vvv->head_key;
                $sl++;
            }
        }

        return [$accounts_ledger_list, $accounts_ledger_list_for_search, $searchable_parent_data];
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, Ledger $ledger)
    {

        //        return $request->accounts_ledger_parent_id['head_key'];
        //=============validation==========
        if (!$request->accounts_ledger_parent_id  || !$request->name) {
            throw new Error('Please, fill the required fields!');
        }
        //==============create=============
        if (count($ledger->ownFields) > 0) {
            foreach ($ledger->ownFields as $field) {
                if ($request->{$field}) {
                    $ledger->{$field} = $request->{$field};
                }
            }
            $root = "";
            if ($request->accounts_ledger_parent_id['head_key'] == 'head') {
                $head = AccountsHead::where('id', $request->accounts_ledger_parent_id['id'])->first();
                $root = $head->key_name;
            } else if ($request->accounts_ledger_parent_id['head_key'] == 'accountsgroup') {
                $group = AccountsGroup::where('id', $request->accounts_ledger_parent_id['id'])->with('accountsHead')->first();
                $root = $group->accountsHead['key_name'];
            } else if ($request->accounts_ledger_parent_id['head_key'] == 'accountssubgroup') {
                $sub_group = AccountsSubGroup::where('id', $request->accounts_ledger_parent_id['id'])->with(['accountsGroup' => function ($q) {
                    $q->with('accountsHead');
                }])->first();
                 $root = $sub_group->accountsGroup['accountsHead']['key_name'];
            }
            //==========================ledger code==============================
            $ledger_code = 0;
             $last_accounts_ledger = Ledger::where('root', $root)->orderBy('id', 'DESC')->first();
            if ($root == 'currentasset') {
                if ($last_accounts_ledger) {
                    $ledger_code = $last_accounts_ledger->ledger_code + 1;
                } else {
                    $ledger_code = 10101;
                }
            }else if ($root == 'equity') {
                if ($last_accounts_ledger) {
                    $ledger_code = $last_accounts_ledger->ledger_code + 1;
                } else {
                    $ledger_code = 50001;
                }
            }
             else if ($root == 'fixedasset') {
                if ($last_accounts_ledger) {
                    $ledger_code = $last_accounts_ledger->ledger_code + 1;
                } else {
                    $ledger_code = 10201;
                }
            } else if ($root == 'currentliability') {
                if ($last_accounts_ledger) {
                    $ledger_code = $last_accounts_ledger->ledger_code + 1;
                } else {
                    $ledger_code = 20101;
                }
            } else if ($root == 'longtermliability') {
                if ($last_accounts_ledger) {
                    $ledger_code = $last_accounts_ledger->ledger_code + 1;
                } else {
                    $ledger_code = 20201;
                }
            } else if ($root == 'income') {
                if ($last_accounts_ledger) {
                    $ledger_code = $last_accounts_ledger->ledger_code + 1;
                } else {
                    $ledger_code = 30001;
                }
            } else if ($root == 'expense') {
                if ($last_accounts_ledger) {
                    $ledger_code = $last_accounts_ledger->ledger_code + 1;
                } else {
                    $ledger_code = 40001;
                }
            }
            //================================================
            $ledger->ledger_code = $ledger_code;
            $ledger->parent_head_key = $request->accounts_ledger_parent_id['head_key'];
            $ledger->root = $root;
            $ledger->parent_id = $request->accounts_ledger_parent_id['id'];
            $ledger->created_date = Carbon::today();
            //            $accGroup->status = 1;
            $ledger->created_by = Auth::user()->id;

            if ($ledger->save()) {
                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //        return $request;
        //=============validation==========
        if (!$request->accounts_ledger_parent_id  || !$request->name) {
            throw new Error('Please, fill the required fields!');
        }

        //==============update=============
        $check_accounts_use = Accounts::where('site_accounts_ledger_id', $request->id)->first();
        $ledger = Ledger::findOrFail($request->id);
        if ($check_accounts_use && $ledger->parent_id != $request->accounts_ledger_parent_id['id'] && $ledger->parent_head_key != $request->accounts_ledger_parent_id['head_key']) {
            throw new Error('Sorry! can not change parent being used in transaction! ');
        }

        if (count($ledger->ownFields) > 0) {
            foreach ($ledger->ownFields as $field) {
                if ($request->{$field}) {
                    $ledger->{$field} = $request->{$field};
                }
            }
            $ledger->site_accounts_bank_id = $request->site_accounts_bank_id ? $request->site_accounts_bank_id : null;
            $ledger->site_accounts_party_id = $request->site_accounts_party_id ? $request->site_accounts_party_id : null;

            $ledger->count_as_cash_status =  $request->count_as_cash_status;

            $root = "";
            if ($request->accounts_ledger_parent_id['head_key'] == 'head') {
                $head = AccountsHead::where('id', $request->accounts_ledger_parent_id['id'])->first();
                $root = $head->key_name;
            } else if ($request->accounts_ledger_parent_id['head_key'] == 'accountsgroup') {
                $group = AccountsGroup::where('id', $request->accounts_ledger_parent_id['id'])->with('accountsHead')->first();
                $root = $group->accountsHead['key_name'];
            } else if ($request->accounts_ledger_parent_id['head_key'] == 'accountssubgroup') {
                $sub_group = AccountsSubGroup::where('id', $request->accounts_ledger_parent_id['id'])->with(['accountsGroup' => function ($q) {
                    $q->with('accountsHead');
                }])->first();
                $root = $sub_group->accountsGroup['accountsHead']['key_name'];
            }
            //==========================ledger code==============================

            if ($request->accounts_ledger_parent_id['head_key'] != $ledger->root) {
                $ledger_code = 0;
                $last_accounts_ledger = Ledger::where('root', $root)->orderBy('id', 'DESC')->first();
                if ($root == 'currentasset') {
                    if ($last_accounts_ledger) {
                        $ledger_code = $last_accounts_ledger->ledger_code + 1;
                    } else {
                        $ledger_code = 10101;
                    }
                } else if ($root == 'fixedasset') {
                    if ($last_accounts_ledger) {
                        $ledger_code = $last_accounts_ledger->ledger_code + 1;
                    } else {
                        $ledger_code = 10201;
                    }
                } else if ($root == 'currentliability') {
                    if ($last_accounts_ledger) {
                        $ledger_code = $last_accounts_ledger->ledger_code + 1;
                    } else {
                        $ledger_code = 20101;
                    }
                } else if ($root == 'longtermliability') {
                    if ($last_accounts_ledger) {
                        $ledger_code = $last_accounts_ledger->ledger_code + 1;
                    } else {
                        $ledger_code = 20201;
                    }
                } else if ($root == 'income') {
                    if ($last_accounts_ledger) {
                        $ledger_code = $last_accounts_ledger->ledger_code + 1;
                    } else {
                        $ledger_code = 30001;
                    }
                } else if ($root == 'expense') {
                    if ($last_accounts_ledger) {
                        $ledger_code = $last_accounts_ledger->ledger_code + 1;
                    } else {
                        $ledger_code = 40001;
                    }
                }
                $ledger->ledger_code = $ledger_code;
            }

            //================================================

            $ledger->parent_head_key = $request->accounts_ledger_parent_id['head_key'];
            $ledger->root = $root;
            $ledger->parent_id = $request->accounts_ledger_parent_id['id'];
            $ledger->initial_amount = $request->initial_amount;
            $ledger->created_date = Carbon::today();
            //            $accGroup->status = 1;
            $ledger->created_by = Auth::user()->id;

            if ($ledger->save()) {
                return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        //==========check use in accounts=============
        $check_accounts = Accounts::where('site_accounts_ledger_id', $id)->first();
        if ($check_accounts) {
            throw new Error('Sorry! this account is used in transaction!');
        }
        $ledger = Ledger::findOrFail($id);
        if ($ledger->delete()) {
            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
        }
    }
}
