<?php

namespace App\Http\Controllers\Site\Accounts\AccountsSubGroup;

use App\Models\Edu\Accounts\AccountsHead;
use App\Models\Site\Accounts\AccountsGroup;
use App\Models\Site\Accounts\AccountsSubGroup;
use App\Models\Site\Accounts\Ledger;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Error;
use Auth;
use Response;
use Storage;
use Session;

class AccountsSubGroupController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Accounts Sub Group";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getAccountsSubGroupList()
    {
        $acc_sub_group_list = AccountsSubGroup::where('status', 1)->get();
        return $acc_sub_group_list;
    }

    public function getAccountsSubGroupListWithPagination(Request $request)
    {
        $search_accounts_head_id = $request->search_accounts_head_id;
        $search_accounts_group_id = $request->search_accounts_group_id;
        $search_accounts_sub_group_id = $request->search_accounts_sub_group_id;
        $paginate = $request->paginate;

        $acc_sub_group_list = AccountsSubGroup::with(['accountsGroup'=>function($q){
                $q->with('accountsHead');
            }])
            ->where('status', 1)
            ->when($search_accounts_head_id, function ($q) use($search_accounts_head_id){
                $q->whereHas('accountsGroup', function ($qq) use($search_accounts_head_id){
                        $qq->whereHas('accountsHead', function ($qqq) use($search_accounts_head_id){
                            $qqq->where('accounts_head_id', $search_accounts_head_id);
                    });
                });
            })
            ->when($search_accounts_group_id, function ($qr) use($search_accounts_group_id){
                $qr->where('site_accounts_group_id', $search_accounts_group_id);
            })
            ->when($search_accounts_sub_group_id, function ($qr) use($search_accounts_sub_group_id){
                $qr->where('id', $search_accounts_sub_group_id);
            })
            ->orderBy('id','ASC')->paginate($paginate);

        //==========accounts sub group=============
        $accounts_group_ids = AccountsSubGroup::where('status', 1)->pluck('site_accounts_group_id');
        $account_group_list_for_search = AccountsGroup::whereIn('id', $accounts_group_ids)->get();

        //===========accounts head=================
        $account_head_ids = $account_group_list_for_search->pluck('accounts_head_id');
        $account_head_list_for_search = AccountsHead::whereIn('id', $account_head_ids)->get();

        //==========accounts sub group=============
        $acc_sub_group_list_for_search = AccountsSubGroup::where('status', 1)->get();

        return [$acc_sub_group_list, $account_head_list_for_search, $account_group_list_for_search, $acc_sub_group_list_for_search];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, AccountsSubGroup $accSubGroup)
    {
        //=============validation==========
        if(!$request->site_accounts_group_id  || !$request->name){
            throw new Error('Please, fill the required fields!');
        }
        //==============create=============
        if (count($accSubGroup->ownFields) > 0) {
            foreach ($accSubGroup->ownFields as $field) {
                if ($request->{$field}) {
                    $accSubGroup->{$field} = $request->{$field};
                }
            }
            $accSubGroup->head_key = 'accountssubgroup';
            $accSubGroup->created_date = Carbon::today();
//            $accGroup->status = 1;
            $accSubGroup->created_by = Auth::user()->id;

            if($accSubGroup->save()){
                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //=============validation==========
        if(!$request->site_accounts_group_id  || !$request->name){
            throw new Error('Please, fill the required fields!');
        }
        //==============update=============
        $acc_sub_group = AccountsSubGroup::findOrFail($request->id);
        if (count($acc_sub_group->ownFields) > 0) {
            foreach ($acc_sub_group->ownFields as $field) {
                if ($request->{$field}) {
                    $acc_sub_group->{$field} = $request->{$field};
                }
            }
            $acc_sub_group->head_key = 'accountsgroup';
            $acc_sub_group->created_date = Carbon::today();
//            $accGroup->status = 1;
            $acc_sub_group->created_by = Auth::user()->id;

            if($acc_sub_group->save()){
                return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $check_use_in_ledger = Ledger::where('parent_id', $id)->where('parent_head_key', 'accountssubgroup')->first();
        if($check_use_in_ledger){
            throw new Error('Sorry! can not delete being used in ledger!');
        }
        $acc_group = AccountsSubGroup::findOrFail($id);
        if ($acc_group->delete()){
            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
        }
    }
}
