<?php

namespace App\Http\Controllers\Site\AssessmentResult;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Assessment\Assessment;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;
use App\Models\Assessment\ExpertiseAssessmentTypeAndTypeNoSetting;
use App\Models\Site\Assessment\SiteAssessmentDeclare;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudent;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudentSubject;
use App\Models\Site\Assessment\SiteIndividualCombineSubjectAssessmentResultStore;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentResultDetail;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Response;
use Session;

class SiteBaseAssessmentResultGenerateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Subject Assesment Generate';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getSiteDeclaredAssessmentList(Request $request){

        $data=$request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
    //                ->where('status', true)
            ->pluck('id');


        $assessment_ids = SiteAssessmentDeclare::
            where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
           // ->where('assessment_id', $request->assessment_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('assessment_id')
            ->unique()
            ->filter();
           // ->get();

           $assessments=Assessment::whereIn('id',$assessment_ids)->get();

          //  return $assessmentList;

            $test_arr=Array();
            $resultlist=[];
            foreach ($assessments as $key => $value){
    
                $check_result_present=SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_list_ids)
                    ->where('assessment_declare_id', $value->id)
                    ->pluck('id');
    
                if(count($check_result_present)>0){
                    $test_arr['result_generate_status']=true;
                }
                else{
                    $test_arr['result_generate_status']=false;
                }
    
    
                $check_result__publish_emp_panel=SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_list_ids)
                    ->where('assessment_declare_id', $value->id)
                    ->where('result_employee_publish_status', true)
                    ->first();
    
                $check_result_publish_std_panel=SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_list_ids)
                    ->where('assessment_declare_id', $value->id)
                    ->where('result_student_publish_status', true)
                    ->first();
    
                $check_result_publish_public=SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_list_ids)
                    ->where('assessment_declare_id', $value->id)
                    ->where('result_public_publish_status', true)
                    ->first();
    
                if($check_result__publish_emp_panel){
                    $test_arr['result_employee_publish_status']=true;
                }else{
                    $test_arr['result_employee_publish_status']=false;
                }
    
    
                if($check_result_publish_std_panel){
                    $test_arr['result_student_publish_status']=true;
                }else{
                    $test_arr['result_student_publish_status']=false;
                }
    
                if($check_result_publish_public){
                    $test_arr['result_public_publish_status']=true;
                }else{
                    $test_arr['result_public_publish_status']=false;
                }
    
    
    
                $test_arr['loading_result_generate_image']=false;
    
                $resultlist[$key]=array_merge($test_arr, $value->toArray());
            }
            return $resultlist;
    }


    public function createUpdateAssessmentResultRenerate(Request $request){

        $data=$request->all();

        $assessmentdeclared = SiteAssessmentDeclare::where('assessment_id', $request->assessment_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
           // ->pluck('id');
            ->get();

            $assessment_declare_ids=$assessmentdeclared->pluck('id');

         //   dd($assessment_declare_ids);

            $subject_condition_setting_ids=SubjectGroupConditionSetting::
                    where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->where('status', true)
                    ->pluck('id')
                    ->unique();



            $studentAssessmentMarksListAll=SiteAssessmentDeclareStudentSubject::whereIn('site_assessment_declare_id',$assessment_declare_ids)
                ->whereIn('site_subject_group_condition_setting_id',$subject_condition_setting_ids)
                ->where('status',true)
                ->get();
              

             $site_subject_condition_setting_ids=$studentAssessmentMarksListAll->pluck('site_subject_group_condition_setting_id')->unique();
             $assessment_type_ids=$studentAssessmentMarksListAll->pluck('assessment_type_id')->unique()->filter()->values();
                 //   dd($assessment_type_ids);
             $studentIdsList=$studentAssessmentMarksListAll->pluck('student_history_id')->unique()->filter()->values();

    
            $generateStudentRest=array_diff($studentIdsList->toArray(), $request->select_student_history_ids);
    
            if(count($generateStudentRest)>0){
                $tenStudentIDs=collect($generateStudentRest)->take(20);
            }else{
                $tenStudentIDs=[];
            }
    
            $classAllStudentlist=StudentHistory::whereIn('id', $studentIdsList)->pluck('id');

            $generatedStudentIDs=array_merge($tenStudentIDs->toArray(), $request->select_student_history_ids);
    
            $studentMarksList=$studentAssessmentMarksListAll->whereIn('student_history_id', $tenStudentIDs);

            foreach($tenStudentIDs as $student_history_id){

            foreach($assessment_type_ids as $assessment_type_id){
              
                $studentAssessmentResult = SiteStudentAssessmentResultDetail::whereIn('assessment_declare_id',$assessment_declare_ids)
                                ->where('assessment_id',$request->assessment_id)
                                ->where('assessment_type_id',$assessment_type_id)
                                ->where('student_history_id',$student_history_id)
                                ->first();
                               
                $assestype=AssessmentType::where('id',$assessment_type_id)->first();
              //   if($assestype->type_name=='PI'){
                    if(!$studentAssessmentResult){
                        $asse_declare=$assessmentdeclared->where('assessment_type_id',$assessment_type_id)->first();
                        $studentAssessmentResult= new SiteStudentAssessmentResultDetail;

                        $studentAssessmentResult->assessment_declare_id=$asse_declare->id;
                        $studentAssessmentResult->assessment_id=$request->assessment_id;
                        $studentAssessmentResult->assessment_type_id=$assessment_type_id;
                        $studentAssessmentResult->student_history_id=$student_history_id;
                        if($assestype->type_name=='BI'){
                            $studentAssessmentResult->result_type_key='BI';
                        }
                        //$studentAssessmentResult->save();
                    }

                    $assessmentMarksList=$studentMarksList->where('student_history_id',$student_history_id)
                                                        ->where('assessment_type_id',$assessment_type_id);

                    /// BI start
                    // $BI_type_no_details=[];
                    // if($assestype->type_name=='BI'){
                    //    // dd('sf');
                    //    $studentAssessmentResult->result_type_key='BI';

                    //     $bikeyss=0;
                    //     $bikeysss=0;

                    //     $assessment_type_no_ids= $assessmentMarksList->where('assessment_type_id', $assestype->id)->pluck('assessment_type_no_id')->unique();
                    //     foreach($assessment_type_no_ids as $assessment_type_no_id){
                    //          $typeNo=AssessmentTypeNo::where('id',$assessment_type_no_id)->first();
                            
                    //          $BI_type_no_details[$bikeyss]['type_no_id']=$typeNo?$typeNo->id:null;
                    //          $BI_type_no_details[$bikeyss]['type_no_name']=$typeNo?$typeNo->type_no:null;
     
                    //          $typeNoMarkList=$assessmentMarksList->where('assessment_type_no_id',$assessment_type_no_id);
                    //          $triangle_count=count($typeNoMarkList->where('assessment_type_no_mark','triangle'));
     
                            
                    //          if($triangle_count){
                    //              $BI_type_no_details[$bikeyss]['assessment_type_no_total_mark']='triangle';
                    //          }else{
                    //              $circle_count=count($typeNoMarkList->where('assessment_type_no_mark','circle'));
                    //              if($circle_count){
                    //                  $BI_type_no_details[$bikeyss]['assessment_type_no_total_mark']='circle';
                    //              }else{
                    //                  $rectangle_count=count($typeNoMarkList->where('assessment_type_no_mark','rectangle'));
                    //                  if($rectangle_count){
                    //                      $BI_type_no_details[$bikeyss]['assessment_type_no_total_mark']='rectangle';
                    //                  }else{
                    //                      $BI_type_no_details[$bikeyss]['assessment_type_no_total_mark']=null;
                    //                  }

                    //              }
                    //          }
     
                    //          $bikeyss++;
                     
                    //      }
                       
                    //     }
                    // BI end

                    $keys=0;
                    $subject_array=[];
                    $individual_subject_assessment_result_ids=[];
                        foreach($site_subject_condition_setting_ids as $subject_condition_setting_id){
                          
        
                            $studentSubjectMarksList=$assessmentMarksList->where('site_subject_group_condition_setting_id',$subject_condition_setting_id);
                            $assessment_type_no_ids= $assessmentMarksList->pluck('assessment_type_no_id')->unique();
                          //  $assessment_type_no_ids= $studentSubjectMarksList->pluck('assessment_type_no_id')->unique();
                            $type_no_details=[];
                            $keysss=0;
                            //
                            
                            foreach($assessment_type_no_ids as $assessment_type_no_id){
        
                                $typeNo=AssessmentTypeNo::where('id',$assessment_type_no_id)->first();
                               $subject_codition = SubjectGroupConditionSetting::where('id',$subject_condition_setting_id)->first();
                               $assessment_setting= ExpertiseAssessmentTypeAndTypeNoSetting::where('academic_year_id', $request->academic_year_id)
                                    ->where('academic_class_id', $request->academic_class_id)
                                    ->where('academic_subject_id', $subject_codition->academic_subject_id)
                                    ->where('assessment_id',$request->assessment_id)
                                    ->where('assessment_type_id', $assessment_type_id)
                                    ->where('assessment_type_no_id', $typeNo->id)
                                    ->first();
                              //      dd($assessment_setting);
                              //  $type_no_details[$keysss]['site_subject_group_condition_setting_id']=$subject_condition_setting_id;
                                $type_no_details[$keysss]['expertise_id']=$assessment_setting?$assessment_setting->expertise_id:null;
                                $type_no_details[$keysss]['topic_id']=$assessment_setting?$assessment_setting->topic_id:null;
                                $type_no_details[$keysss]['type_no_id']=$typeNo?$typeNo->id:null;
                                $type_no_details[$keysss]['type_no_name']=$typeNo?$typeNo->type_no:null;
        
                                $typeNoMarkList=$studentSubjectMarksList->where('assessment_type_no_id',$assessment_type_no_id);

                               
                                $triangle_count=count($typeNoMarkList->where('assessment_type_no_mark','triangle'));
        
                               
                                if($triangle_count){
                                    $type_no_details[$keysss]['assessment_type_no_total_mark']='triangle';
                                }else{
                                    $circle_count=count($typeNoMarkList->where('assessment_type_no_mark','circle'));
                                    if($circle_count){
                                        $type_no_details[$keysss]['assessment_type_no_total_mark']='circle';
                                    }else{
                                        $rectangle_count=count($typeNoMarkList->where('assessment_type_no_mark','rectangle'));
                                        if($rectangle_count){
                                            $type_no_details[$keysss]['assessment_type_no_total_mark']='rectangle';
                                        }else{
                                            $type_no_details[$keysss]['assessment_type_no_total_mark']=null;
                                        }

                                    }
                                }
                                $typeNoArray=[];
                                $keyssss=0;
                                foreach($typeNoMarkList as $type_no_item){
                                    $typeNoArray[$keyssss]['assessment_type_no_mark_id']=$type_no_item->id;
                                    $typeNoArray[$keyssss]['assessment_type_no_mark']=$type_no_item->assessment_type_no_mark;
        
                                    $keyssss++;
                                }
        
                                $type_no_details[$keysss]['assessment_type_no_mark_list']=$typeNoArray;
        
                                $keysss++;
        
                            }

                            $type_no_array=collect($type_no_details)->where('assessment_type_no_total_mark','!=',null);

                            $totalCount=count(collect($type_no_array));
                            $countTrangle=count(collect($type_no_array)->where('assessment_type_no_total_mark','triangle'));
                            $countCircle=count(collect($type_no_array)->where('assessment_type_no_total_mark','circle'));
                            $countRectangle=count(collect($type_no_array)->where('assessment_type_no_total_mark','rectangle'));
        
                            $counted_value_array=[
                                'rectangle'=>$countRectangle,
                                'circle'=>$countCircle,
                                'triangle'=>$countTrangle,
                            ];
        
                            asort($counted_value_array);
                            $count_subject_total_mark = end($counted_value_array);
                            $subject_total_mark = key($counted_value_array);
                       
                        //    $individual_subject_assessment_result = SiteIndividualCombineSubjectAssessmentResultStore::where('assessment_result_details_id',$studentAssessmentResult->id)
                        //                             ->where('student_history_id',$student_history_id)
                        //                             ->where('site_subject_group_condition_setting_id',$subject_condition_setting_id)
                        //                             ->first();

                        //         if($individual_subject_assessment_result){
                        //             $individual_subject_assessment_result->subject_total_mark=$subject_total_mark;
                        //             $individual_subject_assessment_result->total_type_no_count=$totalCount;
                        //             $individual_subject_assessment_result->result_type_no_count=$count_subject_total_mark;
                        //             $individual_subject_assessment_result->subject_detail=json_encode($type_no_details);
                        //             $individual_subject_assessment_result->status=true;
                        //             $individual_subject_assessment_result->site_id=Session::get('SITE_ID');
                        //             $individual_subject_assessment_result->save();
        
                        //         }else{
                        //          $individual_subject_assessment_result =   SiteIndividualCombineSubjectAssessmentResultStore::create([
                        //                 'site_id'=>Session::get('SITE_ID'),
                        //                 'student_history_id'=>$student_history_id,
                        //                 'assessment_result_details_id'=>$studentAssessmentResult->id,
                        //                 'site_subject_group_condition_setting_id'=>$subject_condition_setting_id,
                        //                 'subject_total_mark'=>$subject_total_mark,
                        //                 'total_type_no_count'=>$totalCount,
                        //                 'result_type_no_count'=>$count_subject_total_mark,
                        //                 'status'=>true,
                        //                 'subject_detail'=>json_encode($type_no_details),
                        //             ]);
                        //         }  
                                
                        //         $individual_subject_assessment_result_ids[$keys]['id']=$individual_subject_assessment_result->id;
                               
                                $subject_array[$keys]['site_subject_group_condition_setting_id']=$subject_condition_setting_id;
                                $subject_array[$keys]['type_no_list']=$type_no_details;
                                $subject_array[$keys]['subject_total_mark']=$subject_total_mark;
                                $subject_array[$keys]['assessment_type_id']=$assessment_type_id;
                                $subject_array[$keys]['total_type_no_count']=$totalCount;
                                $subject_array[$keys]['result_type_no_count']=$count_subject_total_mark;
                                $subject_array[$keys]['status']=true;
                               
                            $keys++;

                         
                        }
                        // return $subject_array;
        
                      //  $individual_subject_id_array=collect($individual_subject_assessment_result_ids)->pluck('id');
        
                        // $individual_subject_assessment_result = SiteIndividualCombineSubjectAssessmentResultStore::where('assessment_result_details_id',$studentAssessmentResult->id)
                        //         ->where('student_history_id',$student_history_id)
                        //         ->whereIn('id',$individual_subject_id_array)
                        //         ->get();
                       

                            // $totalSubjectCount=count($individual_subject_assessment_result);
                            // $countSubjectTrangle=count($individual_subject_assessment_result->where('subject_total_mark','triangle'));
                            // $countSubjectCircle=count($individual_subject_assessment_result->where('subject_total_mark','circle'));
                            // $countSubjectRectangle=count($individual_subject_assessment_result->where('subject_total_mark','rectangle'));
        
                            // $counted_subject_array=[
                            //     'rectangle'=>$countSubjectRectangle,
                            //     'circle'=>$countSubjectCircle,
                            //     'triangle'=>$countSubjectTrangle,
                            // ];
        
                            // asort($counted_subject_array);
                            // $count_total_mark       = end($counted_subject_array);
                            // $total_mark = key($counted_subject_array);
                           // dd($BI_type_no_details);

                        //    $studentAssessmentResult->site_individual_combine_subject_assessment_result_stores_ids	= $individual_subject_ids;
                            // $studentAssessmentResult->total_marks=$total_mark;
                            // $studentAssessmentResult->total_subject_count=$totalSubjectCount;
                            // $studentAssessmentResult->result_subject_count=$count_total_mark;
                            $studentAssessmentResult->assessment_attendance_status=true;
                            $studentAssessmentResult->site_id=Session::get('SITE_ID');
                           
                            $studentAssessmentResult->result_details=json_encode($subject_array);
                            $studentAssessmentResult->save();

                }
             //   }
            }
    



        $count_student=count($classAllStudentlist);
        $completed_percent=ceil(count($generatedStudentIDs)*100/$count_student);


        if(count($tenStudentIDs)>0){

            return response()->json(
                [
                    'generatedStudentIDs'=>$generatedStudentIDs,
                    'count_student'=>$count_student,
                    'completed_percent'=>$completed_percent,
                ]);

        }else{
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
        }


    }


    public function publishPauseAssessmentResultToPanel(Request $request){

        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
//                ->where('status', true)
            ->pluck('id');


        SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_list_ids)
            ->where('assessment_declare_id', $request->assessment_declare_id)
            ->update([
                'result_employee_publish_status'=>$request->result_employee_publish_status,
                'result_student_publish_status'=>$request->result_student_publish_status,
                'result_public_publish_status'=>$request->result_public_publish_status,
            ]);


        if($request->result_employee_publish_status && $request->result_student_publish_status){
            return Response::json(['message' => 'Result Published to Employee & Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if(!$request->result_employee_publish_status && $request->result_student_publish_status){
            return Response::json(['message' => 'Result Pause to Employee & Published to Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if($request->result_employee_publish_status && !$request->result_student_publish_status){
            return Response::json(['message' => 'Result Published to Employee & Pause to Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if(!$request->result_employee_publish_status && !$request->result_student_publish_status){
            return Response::json(['message' => 'Result Pause to Employee & Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if($request->result_public_publish_status){
            return Response::json(['message' => 'Result Published to public', 'mode' => 'Saved!'], 200);
        }
        else if(!$$request->result_public_publish_status){
            return Response::json(['message' => 'Result Pause to public', 'mode' => 'Saved!'], 200);
        }


    }


    public function deleteAssessmentResultToPanel(Request $request){
        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
//                ->where('status', true)
            ->pluck('id');

           // dd($request->all());

        // SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_list_ids)
        //     ->where('assessment_declare_id', $request->assessment_declare_id)
        //     ->update([
        //         'result_employee_publish_status'=>0,
        //         'result_student_publish_status'=>0,
        //         'result_public_publish_status'=>0,
        //     ]);

        return Response::json(['message' => 'Assessment result Delete ', 'mode' => 'Saved!'], 200);

    }

}
