<?php

namespace App\Http\Controllers\Site\Batch;

use App\Models\Edu\WeekdayName;
use App\Models\Site\Batch\BatchDetail;
use Auth;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class BatchController extends Controller
{


    private $batch;

    public function __construct(BatchDetail $batch)
    {
        $this->middleware('auth');
        $this->batch = $batch;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Assign Permission To Role';
        return view('default.admin.site.batch.list', compact('viewType'));
    }


    public function create(Request $request)
    {


        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_class_id'] || !$data['academic_shift_id']) {
            return Response::json(['message' => 'Select * Marked Field!'], 410);
        }


        $this->validate($request, [
            'batch_name' => 'required|unique:site_batch_details,batch_name,site_id' . Session::get('SITE_ID'),
//            'batch_code' => 'required|unique:site_batch_details,batch_code,site_id' . Session::get('SITE_ID'),
//            'start_date' => 'required',
//            'end_date' => 'required',
            'start_time' => 'required',
            'end_time' => 'required'
        ]);


        if (count($request->select_day_ids) > 0) {
            $day_ids = implode(',', $request->select_day_ids);
        } else {
            $day_ids = null;
        }


        $this->batch = new BatchDetail();
      //  if (count($this->batch->ownFields) > 0) {
            foreach ($this->batch->ownFields as $ownField) {
                if ($request->{$ownField}) {
                    $this->batch->{$ownField} = $request->{$ownField};
                }
            }
            $this->batch->status = $request->status??1;
            $this->batch->edu_weekday_name_ids = $day_ids;
            $this->batch->created_by = Auth::user()->id;
      //  }

        if ($this->batch->save()) {
            return Response::json(['message' => 'Saved Successfully!', 'mode' => 'Saved!'], 200);
        }

    }

    public function update(Request $request, $id)
    {


        try {
            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_session_id'] = $request->academic_session_id;


            if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_class_id'] || !$data['academic_shift_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }


            $this->validate($request, [
                'batch_name' => 'required|unique:site_batch_details,batch_name,' . $id . ',id,site_id,' . Session::get('SITE_ID'),
//                'batch_code' => 'required|unique:site_batch_details,batch_code,' . $id . ',id,site_id,' . Session::get('SITE_ID'),
//                'start_date' => 'required',
//                'end_date' => 'required',
                'start_time' => 'required',
                'end_time' => 'required'

            ]);


//            \Log::info($request);

            if (count($request->select_day_ids) > 0) {
                $day_ids = implode(',', $request->select_day_ids);
            } else {
                $day_ids = null;
            }

            $toEdit = $this->batch->findOrFail($id);

           
            if (count($toEdit->ownFields) > 0) {
               // dd($day_ids);
                foreach ($toEdit->ownFields as $ownField) {
                    if ($request->{$ownField}) {
                        $toEdit->{$ownField} = $request->{$ownField};
                    }
                }
                $toEdit->status = $request->status ?? 1;
                $toEdit->edu_weekday_name_ids = $day_ids;
                $toEdit->batch_code = $request->batch_code?$request->batch_code:null;
            }
          //  dd('$day_ids');

            if ($toEdit->save()) {
                return Response::json(['message' => 'Updated Successfully', 'mode' => 'Updated!'], 200);
            }

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);

        }
    }


    public function delete($id)
    {
        $the_role = $this->batch->findOrFail($id);
        $the_role->delete();
        return Response::json(['message' => 'Deleted Successfully', 'mode' => 'Updated!'], 200);
    }


    //CUSTOM METHOD---------------------------------

    public function getBatches(Request $request)
    {

        try {


            // \Log::info($request);

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_session_id'] = $request->academic_session_id;


            if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_class_id'] || !$data['academic_shift_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }


            $batchDetails = $this->batch
                // ->with(['classTimingDetail', 'routineAllocations.room', 'routineAllocations.employee', 'routineAllocations.subject'])
                ->whereAcademicVersionId($data['academic_version_id'])
                ->whereAcademicYearId($data['academic_year_id'])
                ->whereAcademicClassId($data['academic_class_id'])
                ->whereAcademicShiftId($data['academic_shift_id'])
                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->orderBy('id', 'DESC')
                ->get();

            //    dd($batchDetails);

            $batch_day = WeekdayName::get();


            return response()->json(
                [
                    'batchDetails' => $batchDetails,
                    'batch_day' => $batch_day,
                ]);


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);


        }


    }

    public function getActiveBatchList(Request $request)
    {

        try {


            $batch_lists = $this->batch
                ->where('status', true)
                ->orderBy('batch_name', 'ASC')
                ->get();


            return response()->json($batch_lists);


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);


        }


    }


}
