<?php

namespace App\Http\Controllers\Site\Chart;

use App\Http\Controllers\Controller;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Student\StudentHistory;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Support\Facades\DB;

class ChartController extends Controller
{
    private $StudentHistory;
    private $employee;
    private $EmployeeAttendance;
    public function __construct(StudentHistory $studentHistory,  Employee $employee, EmployeeAttendance $EmployeeAttendance)
    {
        $this->middleware('auth');
        $this->StudentHistory = $studentHistory;
        $this->employee = $employee;
        $this->EmployeeAttendance = $EmployeeAttendance;
    }

    public function getSiteStudentStatisticsForGraph()
    {

        $Students =  $this->StudentHistory->select('user_id', 'site_id')
            ->with([
                'student.gender',
                'student' => function ($query) {
                    $query->select('id',  'gender_id',);
                }
            ])
            ->get();

        $TotalMale   = 0;
        $TotalFemale = 0;
        $Totalothers = 0;

        foreach ($Students as $key => $student) {
            if ($student->student->gender->head_key == 'boys') {
                $TotalMale += 1;
            } elseif ($student->student->gender->head_key == 'girls') {
                $TotalFemale += 1;
            } elseif ($student->student->gender->head_key == 'others') {
                $Totalothers += 1;
            } else {
                $Totalothers += 1;
            }
        }
        $TotalStatistics = [$TotalMale, $TotalFemale];

        if ($Totalothers !== 0) {
            $TotalStatistics[] = $Totalothers;
        }
        return response()->json(
            $TotalStatistics,
            200
        );
    }
    public function getSiteEmployeeStatisticsForGraph()
    {
        $TotalEmployessCount = $this->employee
            ->select('id', 'username', 'religion_id', 'gender_id', 'designation_id', 'contact_number')
            ->with(['latestPhoto', 'gender', 'religion', 'designation'])
            ->where('status', true)
            ->get();

        $TotalMale = 0;
        $TotalFemale = 0;
        $TotalOthers = 0;

        foreach ($TotalEmployessCount as  $employee) {
            if ($employee->gender) {
                if ($employee->gender->gender_name == 'Male') {
                    $TotalMale += 1;
                } elseif ($employee->gender->gender_name == 'Female') {
                    $TotalFemale += 1;
                } elseif ($employee->gender->gender_name == 'Others') {
                    $TotalOthers += 1;
                }
            } else {
                $TotalOthers += 1;
            }
        }
        $TotalStatistics = [$TotalMale, $TotalFemale];

        if ($TotalOthers !== 0) {
            $TotalStatistics[] = $TotalOthers;
        }

        return response()->json(
            $TotalStatistics,
            200
        );
    }
    public function getSiteEmployeeAttendenceStatisticsForGraph()
    {
        $today          = Carbon::today();
        $previousMonths = [];


        for ($i = 1; $i <= 5; $i++) {
            $previousMonths[] = (clone $today)->subMonth($i)->format('m');
        }




        $currentYear = Carbon::now()->year;


        $data = [];
        $presentCount = 0;
        $absentCount = 0;
        $sl = 0;
        foreach ($previousMonths as $month) {

            $date = Carbon::createFromFormat('m-Y', "$month-$currentYear")->format('m-Y');
            $EmployeeAttendances = $this->EmployeeAttendance
                ->select(
                    'user_id',
                    DB::raw('MONTH(present_date) as month'),
                    DB::raw('COUNT(*) as attendance_count')
                )
                ->WhereMonth('present_date', $month)
                ->whereYear('present_date', $currentYear)
                ->groupBy('user_id', 'month')
                ->get();



            foreach ($EmployeeAttendances as $EmployeeAttendance) {
                $presentCount += $EmployeeAttendance->attendance_count;
            }


            $startDate = Carbon::createFromDate($currentYear, 6, 1);
            $endDate = $startDate->copy()->endOfMonth();


             $period = CarbonPeriod::create($startDate, $endDate);


            foreach ($period as $dt) {

                $TotalemployeesAbsent = $this->employee
                    ->select('id', 'username')
                    ->where('status', true)
                    ->where(function ($q) use ($dt) {
                        $q->whereDoesntHave('attendances', function ($q1) use ($dt) {
                            $q1->whereDate('present_date', '=', $dt);
                        });
                    })

                    ->count();
                $absentCount += $TotalemployeesAbsent;
            }

            $date = Carbon::createFromFormat('m', $month);
            $monthName = $date->format('F');


            $data[$sl]['label'] = $monthName;
            $data[$sl]['values']  = [
                ['value' => $presentCount, 'color' => '#ffaa00', 'status' => 'present'],
                ['value' => $absentCount, 'color'   => '#00aaff', 'status' => 'Absent'],
            ];
            $sl++;
            $absentCount = 0;
        }
        return response()->json([
            'data' => $data,
            'previousMonthNames' => null,
        ], 200);
    }
}
